/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.machine.block;

import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.api.blockstate.EnumSide;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.climate.IHeatCanceler;
import defeatedcrow.hac.api.climate.IHeatTile;
import defeatedcrow.hac.core.ClimateCore;
import defeatedcrow.hac.core.energy.BlockTorqueBase;
import defeatedcrow.hac.machine.block.TileHeatExchanger;
import defeatedcrow.hac.main.util.DCName;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockHeatExchanger
extends BlockTorqueBase
implements IHeatTile,
IHeatCanceler {
    public BlockHeatExchanger(String s) {
        super(Material.field_151576_e, s, 0);
        this.func_149711_c(1.5f);
        this.func_149672_a(SoundType.field_185852_e);
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return true;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileHeatExchanger();
    }

    public DCHeatTier getHeatTier(World world, BlockPos pos, BlockPos target) {
        TileEntity tile = world.func_175625_s(target);
        if (tile != null && tile instanceof TileHeatExchanger) {
            TileHeatExchanger ex = (TileHeatExchanger)tile;
            EnumFacing face = ex.getBaseSide();
            if (ex.current != null) {
                int active = this.isActive(face, pos, target);
                DCHeatTier cur = ex.current.getHeat();
                float torque = ex.getCurrentTorque();
                if (torque >= 31.5f) {
                    active *= 2;
                } else if (torque < 5.5f) {
                    active = 0;
                }
                DCHeatTier next = cur.addTier(active);
                return next;
            }
        }
        return DCHeatTier.NORMAL;
    }

    public IBlockState getPlaceState(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = super.getPlaceState(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
        if (placer != null && !placer.field_70170_p.field_72995_K && placer instanceof EntityPlayer) {
            EntityPlayer entityPlayer = (EntityPlayer)placer;
        }
        if (placer != null) {
            EnumFacing face = placer.func_174811_aO();
            if (placer.field_70125_A < -75.0f) {
                face = EnumFacing.UP;
            } else if (placer.field_70125_A > 75.0f) {
                face = EnumFacing.DOWN;
            }
            state = state.func_177226_a((IProperty)DCState.SIDE, (Comparable)EnumSide.fromFacing((EnumFacing)face.func_176734_d()));
        } else {
            state = state.func_177226_a((IProperty)DCState.SIDE, (Comparable)EnumSide.fromFacing((EnumFacing)facing.func_176734_d()));
        }
        return state;
    }

    int isActive(EnumFacing face, BlockPos to, BlockPos from) {
        if (to.equals((Object)from)) {
            return 1;
        }
        switch (face) {
            case DOWN: {
                if (to.func_177956_o() < from.func_177956_o()) {
                    return -1;
                }
                return 1;
            }
            case UP: {
                if (to.func_177956_o() > from.func_177956_o()) {
                    return -1;
                }
                return 1;
            }
            case NORTH: {
                if (to.func_177952_p() < from.func_177952_p()) {
                    return -1;
                }
                return 1;
            }
            case SOUTH: {
                if (to.func_177952_p() > from.func_177952_p()) {
                    return -1;
                }
                return 1;
            }
            case WEST: {
                if (to.func_177958_n() < from.func_177958_n()) {
                    return -1;
                }
                return 1;
            }
            case EAST: {
                if (to.func_177958_n() > from.func_177958_n()) {
                    return -1;
                }
                return 1;
            }
        }
        return 1;
    }

    public boolean isActive(IBlockState state) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        if (ClimateCore.proxy.isShiftKeyDown()) {
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Requirement ===");
            tooltip.add(DCName.STAGE.getLocalizedName() + "1: 6.0+ torque/s");
            tooltip.add(DCName.STAGE.getLocalizedName() + "2: 32.0+ torque/s");
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Output ===");
            tooltip.add(DCName.STAGE.getLocalizedName() + "1 " + DCName.HEAT.getLocalizedName() + ": " + TextFormatting.RED.toString() + "Tier \u00b11");
            tooltip.add(DCName.STAGE.getLocalizedName() + "2 " + DCName.HEAT.getLocalizedName() + ": " + TextFormatting.RED.toString() + "Tier \u00b12");
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Tips ===");
            tooltip.add(I18n.func_135052_a((String)"dcs.tip.exchanger", (Object[])new Object[0]));
        } else {
            tooltip.add(TextFormatting.ITALIC.toString() + "=== Lshift key: expand tooltip ===");
        }
    }
}

