/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.machine.block;

import com.google.common.collect.Lists;
import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.api.blockstate.EnumSide;
import defeatedcrow.hac.core.ClimateCore;
import defeatedcrow.hac.core.base.BlockContainerDC;
import defeatedcrow.hac.core.base.ITagGetter;
import defeatedcrow.hac.core.fluid.DCFluidUtil;
import defeatedcrow.hac.machine.block.TileHopperFluid;
import defeatedcrow.hac.main.ClimateMain;
import defeatedcrow.hac.main.util.DCName;
import defeatedcrow.hac.main.util.MainUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockHopperFluid
extends BlockContainerDC {
    protected static final AxisAlignedBB BASE_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    protected static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 0.125);
    protected static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.5, 0.875, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.875, 0.5, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.0, 0.5, 0.0, 0.125, 1.0, 1.0);

    public BlockHopperFluid(String s) {
        super(Material.field_151576_e, s);
        this.func_149711_c(2.0f);
        this.func_149752_b(15.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)DCState.SIDE, (Comparable)EnumSide.DOWN).func_177226_a((IProperty)DCState.POWERED, (Comparable)Boolean.valueOf(false)));
        this.field_149787_q = false;
        this.field_149786_r = 0;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    public void getCollisionBoxList(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean b) {
        BlockHopperFluid.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BASE_AABB);
        BlockHopperFluid.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)EAST_AABB);
        BlockHopperFluid.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)WEST_AABB);
        BlockHopperFluid.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SOUTH_AABB);
        BlockHopperFluid.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)NORTH_AABB);
    }

    public List<ItemStack> getSubItemList() {
        ArrayList list = Lists.newArrayList();
        list.add(new ItemStack((Block)this, 1, 0));
        return list;
    }

    public boolean onRightClick(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_175625_s(pos);
        if (player != null) {
            ItemStack heldItem = player.func_184586_b(hand);
            if (!world.field_72995_K && tile != null && tile instanceof TileHopperFluid && player != null && hand == EnumHand.MAIN_HAND) {
                if (!DCFluidUtil.onActivateDCTank((TileEntity)tile, (ItemStack)heldItem, (World)world, (IBlockState)state, (EnumFacing)side, (EntityPlayer)player)) {
                    player.openGui((Object)ClimateMain.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                } else {
                    world.func_184133_a(null, pos, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.8f, 2.0f);
                }
            }
        }
        return true;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileHopperFluid();
    }

    public IBlockState getPlaceState(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        EnumFacing face = facing.func_176734_d();
        if (face == EnumFacing.UP) {
            face = EnumFacing.DOWN;
        }
        return this.func_176223_P().func_177226_a((IProperty)DCState.SIDE, (Comparable)EnumSide.fromFacing((EnumFacing)face)).func_177226_a((IProperty)DCState.POWERED, (Comparable)Boolean.valueOf(true));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        NBTTagCompound tag;
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof ITagGetter && (tag = stack.func_77978_p()) != null) {
            ((ITagGetter)tile).setNBT(tag);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        int i = this.func_180651_a(state);
        ItemStack drop = new ItemStack((Block)this, 1, i);
        if (tile != null && tile instanceof ITagGetter) {
            NBTTagCompound tag = new NBTTagCompound();
            if ((tag = ((ITagGetter)tile).getNBT(tag)) != null) {
                drop.func_77982_d(tag);
            }
        }
        if (!world.field_72995_K) {
            EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, drop);
            float f3 = 0.05f;
            entityitem.field_70159_w = (float)world.field_73012_v.nextGaussian() * f3;
            entityitem.field_70181_x = (float)world.field_73012_v.nextGaussian() * f3 + 0.25f;
            entityitem.field_70179_y = (float)world.field_73012_v.nextGaussian() * f3;
            world.func_72838_d((Entity)entityitem);
        }
        world.func_175666_e(pos, state.func_177230_c());
        super.func_180663_b(world, pos, state);
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.updateState(worldIn, pos, state);
    }

    public void onNeighborChange(IBlockState state, World world, BlockPos pos, Block block, BlockPos from) {
        this.updateState(world, pos, state);
    }

    private void updateState(World worldIn, BlockPos pos, IBlockState state) {
        boolean flag;
        boolean bl = flag = !worldIn.func_175640_z(pos);
        if (flag != (Boolean)state.func_177229_b((IProperty)DCState.POWERED)) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)DCState.POWERED, (Comparable)Boolean.valueOf(flag)), 4);
        }
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return MainUtil.calcTankRedstone(worldIn.func_175625_s(pos));
    }

    public IBlockState func_176203_a(int meta) {
        int m = meta & 7;
        IBlockState state = this.func_176223_P().func_177226_a((IProperty)DCState.SIDE, (Comparable)EnumSide.fromIndex((int)m)).func_177226_a((IProperty)DCState.POWERED, (Comparable)Boolean.valueOf((meta & 8) > 0));
        return state;
    }

    public int func_176201_c(IBlockState state) {
        int f = 0;
        int i = 0;
        f = ((EnumSide)state.func_177229_b((IProperty)DCState.SIDE)).index;
        i = (Boolean)state.func_177229_b((IProperty)DCState.POWERED) != false ? 8 : 0;
        return i + f;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DCState.SIDE, DCState.POWERED});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        if (ClimateCore.proxy.isShiftKeyDown()) {
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Requirement ===");
            tooltip.add(DCName.NON_POWERED.getLocalizedName());
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Output ===");
            tooltip.add(DCName.ITEM.getLocalizedName() + DCName.TRANSPORT.getLocalizedName() + " (fluid container only): 1 item/5t");
            tooltip.add(DCName.FLUID.getLocalizedName() + DCName.TRANSPORT.getLocalizedName() + ": 200 mB/5t");
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Tips ===");
            tooltip.add(I18n.func_135052_a((String)"dcs.tip.hopper_flu1", (Object[])new Object[0]));
            tooltip.add(I18n.func_135052_a((String)"dcs.tip.hopper_flu2", (Object[])new Object[0]));
            tooltip.add(I18n.func_135052_a((String)"dcs.tip.hopper_flu3", (Object[])new Object[0]));
        } else {
            tooltip.add(TextFormatting.ITALIC.toString() + "=== Lshift key: expand tooltip ===");
        }
    }
}

