/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.machine.block;

import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.core.base.ITagGetter;
import defeatedcrow.hac.core.energy.BlockTorqueBase;
import defeatedcrow.hac.machine.block.TileMonitorBase;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockMonitorPanel
extends BlockTorqueBase {
    protected static final AxisAlignedBB AABB_FULL = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_AXIS_X1 = new AxisAlignedBB(0.0, 0.125, 0.125, 0.25, 0.875, 0.875);
    protected static final AxisAlignedBB AABB_AXIS_Y1 = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.25, 0.875);
    protected static final AxisAlignedBB AABB_AXIS_Z1 = new AxisAlignedBB(0.125, 0.125, 0.0, 0.875, 0.875, 0.25);
    protected static final AxisAlignedBB AABB_AXIS_X2 = new AxisAlignedBB(0.75, 0.125, 0.125, 1.0, 0.875, 0.875);
    protected static final AxisAlignedBB AABB_AXIS_Y2 = new AxisAlignedBB(0.125, 0.75, 0.125, 0.875, 1.0, 0.875);
    protected static final AxisAlignedBB AABB_AXIS_Z2 = new AxisAlignedBB(0.125, 0.125, 0.75, 0.875, 0.875, 1.0);

    public BlockMonitorPanel(String s) {
        super(Material.field_151571_B, s, 0);
        this.func_149672_a(SoundType.field_185852_e);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (DCState.hasProperty((IBlockState)state, (IProperty)DCState.SIDE)) {
            switch (DCState.getSide((IBlockState)state, (PropertyEnum)DCState.SIDE)) {
                case DOWN: {
                    return AABB_AXIS_Y1;
                }
                case UP: {
                    return AABB_AXIS_Y2;
                }
                case WEST: {
                    return AABB_AXIS_X1;
                }
                case EAST: {
                    return AABB_AXIS_X2;
                }
                case NORTH: {
                    return AABB_AXIS_Z1;
                }
                case SOUTH: {
                    return AABB_AXIS_Z2;
                }
            }
            return AABB_FULL;
        }
        return AABB_FULL;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        NBTTagCompound tag;
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof ITagGetter && (tag = stack.func_77978_p()) != null) {
            ((ITagGetter)tile).setNBT(tag);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        int i = this.func_180651_a(state);
        ItemStack drop = new ItemStack((Block)this, 1, i);
        if (tile != null && tile instanceof ITagGetter) {
            NBTTagCompound tag = new NBTTagCompound();
            if ((tag = ((ITagGetter)tile).getNBT(tag)) != null) {
                drop.func_77982_d(tag);
            }
        }
        if (!world.field_72995_K) {
            EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, drop);
            float f3 = 0.05f;
            entityitem.field_70159_w = (float)world.field_73012_v.nextGaussian() * f3;
            entityitem.field_70181_x = (float)world.field_73012_v.nextGaussian() * f3 + 0.25f;
            entityitem.field_70179_y = (float)world.field_73012_v.nextGaussian() * f3;
            world.func_72838_d((Entity)entityitem);
        }
        world.func_175666_e(pos, state.func_177230_c());
        super.func_180663_b(world, pos, state);
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)DCState.POWERED) != false ? 15 : 0;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        return this.calcRedstone(world.func_175625_s(pos));
    }

    protected int calcRedstone(TileEntity tile) {
        float amo;
        if (tile != null && tile instanceof TileMonitorBase && (amo = ((TileMonitorBase)tile).getGauge()) > 0.0f) {
            return MathHelper.func_76123_f((float)(amo * 15.0f));
        }
        return 0;
    }
}

