/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.machine.block;

import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.api.climate.ClimateAPI;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.core.ClimateCore;
import defeatedcrow.hac.core.base.DCTileBlock;
import defeatedcrow.hac.machine.block.TilePlayerPanel;
import defeatedcrow.hac.main.ClimateMain;
import defeatedcrow.hac.main.client.particle.ParticleBlink;
import defeatedcrow.hac.main.util.DCName;
import defeatedcrow.hac.main.util.MainUtil;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPlayerPanel
extends DCTileBlock {
    private static BlockPos lastPos = null;
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);

    public BlockPlayerPanel(String s) {
        super(Material.field_151571_B, s, 3);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TilePlayerPanel();
    }

    public boolean onRightClick(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        if (player != null && MainUtil.isHeldWrench((EntityLivingBase)player, hand) && (tile = world.func_175625_s(pos)) != null && tile instanceof TilePlayerPanel) {
            if (!world.field_72995_K) {
                if (lastPos == null) {
                    lastPos = pos;
                    String mes1 = "Stored this coordinate: " + pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p();
                    player.func_145747_a((ITextComponent)new TextComponentString(mes1));
                } else {
                    ((TilePlayerPanel)tile).setPairPos(new BlockPos(lastPos.func_177958_n(), lastPos.func_177956_o(), lastPos.func_177952_p()));
                    if (world.func_175625_s(lastPos) instanceof TilePlayerPanel && ((TilePlayerPanel)world.func_175625_s(lastPos)).getPairPos() == null) {
                        ((TilePlayerPanel)world.func_175625_s(lastPos)).setPairPos(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
                    }
                    String mes2 = "Registered the coordinate: " + lastPos.func_177958_n() + ", " + lastPos.func_177956_o() + ", " + lastPos.func_177952_p();
                    player.func_145747_a((ITextComponent)new TextComponentString(mes2));
                    lastPos = null;
                }
            }
            return true;
        }
        return super.onRightClick(world, pos, state, player, hand, side, hitX, hitY, hitZ);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public int func_149738_a(World worldIn) {
        return 20;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
        super.func_180633_a(world, pos, state, placer, stack);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K && state != null && state.func_177230_c() != null) {
            TileEntity tile;
            DCHeatTier heat = ClimateAPI.calculator.getAverageTemp(world, pos);
            int step = DCState.getInt((IBlockState)state, (PropertyInteger)DCState.TYPE4);
            boolean cool = heat.getTier() < 0;
            int count = 0;
            if (cool) {
                ++count;
            }
            if ((tile = world.func_175625_s(pos)) instanceof TilePlayerPanel && ((TilePlayerPanel)tile).isTargetActive()) {
                count += 2;
            }
            if (step != count) {
                BlockPlayerPanel.changeLitState(world, pos, count);
            }
            world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
        }
    }

    public static void changeLitState(World world, BlockPos pos, int i) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockPlayerPanel) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)DCState.TYPE4, (Comparable)Integer.valueOf(i)), 3);
            world.func_175685_c(pos, state.func_177230_c(), true);
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        TileEntity tile;
        int step = DCState.getInt((IBlockState)state, (PropertyInteger)DCState.TYPE4);
        if (step == 3 && (tile = world.func_175625_s(pos)) instanceof TilePlayerPanel) {
            TilePlayerPanel panel = (TilePlayerPanel)world.func_175625_s(pos);
            if (entity != null && entity instanceof EntityPlayer) {
                if (!world.field_72995_K) {
                    if (panel.cooltime > 0) {
                        --panel.cooltime;
                    } else {
                        BlockPos p = panel.getWarpPos();
                        BlockPos pair = panel.getPairPos();
                        if (p != null) {
                            entity.func_70634_a((double)p.func_177958_n() + 0.5, (double)p.func_177956_o() + 0.25, (double)p.func_177952_p() + 0.5);
                            entity.field_70143_R = 0.0f;
                        }
                        panel.cooltime = 40;
                    }
                } else {
                    int c = ClimateMain.proxy.getParticleCount();
                    if (ClimateMain.proxy.getParticleCount() > 0) {
                        for (int i = 0; i < 3; ++i) {
                            double x = (double)pos.func_177958_n() + this.rand.nextDouble();
                            double y = (double)pos.func_177956_o() + this.rand.nextDouble() * 0.5;
                            double z = (double)pos.func_177952_p() + this.rand.nextDouble();
                            Particle p = new ParticleBlink.Factory().func_178902_a(0, world, x, y, z, 0.0, 0.15, 0.0, new int[0]);
                            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a(p);
                        }
                    }
                }
            } else if (panel.cooltime != 40) {
                panel.cooltime = 40;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        if (ClimateCore.proxy.isShiftKeyDown()) {
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Requirement ===");
            tooltip.add(DCName.HEAT.getLocalizedName() + ": " + TextFormatting.BLUE.toString() + "COOL-");
            tooltip.add(I18n.func_135052_a((String)"dcs.tip.adapter", (Object[])new Object[0]));
        } else {
            tooltip.add(TextFormatting.ITALIC.toString() + "=== Lshift key: expand tooltip ===");
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        world.func_175713_t(pos);
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }
}

