/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.machine.block;

import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.api.blockstate.EnumSide;
import defeatedcrow.hac.core.base.DCTileEntity;
import defeatedcrow.hac.machine.block.BlockAdapterFluidPanel;
import defeatedcrow.hac.machine.block.TileAcceptorFluidPanel;
import javax.annotation.Nullable;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileAdapterFluidPanel
extends DCTileEntity {
    protected BlockPos pairPos = null;

    public BlockPos getPairPos() {
        return this.pairPos;
    }

    public void setPairPos(BlockPos pos) {
        this.pairPos = pos;
    }

    boolean isActive() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state != null && state.func_177230_c() instanceof BlockAdapterFluidPanel) {
            boolean flag = DCState.getBool((IBlockState)state, (PropertyBool)DCState.POWERED);
            return flag;
        }
        return false;
    }

    EnumSide getSide() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state != null && state.func_177230_c() instanceof BlockAdapterFluidPanel) {
            EnumSide side = DCState.getSide((IBlockState)state, (PropertyEnum)DCState.SIDE);
            return side;
        }
        return null;
    }

    TileEntity targetTile() {
        int zrad;
        int xrad;
        if (this.pairPos != null && this.field_145850_b.func_175667_e(this.pairPos) && (xrad = (this.field_174879_c.func_177958_n() >> 4) - (this.pairPos.func_177958_n() >> 4)) * xrad + (zrad = (this.field_174879_c.func_177952_p() >> 4) - (this.pairPos.func_177952_p() >> 4)) * zrad <= 25) {
            return this.field_145850_b.func_175625_s(this.pairPos);
        }
        return null;
    }

    protected int getMaxCool() {
        return 4;
    }

    public void updateTile() {
        super.updateTile();
        if (!this.field_145850_b.field_72995_K && this.isActive()) {
            this.extractItem();
        }
    }

    private boolean extractItem() {
        EnumSide side = this.getSide();
        if (side != null && this.targetTile() != null && this.targetTile() instanceof TileAcceptorFluidPanel) {
            EnumFacing face = this.getSide().face;
            TileAcceptorFluidPanel panel = (TileAcceptorFluidPanel)this.targetTile();
            TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(face));
            if (tile != null && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face.func_176734_d())) {
                IFluidHandler target = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face.func_176734_d());
                IFluidHandler send = (IFluidHandler)panel.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face.func_176734_d());
                if (send != null && target != null) {
                    int limit = 1000;
                    FluidStack get = target.drain(limit, false);
                    if (get == null || get.getFluid() == null || get.amount == 0) {
                        return false;
                    }
                    int ret = send.fill(get, false);
                    if (ret > 0) {
                        target.drain(ret, true);
                        send.fill(get, true);
                    }
                }
            }
        }
        return false;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.setNBT(tag);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.getNBT(tag);
        return tag;
    }

    public NBTTagCompound getNBT(NBTTagCompound tag) {
        super.getNBT(tag);
        if (this.pairPos != null) {
            tag.func_74768_a("pairX", this.pairPos.func_177958_n());
            tag.func_74768_a("pairY", this.pairPos.func_177956_o());
            tag.func_74768_a("pairZ", this.pairPos.func_177952_p());
            tag.func_74757_a("dcs.haspair", true);
        }
        return tag;
    }

    public void setNBT(NBTTagCompound tag) {
        super.setNBT(tag);
        if (tag.func_74764_b("dcs.haspair") && tag.func_74767_n("dcs.haspair")) {
            BlockPos pos;
            int px = tag.func_74762_e("pairX");
            int py = tag.func_74762_e("pairY");
            int pz = tag.func_74762_e("pairZ");
            this.pairPos = pos = new BlockPos(px, py, pz);
        }
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        this.func_189515_b(nbtTagCompound);
        return new SPacketUpdateTileEntity(this.field_174879_c, -50, nbtTagCompound);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.func_145836_u();
    }
}

