/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.machine.block;

import com.google.common.collect.Lists;
import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.api.climate.ClimateAPI;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.energy.ITorqueProvider;
import defeatedcrow.hac.api.energy.ITorqueReceiver;
import defeatedcrow.hac.core.energy.TileTorqueBase;
import defeatedcrow.hac.core.fluid.FluidDictionaryDC;
import defeatedcrow.hac.main.api.ISidedTankChecker;
import defeatedcrow.hac.main.block.fluid.DCLimitedTank;
import defeatedcrow.hac.main.packet.DCMainPacket;
import defeatedcrow.hac.main.packet.MessageSingleTank;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileBoilerTurbine
extends TileTorqueBase
implements ITorqueProvider,
IInventory,
ISidedTankChecker {
    public DCLimitedTank inputT = new DCLimitedTank(5000, "water", "steam");
    public int currentBurnTime = 0;
    public int maxBurnTime = -1;
    protected int currentClimate = DCHeatTier.NORMAL.getID();
    private int lastTier = 0;
    private int lastBurn = 0;
    private int last = 0;
    private int count = 0;

    public void updateTile() {
        super.updateTile();
        if (!this.field_145850_b.field_72995_K) {
            this.checkSideTank();
            DCHeatTier heat = ClimateAPI.calculator.getAverageTemp(this.field_145850_b, this.field_174879_c);
            this.currentClimate = heat.getID();
            IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            if (!DCState.getBool((IBlockState)state, (PropertyBool)DCState.POWERED)) {
                FluidStack flu;
                boolean f = false;
                int red = this.getRequiredWater(heat);
                if (red > 0 && (flu = this.inputT.getFluid()) != null && this.inputT.getFluidAmount() >= red) {
                    this.inputT.drain(red, true);
                    f = true;
                }
                if (f) {
                    this.currentBurnTime = 1;
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.15f, 0.7f);
                } else {
                    this.currentBurnTime = 0;
                }
                if (this.currentBurnTime > 0) {
                    this.currentTorque += this.getProvideTorque(heat);
                }
                for (EnumFacing side : this.getOutputSide()) {
                    this.provideTorque(this.field_145850_b, this.func_174877_v().func_177972_a(side), side, false);
                }
            }
        }
    }

    protected void onServerUpdate() {
        if (this.count <= 0) {
            if (this.inputT.getFluidAmount() != this.last) {
                this.last = this.inputT.getFluidAmount();
                DCMainPacket.INSTANCE.sendToAll((IMessage)new MessageSingleTank(this.field_174879_c, this.inputT.getFluidIdName(), this.inputT.getFluidAmount()));
            }
            this.count = 10;
        } else {
            --this.count;
        }
    }

    public boolean isActive() {
        return this.currentBurnTime > 0;
    }

    public int getCurrentBurnTime() {
        return this.currentBurnTime;
    }

    public int getMaxBurnTime() {
        return this.maxBurnTime;
    }

    public void setCurrentBurnTime(int i) {
        this.currentBurnTime = i;
    }

    public void setMaxBurnTime(int i) {
        this.maxBurnTime = i;
    }

    public float maxTorque() {
        return 128.0f;
    }

    public float getGearTier() {
        return 16.0f;
    }

    public boolean hasSteam() {
        return FluidDictionaryDC.matchFluidName((Fluid)this.inputT.getFluidType(), (String)"steam") && this.inputT.getFluidAmount() >= 10;
    }

    public int getRequiredWater(DCHeatTier tier) {
        if (this.hasSteam()) {
            return 10;
        }
        switch (tier) {
            case OVEN: {
                return 1;
            }
            case KILN: {
                return 10;
            }
            case SMELTING: {
                return 20;
            }
            case UHT: {
                return 50;
            }
        }
        return 0;
    }

    public int getBurnTime() {
        if (this.hasSteam()) {
            return 4;
        }
        FluidStack f = this.inputT.getFluid();
        if (f != null && f.getFluid() != null && this.inputT.getFluidAmount() > 0 && f.getFluid() == FluidRegistry.WATER) {
            DCHeatTier tier = DCHeatTier.getTypeByID((int)this.currentClimate);
            switch (tier) {
                case OVEN: {
                    return 20;
                }
                case KILN: {
                    return 4;
                }
                case SMELTING: {
                    return 2;
                }
                case UHT: {
                    return 1;
                }
            }
            return 0;
        }
        return 0;
    }

    public float getProvideTorque(DCHeatTier tier) {
        if (this.hasSteam()) {
            return 32.0f;
        }
        switch (tier) {
            case OVEN: {
                return 8.0f;
            }
            case KILN: {
                return 32.0f;
            }
            case SMELTING: {
                return 64.0f;
            }
            case UHT: {
                return 128.0f;
            }
        }
        return 0.0f;
    }

    @Override
    public void checkSideTank() {
        for (EnumFacing face : EnumFacing.field_176754_o) {
            int i;
            FluidStack ret;
            int fill;
            FluidStack target;
            IFluidHandler tank;
            int cap = this.inputT.getCapacity();
            int amo = this.inputT.getFluidAmount();
            int mov = 50;
            if (amo >= cap) break;
            TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(face));
            if (tile == null || tile instanceof ISidedTankChecker || !tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face.func_176734_d()) || (tank = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face.func_176734_d())) == null || tank.getTankProperties() == null || tank.getTankProperties().length <= 0 || (target = tank.getTankProperties()[0].getContents()) == null || !this.inputT.canFillTarget(target) || (fill = this.inputT.fill(ret = tank.drain(i = Math.min(mov, cap - amo), false), false)) <= 0) continue;
            ret = tank.drain(fill, true);
            this.inputT.fill(ret, true);
            tile.func_70296_d();
            this.func_70296_d();
            break;
        }
    }

    protected void onProcess() {
    }

    public boolean isInputSide(EnumFacing side) {
        return false;
    }

    public boolean isOutputSide(EnumFacing side) {
        return this.getOutputSide().contains(side);
    }

    public List<EnumFacing> getOutputSide() {
        ArrayList ret = Lists.newArrayList();
        ret.add(this.getBaseSide());
        return ret;
    }

    public float getAmount() {
        return this.getCurrentTorque();
    }

    public boolean canProvideTorque(World world, BlockPos outputPos, EnumFacing output) {
        TileEntity tile = world.func_175625_s(outputPos);
        float amo = this.getCurrentTorque();
        if (tile != null && tile instanceof ITorqueReceiver && amo > 0.0f) {
            return ((ITorqueReceiver)tile).canReceiveTorque(amo, output.func_176734_d());
        }
        return false;
    }

    public float provideTorque(World world, BlockPos outputPos, EnumFacing output, boolean sim) {
        float amo = this.getCurrentTorque();
        if (this.canProvideTorque(world, outputPos, output)) {
            ITorqueReceiver target = (ITorqueReceiver)world.func_175625_s(outputPos);
            float ret = target.receiveTorque(amo, output, sim);
            return ret;
        }
        return 0.0f;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return false;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)((Object)this.inputT);
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return null;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.func_145836_u();
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.currentBurnTime = tag.func_74762_e("BurnTime");
        this.maxBurnTime = tag.func_74762_e("MaxTime");
        this.currentClimate = tag.func_74771_c("Climate");
        this.inputT = (DCLimitedTank)this.inputT.readFromNBT(tag, "Tank");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("BurnTime", this.currentBurnTime);
        tag.func_74768_a("MaxTime", this.maxBurnTime);
        tag.func_74774_a("Climate", (byte)this.currentClimate);
        this.inputT.writeToNBT(tag, "Tank");
        return tag;
    }

    public NBTTagCompound getNBT(NBTTagCompound tag) {
        super.getNBT(tag);
        tag.func_74768_a("BurnTime", this.currentBurnTime);
        tag.func_74768_a("MaxTime", this.maxBurnTime);
        tag.func_74774_a("Climate", (byte)this.currentClimate);
        this.inputT.writeToNBT(tag, "Tank");
        return tag;
    }

    public void setNBT(NBTTagCompound tag) {
        super.setNBT(tag);
        this.currentBurnTime = tag.func_74762_e("BurnTime");
        this.maxBurnTime = tag.func_74762_e("MaxTime");
        this.currentClimate = tag.func_74771_c("Climate");
        this.inputT = (DCLimitedTank)this.inputT.readFromNBT(tag, "Tank");
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        this.func_189515_b(nbtTagCompound);
        return new SPacketUpdateTileEntity(this.field_174879_c, -50, nbtTagCompound);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public String func_70005_c_() {
        return "dcs.gui.device.boiler_turbine";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70302_i_() {
        return 0;
    }

    public ItemStack func_70301_a(int index) {
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int index) {
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int index, ItemStack stack) {
    }

    public int func_70297_j_() {
        return 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.func_145831_w().func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.currentBurnTime;
            }
            case 1: {
                return this.maxBurnTime;
            }
            case 2: {
                return this.currentClimate;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.currentBurnTime = value;
                break;
            }
            case 1: {
                this.maxBurnTime = value;
                break;
            }
            case 2: {
                this.currentClimate = value;
                break;
            }
            default: {
                return;
            }
        }
    }

    public int func_174890_g() {
        return 3;
    }

    public void func_174888_l() {
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public boolean func_191420_l() {
        return false;
    }
}

