/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.machine.block;

import com.google.common.collect.Lists;
import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.api.climate.ClimateAPI;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.energy.ITorqueProvider;
import defeatedcrow.hac.api.energy.ITorqueReceiver;
import defeatedcrow.hac.core.base.ITagGetter;
import defeatedcrow.hac.core.energy.TileTorqueBase;
import defeatedcrow.hac.core.fluid.DCTank;
import defeatedcrow.hac.main.api.ISidedTankChecker;
import defeatedcrow.hac.main.api.MainAPIManager;
import defeatedcrow.hac.main.packet.DCMainPacket;
import defeatedcrow.hac.main.packet.MessageSingleTank;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileDieselEngine
extends TileTorqueBase
implements ITorqueProvider,
ITorqueReceiver,
ITagGetter,
IInventory,
ISidedTankChecker {
    public DCTank inputT = new DCTank(5000);
    protected int currentBurnTime = 0;
    protected int maxBurnTime = 1;
    protected int currentClimate = DCHeatTier.NORMAL.getID();
    private int last = 0;
    private int count = 0;

    public float maxTorque() {
        return 512.0f;
    }

    public float getGearTier() {
        return 64.0f;
    }

    public boolean isActive() {
        return this.currentBurnTime > 0;
    }

    public int getCurrentBurnTime() {
        return this.currentBurnTime;
    }

    public int getMaxBurnTime() {
        return this.maxBurnTime;
    }

    public void setCurrentBurnTime(int i) {
        this.currentBurnTime = i;
    }

    public void setMaxBurnTime(int i) {
        this.maxBurnTime = i;
    }

    public void updateTile() {
        this.currentClimate = ClimateAPI.calculator.getAverageTemp(this.field_145850_b, this.func_174877_v()).getID();
        if (!this.func_145831_w().field_72995_K) {
            this.checkSideTank();
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (!DCState.getBool((IBlockState)state, (PropertyBool)DCState.POWERED) && this.isSuitableClimate()) {
                if (this.currentBurnTime == 0) {
                    int i;
                    FluidStack f = this.inputT.getFluid();
                    if (f != null && f.getFluid() != null && this.inputT.getFluidAmount() >= 10 && (i = TileDieselEngine.getBurnTime(f.getFluid())) > 0) {
                        this.currentBurnTime = i;
                        this.maxBurnTime = i;
                        this.inputT.drain(10, true);
                        this.func_70296_d();
                    }
                } else if (this.currentBurnTime > 0) {
                    --this.currentBurnTime;
                    this.currentTorque += 128.0f;
                    if (this.currentTorque > this.maxTorque()) {
                        this.currentTorque = this.maxTorque();
                    }
                } else {
                    this.currentBurnTime = 0;
                }
            }
            for (EnumFacing side : this.getOutputSide()) {
                this.provideTorque(this.field_145850_b, this.func_174877_v().func_177972_a(side), side, false);
            }
        }
        super.updateTile();
    }

    protected void onServerUpdate() {
        if (this.count <= 0) {
            if (this.inputT.getFluidAmount() != this.last) {
                this.last = this.inputT.getFluidAmount();
                DCMainPacket.INSTANCE.sendToAll((IMessage)new MessageSingleTank(this.field_174879_c, this.inputT.getFluidIdName(), this.inputT.getFluidAmount()));
            }
            this.count = 10;
        } else {
            --this.count;
        }
    }

    public static int getBurnTime(Fluid fluid) {
        int burn = MainAPIManager.fuelRegister.getBurningTime(fluid);
        return burn;
    }

    @Override
    public void checkSideTank() {
        for (EnumFacing face : EnumFacing.field_176754_o) {
            int i;
            FluidStack ret;
            int fill;
            FluidStack target;
            IFluidHandler tank;
            int cap = this.inputT.getCapacity();
            int amo = this.inputT.getFluidAmount();
            int mov = 50;
            if (amo >= cap) break;
            TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(face));
            if (tile == null || tile instanceof ISidedTankChecker || !tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face.func_176734_d()) || (tank = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face.func_176734_d())) == null || tank.getTankProperties() == null || tank.getTankProperties().length <= 0 || (target = tank.getTankProperties()[0].getContents()) == null || target.getFluid() == null || TileDieselEngine.getBurnTime(target.getFluid()) <= 0 || (fill = this.inputT.fill(ret = tank.drain(i = Math.min(mov, cap - amo), false), false)) <= 0) continue;
            ret = tank.drain(fill, true);
            this.inputT.fill(ret, true);
            tile.func_70296_d();
            this.func_70296_d();
            break;
        }
    }

    public List<EnumFacing> getOutputSide() {
        ArrayList ret = Lists.newArrayList();
        ret.add(this.getBaseSide());
        return ret;
    }

    public float getAmount() {
        return this.getCurrentTorque();
    }

    public boolean canProvideTorque(World world, BlockPos outputPos, EnumFacing output) {
        TileEntity tile = world.func_175625_s(outputPos);
        float amo = this.getAmount();
        if (tile != null && tile instanceof ITorqueReceiver && amo > 0.0f) {
            return ((ITorqueReceiver)tile).canReceiveTorque(amo, output.func_176734_d());
        }
        return false;
    }

    public float provideTorque(World world, BlockPos outputPos, EnumFacing output, boolean sim) {
        float amo = this.getCurrentTorque();
        if (this.canProvideTorque(world, outputPos, output)) {
            ITorqueReceiver target = (ITorqueReceiver)world.func_175625_s(outputPos);
            float ret = target.receiveTorque(amo, output, sim);
            return ret;
        }
        return 0.0f;
    }

    public boolean isInputSide(EnumFacing side) {
        return side == this.getBaseSide().func_176734_d();
    }

    public boolean isOutputSide(EnumFacing side) {
        return this.getOutputSide().contains(side);
    }

    public boolean canReceiveTorque(float amount, EnumFacing side) {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (DCState.getBool((IBlockState)state, (PropertyBool)DCState.POWERED)) {
            return false;
        }
        if (this.currentTorque >= this.maxTorque()) {
            return false;
        }
        return this.isInputSide(side);
    }

    public float receiveTorque(float amount, EnumFacing side, boolean sim) {
        float f = this.maxTorque() - this.currentTorque;
        float ret = Math.min(amount, f);
        if (!sim) {
            this.currentTorque += ret;
        }
        return ret;
    }

    public boolean isSuitableClimate() {
        return this.currentClimate > DCHeatTier.FROSTBITE.getID();
    }

    public List<String> climateSuitableMassage() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.isSuitableClimate()) {
            list.add(I18n.func_74838_a((String)"dcs.gui.message.suitableclimate"));
        } else {
            list.add(I18n.func_74838_a((String)"dcs.gui.message.pottery.toocold"));
        }
        return list;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return false;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.inputT;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return null;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.func_145836_u();
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.currentBurnTime = tag.func_74762_e("BurnTime");
        this.maxBurnTime = tag.func_74762_e("MaxTime");
        this.currentClimate = tag.func_74771_c("Climate");
        this.inputT = this.inputT.readFromNBT(tag, "Tank");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("BurnTime", this.currentBurnTime);
        tag.func_74768_a("MaxTime", this.maxBurnTime);
        tag.func_74774_a("Climate", (byte)this.currentClimate);
        this.inputT.writeToNBT(tag, "Tank");
        return tag;
    }

    public NBTTagCompound getNBT(NBTTagCompound tag) {
        super.getNBT(tag);
        tag.func_74768_a("BurnTime", this.currentBurnTime);
        tag.func_74768_a("MaxTime", this.maxBurnTime);
        tag.func_74774_a("Climate", (byte)this.currentClimate);
        this.inputT.writeToNBT(tag, "Tank");
        return tag;
    }

    public void setNBT(NBTTagCompound tag) {
        super.setNBT(tag);
        this.currentBurnTime = tag.func_74762_e("BurnTime");
        this.maxBurnTime = tag.func_74762_e("MaxTime");
        this.currentClimate = tag.func_74771_c("Climate");
        this.inputT = this.inputT.readFromNBT(tag, "Tank");
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        this.func_189515_b(nbtTagCompound);
        return new SPacketUpdateTileEntity(this.field_174879_c, -50, nbtTagCompound);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public String func_70005_c_() {
        return "dcs.gui.device.diesel_engine";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70302_i_() {
        return 0;
    }

    public ItemStack func_70301_a(int index) {
        return null;
    }

    public ItemStack func_70298_a(int index, int count) {
        return null;
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
    }

    public int func_70297_j_() {
        return 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.func_145831_w().func_175625_s(this.field_174879_c) != this || player == null) {
            return false;
        }
        return Math.sqrt(player.func_174818_b(this.field_174879_c)) < 256.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.currentBurnTime;
            }
            case 1: {
                return this.maxBurnTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.currentBurnTime = value;
                break;
            }
            case 1: {
                this.maxBurnTime = value;
                break;
            }
            default: {
                return;
            }
        }
    }

    public int func_174890_g() {
        return 2;
    }

    public void func_174888_l() {
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public boolean func_191420_l() {
        return false;
    }
}

