/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.machine.block;

import cofh.redstoneflux.api.IEnergyProvider;
import defeatedcrow.hac.api.energy.ITorqueReceiver;
import defeatedcrow.hac.core.energy.TileTorqueBase;
import defeatedcrow.hac.plugin.EnergyConvertRate;
import defeatedcrow.hac.plugin.cofh.RFDeviceHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.redstoneflux.api.IEnergyProvider", modid="redstoneflux")})
public class TileDynamo
extends TileTorqueBase
implements ITorqueReceiver,
IEnergyProvider {
    private List<EnumFacing> faces = new ArrayList<EnumFacing>();

    public boolean isInputSide(EnumFacing side) {
        return side == this.getBaseSide().func_176734_d();
    }

    public boolean isOutputSide(EnumFacing side) {
        return side != this.getBaseSide() || side != this.getBaseSide().func_176734_d();
    }

    public boolean canReceiveTorque(float amount, EnumFacing side) {
        if (this.currentTorque >= this.maxTorque()) {
            return false;
        }
        return this.isInputSide(side.func_176734_d());
    }

    public float receiveTorque(float amount, EnumFacing side, boolean sim) {
        float f = this.maxTorque() - this.currentTorque;
        float ret = Math.min(amount, f);
        if (!sim) {
            this.currentTorque += ret;
        }
        return ret;
    }

    public float maxTorque() {
        return 512.0f;
    }

    public float getGearTier() {
        return 16.0f;
    }

    public float maxSpeed() {
        return 360.0f;
    }

    public void updateTile() {
        super.updateTile();
        if (!this.field_145850_b.field_72995_K) {
            this.faces.clear();
            for (EnumFacing face : EnumFacing.field_82609_l) {
                TileEntity target;
                if (!this.isOutputSide(face) || (target = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(face))) == null) continue;
                if (target.hasCapability(CapabilityEnergy.ENERGY, face.func_176734_d())) {
                    this.faces.add(face);
                    continue;
                }
                if (!Loader.isModLoaded((String)"redstoneflux") || !RFDeviceHelper.isRFReceiver(target)) continue;
                this.faces.add(face);
            }
        }
    }

    protected void onServerUpdate() {
        float sendRF = this.prevTorque * EnergyConvertRate.rateVsRF * 0.05f;
        float sendFU = this.prevTorque * EnergyConvertRate.rateVsFU * 0.05f;
        if (!this.faces.isEmpty() && this.prevTorque > 0.0f) {
            for (EnumFacing face : this.faces) {
                TileEntity target = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(face));
                if (target == null) continue;
                if (target.hasCapability(CapabilityEnergy.ENERGY, face.func_176734_d())) {
                    IEnergyStorage sto = (IEnergyStorage)target.getCapability(CapabilityEnergy.ENERGY, face.func_176734_d());
                    float ret = sendFU / (float)this.faces.size();
                    int amo = MathHelper.func_76141_d((float)ret);
                    sto.receiveEnergy(amo, false);
                    continue;
                }
                if (!Loader.isModLoaded((String)"redstoneflux") || !RFDeviceHelper.isRFReceiver(target)) continue;
                float ret = sendRF / (float)this.faces.size();
                int amo = MathHelper.func_76141_d((float)ret);
                RFDeviceHelper.inputEnergy(face.func_176734_d(), target, amo, false);
            }
        }
    }

    @Optional.Method(modid="redstoneflux")
    public int getEnergyStored(EnumFacing face) {
        if (!this.faces.contains(face)) {
            this.faces.add(face);
        }
        float sendRF = this.prevTorque * EnergyConvertRate.rateVsRF * 0.05f;
        int amo = MathHelper.func_76141_d((float)(sendRF /= (float)this.faces.size()));
        return amo;
    }

    @Optional.Method(modid="redstoneflux")
    public int getMaxEnergyStored(EnumFacing face) {
        float sendRF = this.maxTorque() * EnergyConvertRate.rateVsRF;
        int amo = MathHelper.func_76141_d((float)sendRF);
        return amo;
    }

    @Optional.Method(modid="redstoneflux")
    public boolean canConnectEnergy(EnumFacing face) {
        return this.isOutputSide(face);
    }

    @Optional.Method(modid="redstoneflux")
    public int extractEnergy(EnumFacing face, int amo, boolean sim) {
        TileEntity target = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(face));
        if (target == null || RFDeviceHelper.isRFReceiver(target)) {
            return 0;
        }
        if (this.canConnectEnergy(face) && this.getEnergyStored(face) > 0) {
            int ret = this.getEnergyStored(face);
            ret = Math.min(amo, ret);
            return ret;
        }
        return 0;
    }
}

