/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.machine.block;

import defeatedcrow.hac.api.climate.ClimateAPI;
import defeatedcrow.hac.api.climate.DCAirflow;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.climate.DCHumidity;
import defeatedcrow.hac.api.climate.IClimateTileEntity;
import defeatedcrow.hac.api.energy.ITorqueReceiver;
import defeatedcrow.hac.core.DCLogger;
import defeatedcrow.hac.core.base.ClimateReceiveTile;
import defeatedcrow.hac.core.base.ClimateReceiverLockable;
import defeatedcrow.hac.core.energy.TileTorqueBase;
import defeatedcrow.hac.machine.MachineInit;
import defeatedcrow.hac.machine.block.BlockFan;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class TileFan
extends TileTorqueBase
implements ITorqueReceiver,
IClimateTileEntity {
    public boolean isInputSide(EnumFacing side) {
        return side != this.getBaseSide() && side != this.getBaseSide().func_176734_d();
    }

    public boolean isOutputSide(EnumFacing side) {
        return side == this.getBaseSide().func_176734_d();
    }

    public boolean canReceiveTorque(float amount, EnumFacing side) {
        if (this.currentTorque >= this.maxTorque()) {
            return false;
        }
        return this.isInputSide(side.func_176734_d());
    }

    public float receiveTorque(float amount, EnumFacing side, boolean sim) {
        float f = this.maxTorque() - this.currentTorque;
        float ret = Math.min(amount, f);
        if (!sim) {
            this.currentTorque += ret;
        }
        return ret;
    }

    public float getGearTier() {
        return 4.0f;
    }

    public float maxSpeed() {
        return 360.0f;
    }

    public void updateTile() {
        super.updateTile();
        if (!this.field_145850_b.field_72995_K) {
            BlockFan fan = (BlockFan)MachineInit.fan;
            EnumFacing face = this.getBaseSide();
            for (int i = 2; i < 5; ++i) {
                BlockPos target = this.func_174877_v().func_177967_a(face, i);
                TileEntity targetTE = this.field_145850_b.func_175625_s(target);
                if (targetTE != null && targetTE instanceof ClimateReceiveTile) {
                    if (((ClimateReceiveTile)targetTE).getHeatTilePos().contains(this.func_174877_v())) break;
                    ((ClimateReceiveTile)targetTE).addHeatTilePos(this.func_174877_v());
                    break;
                }
                if (targetTE != null && targetTE instanceof ClimateReceiverLockable) {
                    if (((ClimateReceiverLockable)targetTE).getHeatTilePos().contains(this.func_174877_v())) break;
                    DCLogger.debugLog((String)"find target");
                    ((ClimateReceiverLockable)targetTE).addHeatTilePos(this.func_174877_v());
                    break;
                }
                if (this.field_145850_b.func_180495_p(target).func_185914_p()) break;
            }
        }
    }

    public DCHeatTier getHeatTier(BlockPos target) {
        return ClimateAPI.calculator.getAverageTemp(this.field_145850_b, this.func_174877_v());
    }

    public DCHumidity getHumidity(BlockPos target) {
        return ClimateAPI.calculator.getHumidity(this.field_145850_b, this.func_174877_v());
    }

    public DCAirflow getAirflow(BlockPos target) {
        if (this.currentTorque > 5.5f) {
            return DCAirflow.WIND;
        }
        if (this.currentTorque > 1.0f) {
            return DCAirflow.FLOW;
        }
        return DCAirflow.TIGHT;
    }

    public boolean isActive() {
        return this.prevTorque > 0.0f;
    }
}

