/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.machine.block;

import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.energy.ITorqueReceiver;
import defeatedcrow.hac.core.energy.TileTorqueBase;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.util.EnumFacing;

public class TileFreezer
extends TileTorqueBase
implements ITorqueReceiver {
    protected DCHeatTier current = null;
    protected int lastHeat = 0;
    private int count = 20;

    public boolean isInputSide(EnumFacing side) {
        return this.getBaseSide().func_176740_k().func_176722_c() ? side == this.getBaseSide().func_176746_e() : side == this.getBaseSide();
    }

    public boolean isOutputSide(EnumFacing side) {
        return false;
    }

    public boolean canReceiveTorque(float amount, EnumFacing side) {
        if (this.currentTorque >= this.maxTorque()) {
            return false;
        }
        return this.isInputSide(side.func_176734_d());
    }

    public float receiveTorque(float amount, EnumFacing side, boolean sim) {
        float f = this.maxTorque() - this.currentTorque;
        float ret = Math.min(amount, f);
        if (!sim) {
            this.currentTorque += ret;
        }
        return ret;
    }

    public float maxTorque() {
        return 512.0f;
    }

    public float getGearTier() {
        return 64.0f;
    }

    public float maxSpeed() {
        return 0.0f;
    }

    public void updateTile() {
        super.updateTile();
        if (!this.field_145850_b.field_72995_K) {
            float f = this.prevTorque;
            this.current = DCHeatTier.NORMAL;
            if (f > 63.0f) {
                this.current = DCHeatTier.ABSOLUTE;
            } else if (f > 31.0f) {
                this.current = DCHeatTier.CRYOGENIC;
            } else if (f > 5.0f) {
                this.current = DCHeatTier.FROSTBITE;
            }
        }
    }

    protected void onServerUpdate() {
        if (this.count > 0) {
            --this.count;
        } else {
            boolean flag = false;
            if (this.current != null && this.current.getID() != this.lastHeat) {
                flag = true;
                this.lastHeat = this.current.getID();
            }
            if (flag) {
                if (!this.func_145830_o()) {
                    return;
                }
                List list = this.func_145831_w().field_73010_i;
                for (EntityPlayer player : list) {
                    if (!(player instanceof EntityPlayerMP)) continue;
                    ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)this.func_189518_D_());
                }
            }
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        int ic;
        DCHeatTier tier;
        super.func_145839_a(tag);
        if (tag.func_74764_b("dcs.heatID") && (tier = DCHeatTier.getTypeByID((int)(ic = tag.func_74762_e("dcs.heatID")))) != null) {
            this.current = tier;
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        if (this.current != null) {
            tag.func_74768_a("dcs.heatID", this.current.getID());
        }
        return tag;
    }

    public NBTTagCompound getNBT(NBTTagCompound tag) {
        super.getNBT(tag);
        if (this.current != null) {
            tag.func_74768_a("dcs.heatID", this.current.getID());
        }
        return tag;
    }

    public void setNBT(NBTTagCompound tag) {
        int ic;
        DCHeatTier tier;
        super.setNBT(tag);
        if (tag.func_74764_b("dcs.heatID") && (tier = DCHeatTier.getTypeByID((int)(ic = tag.func_74762_e("dcs.heatID")))) != null) {
            this.current = tier;
        }
    }
}

