/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.machine.block;

import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.machine.block.BlockGasBurner;
import defeatedcrow.hac.main.api.ISidedTankChecker;
import defeatedcrow.hac.main.api.MainAPIManager;
import defeatedcrow.hac.main.block.device.TileCookingStove;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileGasBurner
extends TileCookingStove
implements ISidedTankChecker {
    @Override
    public void updateTile() {
        super.updateTile();
        if (this.currentClimate != DCHeatTier.UHT.getID()) {
            this.currentClimate = DCHeatTier.UHT.getID();
        }
        if (!this.func_145831_w().field_72995_K && BlockGasBurner.isLit((IBlockAccess)this.func_145831_w(), this.func_174877_v()) != this.isActive()) {
            BlockGasBurner.changeLitState(this.func_145831_w(), this.func_174877_v(), this.isActive());
        }
    }

    @Override
    protected void onServerUpdate() {
        if (this.currentBurnTime > 0 && BlockGasBurner.isPower((IBlockAccess)this.func_145831_w(), this.func_174877_v())) {
            --this.currentBurnTime;
        }
    }

    @Override
    public void checkSideTank() {
        for (EnumFacing face : EnumFacing.field_176754_o) {
            int i;
            FluidStack ret;
            int fill;
            FluidStack target;
            IFluidHandler tank;
            int cap = this.inputT.getCapacity();
            int amo = this.inputT.getFluidAmount();
            int mov = 50;
            if (amo >= cap) break;
            TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(face));
            if (tile == null || tile instanceof ISidedTankChecker || !tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face.func_176734_d()) || (tank = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face.func_176734_d())) == null || tank.getTankProperties() == null || tank.getTankProperties().length <= 0 || (target = tank.getTankProperties()[0].getContents()) == null || target.getFluid() == null || TileGasBurner.getBurnTime(target.getFluid()) <= 0 || (fill = this.inputT.fill(ret = tank.drain(i = Math.min(mov, cap - amo), false), false)) <= 0) continue;
            ret = tank.drain(fill, true);
            this.inputT.fill(ret, true);
            tile.func_70296_d();
            this.func_70296_d();
            break;
        }
    }

    @Override
    public DCHeatTier getCurrentHeatTier() {
        return DCHeatTier.UHT;
    }

    public static int getBurnTime(Fluid fluid) {
        if (fluid != null && fluid.isGaseous()) {
            int burn = MainAPIManager.fuelRegister.getBurningTime(fluid);
            return burn;
        }
        return 0;
    }

    @Override
    public String func_70005_c_() {
        return "dcs.gui.device.gas_burner";
    }
}

