/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.machine.block;

import com.google.common.collect.Lists;
import defeatedcrow.hac.api.energy.ITorqueProvider;
import defeatedcrow.hac.api.energy.ITorqueReceiver;
import defeatedcrow.hac.core.energy.TileTorqueBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileHandCrank
extends TileTorqueBase
implements ITorqueProvider {
    public void updateTile() {
        super.updateTile();
        for (EnumFacing side : this.getOutputSide()) {
            this.provideTorque(this.field_145850_b, this.func_174877_v().func_177972_a(side), side, false);
        }
    }

    public float maxTorque() {
        return 1.0f;
    }

    public List<EnumFacing> getOutputSide() {
        ArrayList ret = Lists.newArrayList();
        ret.add(this.getBaseSide());
        return ret;
    }

    public float getAmount() {
        return this.getCurrentTorque();
    }

    public boolean canProvideTorque(World world, BlockPos outputPos, EnumFacing output) {
        TileEntity tile = world.func_175625_s(outputPos);
        float amo = this.getCurrentTorque();
        if (tile != null && tile instanceof ITorqueReceiver && amo > 0.0f) {
            return ((ITorqueReceiver)tile).canReceiveTorque(amo, output.func_176734_d());
        }
        return false;
    }

    public float provideTorque(World world, BlockPos outputPos, EnumFacing output, boolean sim) {
        float amo = this.getCurrentTorque();
        if (this.canProvideTorque(world, outputPos, output)) {
            ITorqueReceiver target = (ITorqueReceiver)world.func_175625_s(outputPos);
            float ret = target.receiveTorque(amo, output, sim);
            return ret;
        }
        return 0.0f;
    }

    public boolean isInputSide(EnumFacing side) {
        return side == this.getBaseSide().func_176734_d();
    }

    public boolean isOutputSide(EnumFacing side) {
        return side == this.getBaseSide();
    }
}

