/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.machine.block;

import defeatedcrow.hac.api.climate.ClimateAPI;
import defeatedcrow.hac.api.climate.DCAirflow;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.climate.DCHumidity;
import defeatedcrow.hac.api.climate.IClimate;
import defeatedcrow.hac.api.energy.ITorqueReceiver;
import defeatedcrow.hac.core.energy.TileTorqueBase;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.util.EnumFacing;

public class TileHeatExchanger
extends TileTorqueBase
implements ITorqueReceiver {
    protected IClimate current = null;
    protected int lastClimate = 0;
    private int count = 20;

    public boolean isInputSide(EnumFacing side) {
        return side != this.getBaseSide() && side != this.getBaseSide().func_176734_d();
    }

    public boolean isOutputSide(EnumFacing side) {
        return side == this.getBaseSide().func_176734_d();
    }

    public boolean canReceiveTorque(float amount, EnumFacing side) {
        if (this.currentTorque >= this.maxTorque()) {
            return false;
        }
        return this.isInputSide(side.func_176734_d());
    }

    public float receiveTorque(float amount, EnumFacing side, boolean sim) {
        float f = this.maxTorque() - this.currentTorque;
        float ret = Math.min(amount, f);
        if (!sim) {
            this.currentTorque += ret;
        }
        return ret;
    }

    public float getGearTier() {
        return 16.0f;
    }

    public float maxSpeed() {
        return 0.0f;
    }

    public float maxTorque() {
        return 128.0f;
    }

    public void updateTile() {
        super.updateTile();
        if (!this.field_145850_b.field_72995_K) {
            DCHeatTier heat = this.getUnderHeat();
            DCHumidity hum = ClimateAPI.calculator.getHumidity(this.field_145850_b, this.field_174879_c, 1, false);
            DCAirflow air = ClimateAPI.calculator.getAirflow(this.field_145850_b, this.field_174879_c, 1, false);
            int code = (air.getID() << 6) + (hum.getID() << 4) + heat.getID();
            this.current = ClimateAPI.register.getClimateFromInt(code);
        }
    }

    protected void onServerUpdate() {
        if (this.count > 0) {
            --this.count;
        } else {
            boolean flag = false;
            if (this.current != null && this.current.getClimateInt() != this.lastClimate) {
                flag = true;
                this.lastClimate = this.current.getClimateInt();
            }
            if (flag) {
                if (!this.func_145830_o()) {
                    return;
                }
                List list = this.func_145831_w().field_73010_i;
                for (EntityPlayer player : list) {
                    if (!(player instanceof EntityPlayerMP)) continue;
                    ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)this.func_189518_D_());
                }
            }
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        int ic;
        IClimate clm;
        super.func_145839_a(tag);
        if (tag.func_74764_b("dcs.climateInt") && (clm = ClimateAPI.register.getClimateFromInt(ic = tag.func_74762_e("dcs.climateInt"))) != null) {
            this.current = clm;
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        if (this.current != null) {
            tag.func_74768_a("dcs.climateInt", this.current.getClimateInt());
        }
        return tag;
    }

    private DCHeatTier getUnderHeat() {
        DCHeatTier hot = ClimateAPI.calculator.getAverageTemp(this.field_145850_b, this.func_174877_v().func_177977_b(), 0, false);
        DCHeatTier current = ClimateAPI.calculator.getBlockHeatTier(this.field_145850_b, this.func_174877_v(), this.field_174879_c.func_177977_b());
        if (current != null && current.getTier() != hot.getTier()) {
            hot = current;
        }
        return hot;
    }
}

