/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.machine.block;

import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.api.blockstate.EnumSide;
import defeatedcrow.hac.core.base.DCInventory;
import defeatedcrow.hac.core.base.DCLockableTE;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.machine.block.BlockHopperFilter;
import defeatedcrow.hac.machine.gui.ContainerHopperFilter;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.IHopper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileHopperFilter
extends DCLockableTE
implements IHopper,
ISidedInventory {
    protected DCInventory inv = new DCInventory(5);
    private int cooldown = -1;
    private int lastCount = 0;
    IItemHandler handler = new HopperInvWrapper(this, this.getCurrentFacing());
    IItemHandler handler2 = new HopperInvWrapper(this, this.getCurrentFacing()){

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return stack;
        }
    };

    public int getCoolTime() {
        return 4;
    }

    public boolean isFilterd() {
        return true;
    }

    public void onServerUpdate() {
        if (this.cooldown <= 0) {
            this.cooldown = this.getCoolTime();
            if (this.isActive()) {
                this.extractItem();
                if (!this.suctionItem()) {
                    this.suctionDrop();
                }
            }
        } else {
            --this.cooldown;
        }
    }

    @Nullable
    protected EnumFacing getCurrentFacing() {
        IBlockState state;
        if (this.field_145850_b != null && this.field_174879_c != null && (state = this.field_145850_b.func_180495_p(this.field_174879_c)) != null && state.func_177230_c() instanceof BlockHopperFilter) {
            EnumSide side = DCState.getSide((IBlockState)state, (PropertyEnum)DCState.SIDE);
            return side != null ? side.getFacing() : EnumFacing.DOWN;
        }
        return EnumFacing.DOWN;
    }

    @Nullable
    protected EnumFacing getInsertSide() {
        IBlockState state;
        if (this.field_145850_b != null && this.field_174879_c != null && (state = this.field_145850_b.func_180495_p(this.field_174879_c)) != null && state.func_177230_c() instanceof BlockHopperFilter) {
            EnumSide side = DCState.getSide((IBlockState)state, (PropertyEnum)DCState.SIDE);
            return side == EnumSide.UP ? EnumFacing.DOWN : EnumFacing.UP;
        }
        return EnumFacing.UP;
    }

    private boolean isActive() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state != null && state.func_177230_c() instanceof BlockHopperFilter) {
            boolean flag = DCState.getBool((IBlockState)state, (PropertyBool)DCState.POWERED);
            return flag;
        }
        return true;
    }

    protected boolean extractItem() {
        IItemHandler target;
        TileEntity tile;
        EnumFacing face = this.getCurrentFacing();
        if (face != null && (tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(face))) != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face.func_176734_d()) && (target = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face.func_176734_d())) != null) {
            boolean b = false;
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                int min;
                ItemStack item = this.inv.func_70301_a(i);
                int n = min = this.isFilterd() ? 1 : 0;
                if (DCUtil.isEmpty((ItemStack)item)) continue;
                if (item.func_77973_b().getItemStackLimit(item) == 1) {
                    min = 0;
                }
                if (DCUtil.getSize((ItemStack)item) <= min) continue;
                ItemStack ins = item.func_77946_l();
                ins.func_190920_e(1);
                for (int j = 0; j < target.getSlots(); ++j) {
                    ItemStack ret = target.insertItem(j, ins, true);
                    if (!DCUtil.isEmpty((ItemStack)ret)) continue;
                    target.insertItem(j, ins, false);
                    this.func_70298_a(i, 1);
                    this.func_70296_d();
                    tile.func_70296_d();
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean suctionItem() {
        IItemHandler target;
        EnumFacing face = this.getCurrentFacing() == EnumFacing.UP ? EnumFacing.DOWN : EnumFacing.UP;
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(face));
        if (tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN) && (target = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN)) != null) {
            boolean b = false;
            for (int i = 0; i < target.getSlots(); ++i) {
                ItemStack item = target.extractItem(i, 1, true);
                if (DCUtil.isEmpty((ItemStack)item)) continue;
                for (int j = 0; j < this.func_70302_i_(); ++j) {
                    ItemStack cur = this.func_70301_a(j);
                    if (TileHopperFilter.isItemStackable(item, cur) <= 0) continue;
                    this.incrStackInSlot(j, item);
                    target.extractItem(i, 1, false);
                    this.func_70296_d();
                    tile.func_70296_d();
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean suctionDrop() {
        List list;
        double x1 = (double)this.func_174877_v().func_177958_n() - 0.0;
        double x2 = (double)this.func_174877_v().func_177958_n() + 1.0;
        double y1 = (double)this.func_174877_v().func_177956_o() + 0.5;
        double y2 = (double)this.func_174877_v().func_177956_o() + 2.0;
        double z1 = (double)this.func_174877_v().func_177952_p() - 0.0;
        double z2 = (double)this.func_174877_v().func_177952_p() + 1.0;
        if (this.getCurrentFacing() == EnumFacing.UP) {
            y1 = (double)this.func_174877_v().func_177956_o() - 2.0;
            y2 = (double)this.func_174877_v().func_177956_o() + 0.5;
        }
        if ((list = this.field_145850_b.func_72872_a(EntityItem.class, new AxisAlignedBB(x1, y1, z1, x2, y2, z2))) == null || list.isEmpty()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            EntityItem drop;
            EntityItem entity = (EntityItem)list.get(i);
            if (entity == null || DCUtil.isEmpty((ItemStack)(drop = entity).func_92059_d())) continue;
            ItemStack ins = drop.func_92059_d().func_77946_l();
            for (int j = 0; j < this.func_70302_i_(); ++j) {
                ItemStack cur = this.func_70301_a(j);
                int count = TileHopperFilter.isItemStackable(ins, cur);
                if (count <= 0) continue;
                ins.func_190920_e(count);
                this.incrStackInSlot(j, ins);
                drop.func_92059_d().func_77979_a(count);
                this.func_70296_d();
                if (DCUtil.isEmpty((ItemStack)drop.func_92059_d())) {
                    drop.func_70106_y();
                }
                return true;
            }
        }
        return false;
    }

    public static int isItemStackable(ItemStack target, ItemStack current) {
        if (DCUtil.isSameItem((ItemStack)target, (ItemStack)current, (boolean)true)) {
            int i = current.func_190916_E() + target.func_190916_E();
            if (i > current.func_77976_d()) {
                i = current.func_77976_d() - current.func_190916_E();
                return i;
            }
            return target.func_190916_E();
        }
        return 0;
    }

    public void incrStackInSlot(int i, ItemStack input) {
        this.inv.incrStackInSlot(i, input);
    }

    public int func_70302_i_() {
        return 5;
    }

    public ItemStack func_70301_a(int i) {
        return this.inv.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int num) {
        return this.inv.func_70298_a(i, num);
    }

    public ItemStack func_70304_b(int i) {
        return this.inv.func_70304_b(i);
    }

    public void func_70299_a(int i, ItemStack stack) {
        this.inv.func_70299_a(i, stack);
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.func_145831_w().func_175625_s(this.field_174879_c) != this || player == null) {
            return false;
        }
        return Math.sqrt(player.func_174818_b(this.field_174879_c)) < 256.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.inv.func_174888_l();
    }

    public String func_70005_c_() {
        return "dcs.gui.device.hopper.filter";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerHopperFilter(this, playerIn);
    }

    public String func_174875_k() {
        return "dcs.gui.device.hopper.filter";
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.func_145836_u();
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public double func_96107_aA() {
        return (double)this.field_174879_c.func_177958_n() + 0.5;
    }

    public double func_96109_aB() {
        return (double)this.field_174879_c.func_177956_o() + 0.5;
    }

    public double func_96108_aC() {
        return (double)this.field_174879_c.func_177952_p() + 0.5;
    }

    public World func_145831_w() {
        return this.field_145850_b;
    }

    protected int[] slotsSides() {
        return new int[]{0, 1, 2, 3, 4};
    }

    public int[] func_180463_a(EnumFacing side) {
        return this.slotsSides();
    }

    public boolean func_180462_a(int index, ItemStack itemStack, EnumFacing dir) {
        return this.func_94041_b(index, itemStack);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing dir) {
        if (!DCUtil.isEmpty((ItemStack)stack)) {
            return !this.isFilterd() || stack.func_190916_E() > 1 || stack.func_77973_b().getItemStackLimit(stack) == 1;
        }
        return false;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == this.getCurrentFacing() || facing == this.getInsertSide()) {
                return (T)this.handler2;
            }
            return (T)this.handler;
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inv.readFromNBT(tag);
        this.cooldown = tag.func_74762_e("Cooldown");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("Cooldown", this.cooldown);
        this.inv.writeToNBT(tag);
        return tag;
    }

    public NBTTagCompound getNBT(NBTTagCompound tag) {
        super.getNBT(tag);
        tag.func_74768_a("Cooldown", this.cooldown);
        this.inv.writeToNBT(tag);
        return tag;
    }

    public void setNBT(NBTTagCompound tag) {
        super.setNBT(tag);
        this.inv.readFromNBT(tag);
        this.cooldown = tag.func_74762_e("Cooldown");
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        this.func_189515_b(nbtTagCompound);
        return new SPacketUpdateTileEntity(this.field_174879_c, -50, nbtTagCompound);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_70296_d() {
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public boolean func_191420_l() {
        return this.inv.func_191420_l();
    }

    private class HopperInvWrapper
    extends SidedInvWrapper {
        private HopperInvWrapper(TileHopperFilter tile, EnumFacing side) {
            super((ISidedInventory)tile, side);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (amount <= 0) {
                return ItemStack.field_190927_a;
            }
            int slot1 = HopperInvWrapper.getSlot((ISidedInventory)this.inv, (int)slot, (EnumFacing)this.side);
            if (slot1 == -1) {
                return ItemStack.field_190927_a;
            }
            ItemStack stackInSlot = this.inv.func_70301_a(slot1);
            if (stackInSlot.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            if (!this.inv.func_180461_b(slot1, stackInSlot, this.side)) {
                return ItemStack.field_190927_a;
            }
            ItemStack copy2 = stackInSlot.func_77946_l();
            int count = copy2.func_190916_E();
            if (count > amount) {
                count = amount;
            } else if (stackInSlot.func_77973_b().getItemStackLimit(copy2) == 1) {
                count = 1;
            } else if (TileHopperFilter.this.isFilterd()) {
                --count;
            }
            if (count <= 0) {
                return ItemStack.field_190927_a;
            }
            if (simulate) {
                if (stackInSlot.func_190916_E() < count) {
                    return stackInSlot.func_77946_l();
                }
                ItemStack copy = stackInSlot.func_77946_l();
                copy.func_190920_e(count);
                return copy;
            }
            int m = Math.min(stackInSlot.func_190916_E(), count);
            ItemStack ret = this.inv.func_70298_a(slot1, m);
            this.inv.func_70296_d();
            return ret;
        }
    }
}

