/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.machine.block;

import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.core.base.DCInventory;
import defeatedcrow.hac.core.base.DCLockableTE;
import defeatedcrow.hac.core.fluid.DCTank;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.machine.block.BlockHopperFluid;
import defeatedcrow.hac.machine.gui.ContainerHopperFluid;
import defeatedcrow.hac.main.MainInit;
import defeatedcrow.hac.main.packet.DCMainPacket;
import defeatedcrow.hac.main.packet.MessageSingleTank;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.IHopper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.wrappers.BlockLiquidWrapper;
import net.minecraftforge.fluids.capability.wrappers.FluidBlockWrapper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileHopperFluid
extends DCLockableTE
implements IHopper,
ISidedInventory {
    private DCInventory inv = new DCInventory(2);
    public DCTank inputT = new DCTank(5000);
    private int cooldown = 5;
    private int lastCount = 0;
    private int lastInT = 0;
    private int count = 20;
    public static int flowrate = 200;
    IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    IItemHandler handlerSide = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);

    public void onServerUpdate() {
        if (this.cooldown <= 0) {
            this.cooldown = 5;
            if (this.isActive()) {
                if (!this.extractFluid() && !this.extractEntityFluid()) {
                    this.extractItem();
                }
                this.processTank();
                if (!(this.suctionFluidBlock() || this.suctionFluid() || this.suctionEntityFluid() || this.suctionItem())) {
                    this.suctionDrop();
                }
            }
            boolean flag = false;
            if (this.inputT.getFluidAmount() != this.lastInT) {
                flag = true;
                this.lastInT = this.inputT.getFluidAmount();
            }
            if (flag) {
                String name = this.inputT.isEmpty() ? "empty" : this.inputT.getFluidType().getName();
                DCMainPacket.INSTANCE.sendToAll((IMessage)new MessageSingleTank(this.field_174879_c, name, this.inputT.getFluidAmount()));
            }
        } else {
            --this.cooldown;
        }
    }

    private boolean isActive() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state != null && state.func_177230_c() instanceof BlockHopperFluid) {
            boolean flag = DCState.getBool((IBlockState)state, (PropertyBool)DCState.POWERED);
            return flag;
        }
        return true;
    }

    private boolean extractItem() {
        IItemHandler target;
        TileEntity tile;
        EnumFacing face = EnumFacing.DOWN;
        if (face != null && (tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(face))) != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face.func_176734_d()) && (target = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face.func_176734_d())) != null) {
            boolean b = false;
            ItemStack item = this.inv.func_70301_a(1);
            if (!DCUtil.isEmpty((ItemStack)item)) {
                ItemStack ins = item.func_77946_l();
                ins.func_190920_e(1);
                for (int j = 0; j < target.getSlots(); ++j) {
                    ItemStack ret = target.insertItem(j, ins, false);
                    if (!DCUtil.isEmpty((ItemStack)ret)) continue;
                    this.func_70298_a(1, 1);
                    this.func_70296_d();
                    tile.func_70296_d();
                    return true;
                }
            }
        }
        return false;
    }

    private boolean extractFluid() {
        IFluidHandler tank;
        int cap = this.inputT.getCapacity();
        int amo = this.inputT.getFluidAmount();
        int mov = flowrate;
        if (this.inputT.isEmpty() || amo <= 0) {
            return false;
        }
        TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177977_b());
        if (tile != null && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP) && (tank = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP)) != null && tank.getTankProperties() != null && tank.getTankProperties().length > 0) {
            int i = Math.min(mov, amo);
            FluidStack ret = new FluidStack(this.inputT.getFluidType(), i);
            int fill = tank.fill(ret, false);
            if (fill > 0) {
                ret = this.inputT.drain(fill, true);
                tank.fill(ret, true);
                tile.func_70296_d();
                this.func_70296_d();
                return true;
            }
        }
        return false;
    }

    private boolean extractEntityFluid() {
        int cap = this.inputT.getCapacity();
        int amo = this.inputT.getFluidAmount();
        int mov = flowrate;
        if (this.inputT.isEmpty() || amo <= 0) {
            return false;
        }
        AxisAlignedBB bb = new AxisAlignedBB(this.field_174879_c.func_177982_a(-1, 0, -1), this.field_174879_c.func_177982_a(2, 2, 2));
        List entities = this.field_145850_b.func_72872_a(Entity.class, bb);
        if (!entities.isEmpty()) {
            for (Entity e : entities) {
                IFluidHandler tank;
                if (e == null || !e.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP) || (tank = (IFluidHandler)e.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP)) == null || tank.getTankProperties() == null || tank.getTankProperties().length <= 0) continue;
                int i = Math.min(mov, amo);
                FluidStack ret = new FluidStack(this.inputT.getFluidType(), i);
                int fill = tank.fill(ret, false);
                if (fill <= 0) continue;
                ret = this.inputT.drain(fill, true);
                tank.fill(ret, true);
                this.func_70296_d();
                return true;
            }
        }
        return false;
    }

    private boolean suctionItem() {
        IItemHandler target;
        EnumFacing face = EnumFacing.UP;
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(face));
        if (tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face.func_176734_d()) && (target = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face.func_176734_d())) != null) {
            boolean b = false;
            for (int i = 0; i < target.getSlots(); ++i) {
                ItemStack item = target.extractItem(i, 1, true);
                if (DCUtil.isEmpty((ItemStack)item) || !this.func_94041_b(0, item)) continue;
                ItemStack cur = this.func_70301_a(0);
                if (TileHopperFluid.isItemStackable(item, cur) <= 0) continue;
                this.incrStackInSlot(0, item);
                target.extractItem(i, 1, false);
                this.func_70296_d();
                tile.func_70296_d();
                return true;
            }
        }
        return false;
    }

    private boolean suctionFluid() {
        int i;
        FluidStack ret;
        int fill;
        FluidStack target;
        IFluidHandler tank;
        int cap = this.inputT.getCapacity();
        int amo = this.inputT.getFluidAmount();
        int mov = flowrate;
        if (amo >= cap) {
            return false;
        }
        TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177984_a());
        if (tile != null && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.DOWN) && (tank = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.DOWN)) != null && tank.getTankProperties() != null && tank.getTankProperties().length > 0 && (target = tank.getTankProperties()[0].getContents()) != null && target.getFluid() != null && (fill = this.inputT.fill(ret = tank.drain(i = Math.min(mov, cap - amo), false), false)) > 0) {
            ret = tank.drain(fill, true);
            this.inputT.fill(ret, true);
            tile.func_70296_d();
            this.func_70296_d();
            return true;
        }
        return false;
    }

    private boolean suctionEntityFluid() {
        int cap = this.inputT.getCapacity();
        int amo = this.inputT.getFluidAmount();
        int mov = flowrate;
        if (amo >= cap) {
            return false;
        }
        AxisAlignedBB bb = new AxisAlignedBB(this.field_174879_c.func_177982_a(-1, 0, -1), this.field_174879_c.func_177982_a(2, 2, 2));
        List entities = this.field_145850_b.func_72872_a(Entity.class, bb);
        if (!entities.isEmpty()) {
            for (Entity e : entities) {
                FluidStack target;
                int fill;
                if (e != null && e.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP)) {
                    int i;
                    FluidStack ret;
                    int fill2;
                    FluidStack target2;
                    IFluidHandler tank = (IFluidHandler)e.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP);
                    if (tank == null || tank.getTankProperties() == null || tank.getTankProperties().length <= 0 || (target2 = tank.getTankProperties()[0].getContents()) == null || target2.getFluid() == null || (fill2 = this.inputT.fill(ret = tank.drain(i = Math.min(mov, cap - amo), false), false)) <= 0) continue;
                    ret = tank.drain(fill2, true);
                    this.inputT.fill(ret, true);
                    this.func_70296_d();
                    return true;
                }
                if (!(e instanceof EntityCow) || (fill = this.inputT.fill(target = new FluidStack(MainInit.milk, 50), false)) <= 0) continue;
                this.inputT.fill(target, true);
                this.func_70296_d();
            }
        }
        return false;
    }

    private boolean suctionFluidBlock() {
        int i;
        FluidStack ret;
        int fill;
        FluidStack target;
        FluidBlockWrapper tank;
        int cap = this.inputT.getCapacity();
        int amo = this.inputT.getFluidAmount();
        int mov = 1000;
        if (amo + flowrate > cap) {
            return false;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a());
        if (state != null && state.func_177230_c() != null && state.func_177230_c() instanceof BlockLiquid) {
            int i2;
            FluidStack ret2;
            int fill2;
            FluidStack target2;
            BlockLiquidWrapper tank2 = new BlockLiquidWrapper((BlockLiquid)state.func_177230_c(), this.field_145850_b, this.field_174879_c.func_177984_a());
            if (tank2 != null && tank2.getTankProperties() != null && tank2.getTankProperties().length > 0 && (target2 = tank2.getTankProperties()[0].getContents()) != null && target2.getFluid() != null && (fill2 = this.inputT.fill(ret2 = tank2.drain(i2 = Math.min(mov, cap - amo), false), false)) == 1000) {
                ret2 = tank2.drain(fill2, true);
                this.inputT.fill(ret2, true);
                this.func_70296_d();
                return true;
            }
        } else if (state != null && state.func_177230_c() != null && state.func_177230_c() instanceof IFluidBlock && (tank = new FluidBlockWrapper((IFluidBlock)state.func_177230_c(), this.field_145850_b, this.field_174879_c.func_177984_a())) != null && tank.getTankProperties() != null && (target = tank.getTankProperties()[0].getContents()) != null && target.getFluid() != null && (fill = this.inputT.fill(ret = tank.drain(i = Math.min(mov, cap - amo), false), false)) > 0) {
            ret = tank.drain(fill, true);
            this.inputT.fill(ret, true);
            this.func_70296_d();
            return true;
        }
        return false;
    }

    protected void processTank() {
        if (this.onDrainTank(this.inputT, 0, 1)) {
            this.func_70296_d();
        } else if (this.onFillTank(this.inputT, 0, 1)) {
            this.func_70296_d();
        }
    }

    protected boolean onFillTank(DCTank tank, int slot1, int slot2) {
        block9: {
            ItemStack ret;
            boolean loose;
            block10: {
                FluidStack fill;
                block11: {
                    ItemStack in = this.func_70301_a(slot1);
                    ItemStack out = this.func_70301_a(slot2);
                    if (DCUtil.isEmpty((ItemStack)in)) {
                        return false;
                    }
                    IFluidHandlerItem dummy = null;
                    ItemStack in2 = in.func_77946_l();
                    if (in2.func_190916_E() > 1) {
                        in2.func_190920_e(1);
                    }
                    if (in.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
                        dummy = (IFluidHandlerItem)in2.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                    } else if (in.func_77973_b() instanceof IFluidHandlerItem) {
                        dummy = (IFluidHandlerItem)in2.func_77973_b();
                    }
                    if (dummy == null || dummy.getTankProperties() == null || dummy.getTankProperties().length <= 0) break block9;
                    loose = false;
                    ret = ItemStack.field_190927_a;
                    int max = dummy.getTankProperties()[0].getCapacity();
                    FluidStack fc = dummy.drain(max, false);
                    if (fc == null || fc.amount <= 0 || !tank.canFillTarget(fc)) break block10;
                    ret = ItemStack.field_190927_a;
                    loose = false;
                    boolean b = false;
                    int rem = tank.getCapacity() - tank.getFluidAmount();
                    fc = dummy.drain(rem, false);
                    if (fc == null || fc.amount > rem) break block10;
                    fill = null;
                    fill = dummy.drain(rem, true);
                    ret = dummy.getContainer();
                    if (fill == null) break block10;
                    if (DCUtil.isEmpty((ItemStack)ret)) break block11;
                    if (TileHopperFluid.isItemStackable(ret, this.inv.func_70301_a(slot2)) <= 0) break block10;
                }
                loose = true;
                tank.fill(fill, true);
            }
            if (loose) {
                this.func_70298_a(slot1, 1);
                this.incrStackInSlot(slot2, ret);
                return true;
            }
        }
        return false;
    }

    protected boolean onDrainTank(DCTank tank, int slot1, int slot2) {
        block12: {
            ItemStack ret;
            boolean loose;
            block13: {
                int fill;
                block14: {
                    ItemStack in = this.func_70301_a(slot1);
                    ItemStack out = this.func_70301_a(slot2);
                    if (DCUtil.isEmpty((ItemStack)in)) {
                        return false;
                    }
                    IFluidHandlerItem dummy = null;
                    ItemStack in2 = in.func_77946_l();
                    if (in2.func_190916_E() > 1) {
                        in2.func_190920_e(1);
                    }
                    if (in.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
                        dummy = (IFluidHandlerItem)in2.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                    } else if (in.func_77973_b() instanceof IFluidHandlerItem) {
                        dummy = (IFluidHandlerItem)in2.func_77973_b();
                    }
                    if (tank.getFluidAmount() <= 0 || dummy == null || dummy.getTankProperties() == null || dummy.getTankProperties().length <= 0) break block12;
                    loose = false;
                    ret = ItemStack.field_190927_a;
                    int max = dummy.getTankProperties()[0].getCapacity();
                    FluidStack fc = dummy.drain(max, false);
                    boolean b = false;
                    int rem = max;
                    if (fc == null || fc.amount == 0) {
                        b = true;
                    } else {
                        rem = max - fc.amount;
                        if (tank.getFluidAmount() <= rem) {
                            b = true;
                        }
                    }
                    if (!b) break block13;
                    FluidStack drain = tank.drain(rem, false);
                    fill = 0;
                    fill = dummy.fill(drain, true);
                    ret = dummy.getContainer();
                    if (fill <= 0) break block13;
                    if (DCUtil.isEmpty((ItemStack)ret)) break block14;
                    if (TileHopperFluid.isItemStackable(ret, this.inv.func_70301_a(slot2)) <= 0) break block13;
                }
                loose = true;
                tank.drain(fill, true);
            }
            if (loose) {
                this.func_70298_a(slot1, 1);
                this.incrStackInSlot(slot2, ret);
                return true;
            }
        }
        return false;
    }

    private boolean suctionDrop() {
        double z2;
        double x1 = (double)this.func_174877_v().func_177958_n() - 0.0;
        double x2 = (double)this.func_174877_v().func_177958_n() + 1.0;
        double y1 = (double)this.func_174877_v().func_177956_o() + 0.5;
        double y2 = (double)this.func_174877_v().func_177956_o() + 2.0;
        double z1 = (double)this.func_174877_v().func_177952_p() - 0.0;
        List list = this.field_145850_b.func_72839_b(null, new AxisAlignedBB(x1, y1, z1, x2, y2, z2 = (double)this.func_174877_v().func_177952_p() + 1.0));
        if (list == null || list.isEmpty()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            EntityItem drop;
            Entity entity = (Entity)list.get(i);
            if (entity == null || !(entity instanceof EntityItem) || DCUtil.isEmpty((ItemStack)(drop = (EntityItem)entity).func_92059_d())) continue;
            ItemStack ins = drop.func_92059_d().func_77946_l();
            ItemStack cur = this.func_70301_a(0);
            int count = TileHopperFluid.isItemStackable(ins, cur);
            if (count <= 0) continue;
            ins.func_190920_e(count);
            this.incrStackInSlot(0, ins);
            drop.func_92059_d().func_77979_a(count);
            this.func_70296_d();
            if (DCUtil.isEmpty((ItemStack)drop.func_92059_d())) {
                drop.func_70106_y();
            }
            return true;
        }
        return false;
    }

    public static int isItemStackable(ItemStack target, ItemStack current) {
        if (DCUtil.isSameItem((ItemStack)target, (ItemStack)current, (boolean)true)) {
            int i = current.func_190916_E() + target.func_190916_E();
            if (i > current.func_77976_d()) {
                i = current.func_77976_d() - current.func_190916_E();
                return i;
            }
            return target.func_190916_E();
        }
        return 0;
    }

    public void incrStackInSlot(int i, ItemStack input) {
        this.inv.incrStackInSlot(i, input);
    }

    public int func_70302_i_() {
        return 2;
    }

    public ItemStack func_70301_a(int i) {
        return this.inv.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int num) {
        return this.inv.func_70298_a(i, num);
    }

    public ItemStack func_70304_b(int i) {
        return this.inv.func_70304_b(i);
    }

    public void func_70299_a(int i, ItemStack stack) {
        this.inv.func_70299_a(i, stack);
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.func_145831_w().func_175625_s(this.field_174879_c) != this || player == null) {
            return false;
        }
        return Math.sqrt(player.func_174818_b(this.field_174879_c)) < 256.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (!DCUtil.isEmpty((ItemStack)stack)) {
            return stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        }
        return false;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.inv.func_174888_l();
    }

    public String func_70005_c_() {
        return "dcs.gui.device.hopper.fluid";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerHopperFluid(this, playerIn);
    }

    public String func_174875_k() {
        return "dcs.gui.device.hopper.fluid";
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.func_145836_u();
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public double func_96107_aA() {
        return (double)this.field_174879_c.func_177958_n() + 0.5;
    }

    public double func_96109_aB() {
        return (double)this.field_174879_c.func_177956_o() + 0.5;
    }

    public double func_96108_aC() {
        return (double)this.field_174879_c.func_177952_p() + 0.5;
    }

    public World func_145831_w() {
        return this.field_145850_b;
    }

    protected int[] slotsTop() {
        return new int[]{0};
    }

    protected int[] slotsBottom() {
        return new int[]{1};
    }

    protected int[] slotsSides() {
        return new int[]{0, 1};
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? this.slotsBottom() : (side == EnumFacing.UP ? this.slotsTop() : this.slotsSides());
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return index == 0 && this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index > 0;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.inputT;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
            return (T)this.handlerSide;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inv.readFromNBT(tag);
        this.cooldown = tag.func_74762_e("Cooldown");
        this.inputT = this.inputT.readFromNBT(tag, "Tank");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("Cooldown", this.cooldown);
        this.inv.writeToNBT(tag);
        this.inputT.writeToNBT(tag, "Tank");
        return tag;
    }

    public NBTTagCompound getNBT(NBTTagCompound tag) {
        super.getNBT(tag);
        tag.func_74768_a("Cooldown", this.cooldown);
        this.inv.writeToNBT(tag);
        this.inputT.writeToNBT(tag, "Tank");
        return tag;
    }

    public void setNBT(NBTTagCompound tag) {
        super.setNBT(tag);
        this.inv.readFromNBT(tag);
        this.cooldown = tag.func_74762_e("Cooldown");
        this.inputT = this.inputT.readFromNBT(tag, "Tank");
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        this.func_189515_b(nbtTagCompound);
        return new SPacketUpdateTileEntity(this.field_174879_c, -50, nbtTagCompound);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_70296_d() {
        this.inv.func_70296_d();
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public boolean func_191420_l() {
        return this.inv.func_191420_l();
    }
}

