/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.machine.block;

import cofh.redstoneflux.api.IEnergyReceiver;
import com.google.common.collect.Lists;
import defeatedcrow.hac.api.energy.ITorqueProvider;
import defeatedcrow.hac.api.energy.ITorqueReceiver;
import defeatedcrow.hac.core.energy.TileTorqueBase;
import defeatedcrow.hac.plugin.EnergyConvertRate;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.redstoneflux.api.IEnergyReceiver", modid="redstoneflux")})
public class TileKineticMotor
extends TileTorqueBase
implements ITorqueProvider,
IEnergyReceiver {
    public int cashedRF = 0;

    public int getMaxCashRF() {
        return (int)(128.0f * EnergyConvertRate.rateVsRF);
    }

    public void updateTile() {
        super.updateTile();
        if (!this.field_145850_b.field_72995_K) {
            this.currentTorque += (float)this.cashedRF / EnergyConvertRate.rateVsRF;
            if (this.currentTorque > this.maxTorque()) {
                this.currentTorque = this.maxTorque();
            }
            float send = 0.0f;
            for (EnumFacing side : this.getOutputSide()) {
                send += this.provideTorque(this.field_145850_b, this.func_174877_v().func_177972_a(side), side, false);
            }
            float lim1 = send * EnergyConvertRate.rateVsRF;
            this.cashedRF = (int)((float)this.cashedRF - lim1);
            if (this.cashedRF < 0) {
                this.cashedRF = 0;
            }
        }
    }

    public float maxTorque() {
        return 128.0f;
    }

    public float getGearTier() {
        return 4.0f;
    }

    public List<EnumFacing> getOutputSide() {
        ArrayList ret = Lists.newArrayList();
        ret.add(this.getBaseSide());
        return ret;
    }

    public float getAmount() {
        return this.getCurrentTorque();
    }

    public boolean canProvideTorque(World world, BlockPos outputPos, EnumFacing output) {
        TileEntity tile = world.func_175625_s(outputPos);
        float amo = this.getCurrentTorque();
        if (tile != null && tile instanceof ITorqueReceiver && amo > 0.0f) {
            return ((ITorqueReceiver)tile).canReceiveTorque(amo, output.func_176734_d());
        }
        return false;
    }

    public float provideTorque(World world, BlockPos outputPos, EnumFacing output, boolean sim) {
        float amo = this.getCurrentTorque();
        if (this.canProvideTorque(world, outputPos, output)) {
            ITorqueReceiver target = (ITorqueReceiver)world.func_175625_s(outputPos);
            float ret = target.receiveTorque(amo, output, sim);
            return ret;
        }
        return 0.0f;
    }

    public boolean isInputSide(EnumFacing side) {
        return side == this.getBaseSide().func_176734_d();
    }

    public boolean isOutputSide(EnumFacing side) {
        return side == this.getBaseSide();
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.cashedRF = tag.func_74762_e("dcs.Ecash");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("dcs.Ecash", this.cashedRF);
        return tag;
    }

    public NBTTagCompound getNBT(NBTTagCompound tag) {
        super.getNBT(tag);
        tag.func_74768_a("dcs.Ecash", this.cashedRF);
        return tag;
    }

    public void setNBT(NBTTagCompound tag) {
        super.setNBT(tag);
        this.cashedRF = tag.func_74762_e("dcs.Ecash");
    }

    @Optional.Method(modid="redstoneflux")
    public int getEnergyStored(EnumFacing face) {
        int ret = this.cashedRF;
        return ret;
    }

    @Optional.Method(modid="redstoneflux")
    public int getMaxEnergyStored(EnumFacing face) {
        int ret = this.getMaxCashRF();
        return ret;
    }

    @Optional.Method(modid="redstoneflux")
    public boolean canConnectEnergy(EnumFacing face) {
        return face != this.getBaseSide();
    }

    @Optional.Method(modid="redstoneflux")
    public int receiveEnergy(EnumFacing face, int amo, boolean sim) {
        if (this.canConnectEnergy(face)) {
            int get = this.getMaxCashRF() - this.cashedRF;
            if (get <= 0) {
                get = 0;
            }
            get = Math.min(amo, get);
            if (!sim) {
                this.cashedRF += get;
                this.func_70296_d();
            }
            return get;
        }
        return 0;
    }
}

