/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.machine.block;

import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.api.blockstate.EnumSide;
import defeatedcrow.hac.core.base.DCTileEntity;
import defeatedcrow.hac.core.base.ITagGetter;
import defeatedcrow.hac.main.packet.DCMainPacket;
import defeatedcrow.hac.main.packet.MessageMonitor;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileMonitorBase
extends DCTileEntity
implements ITagGetter {
    protected BlockPos pairPos = null;
    protected int dim = 0;
    protected int side = 0;
    public float amount = 0.0f;
    public float amountMax = 0.0f;
    public float last = 0.0f;
    boolean next = false;

    public String unit() {
        return "";
    }

    public boolean noUnit() {
        return false;
    }

    public String amountString(float amo, int order) {
        return amo == 0.0f ? "---.-" : String.format("%1$.1f", Float.valueOf(amo));
    }

    public BlockPos getPairPos() {
        return this.pairPos;
    }

    public void setPairPos(BlockPos pos) {
        this.pairPos = pos;
    }

    public int getDim() {
        return this.dim;
    }

    public void setDim(int i) {
        this.dim = i;
    }

    public EnumSide getSide() {
        return EnumSide.fromIndex((int)this.side);
    }

    public void setSide(EnumSide side) {
        this.dim = side.index;
    }

    public float getCurrentAmount() {
        return this.amount;
    }

    public float getMaxAmount() {
        return this.amountMax;
    }

    public float getGauge() {
        return this.amountMax < 1.0f ? 0.0f : this.amount / this.amountMax;
    }

    boolean isActive() {
        int currentDim = this.field_145850_b.field_73011_w.getDimension();
        return this.getPairPos() != null && currentDim == this.getDim();
    }

    TileEntity targetTile() {
        if (this.pairPos != null && this.field_145850_b.func_175667_e(this.pairPos)) {
            return this.field_145850_b.func_175625_s(this.pairPos);
        }
        return null;
    }

    protected int getMaxCool() {
        return 10;
    }

    public void updateTile() {
        super.updateTile();
        if (!this.field_145850_b.field_72995_K && this.isActive()) {
            this.last = this.amount;
            if (!this.updateAmount()) {
                this.amount = 0.0f;
                this.amountMax = 0.0f;
            }
            DCMainPacket.INSTANCE.sendToAll((IMessage)new MessageMonitor(this.field_174879_c, this.amount, this.amountMax, this.last));
            if (this.next) {
                this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
            } else if (this.last != this.amount) {
                this.next = true;
            }
            boolean on = this.amount > 0.0f;
            IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            boolean b = DCState.getBool((IBlockState)state, (PropertyBool)DCState.POWERED);
            if (on != b) {
                IBlockState newState = state.func_177226_a((IProperty)DCState.POWERED, (Comparable)Boolean.valueOf(on));
                this.field_145850_b.func_180501_a(this.func_174877_v(), newState, 3);
            }
        }
    }

    protected boolean updateAmount() {
        return false;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.setNBT(tag);
        this.amount = tag.func_74760_g("gauge");
        this.amountMax = tag.func_74760_g("maxgauge");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.getNBT(tag);
        tag.func_74776_a("gauge", this.amount);
        tag.func_74776_a("maxgauge", this.amountMax);
        return tag;
    }

    public NBTTagCompound getNBT(NBTTagCompound tag) {
        super.getNBT(tag);
        if (this.pairPos != null) {
            tag.func_74768_a("card.dim", this.dim);
            tag.func_74768_a("card.X", this.pairPos.func_177958_n());
            tag.func_74768_a("card.Y", this.pairPos.func_177956_o());
            tag.func_74768_a("card.Z", this.pairPos.func_177952_p());
            tag.func_74768_a("card.facing", this.side);
        }
        return tag;
    }

    public void setNBT(NBTTagCompound tag) {
        super.setNBT(tag);
        if (tag.func_74764_b("card.dim")) {
            BlockPos pos;
            this.dim = tag.func_74762_e("card.dim");
            int px = tag.func_74762_e("card.X");
            int py = tag.func_74762_e("card.Y");
            int pz = tag.func_74762_e("card.Z");
            this.side = tag.func_74762_e("card.facing");
            this.pairPos = pos = new BlockPos(px, py, pz);
        }
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        this.func_189515_b(nbtTagCompound);
        return new SPacketUpdateTileEntity(this.field_174879_c, -50, nbtTagCompound);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.func_145836_u();
    }
}

