/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.machine.block;

import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.energy.ITorqueReceiver;
import defeatedcrow.hac.core.base.DCInventory;
import defeatedcrow.hac.core.energy.TileTorqueLockable;
import defeatedcrow.hac.core.fluid.DCTank;
import defeatedcrow.hac.core.fluid.FluidDictionaryDC;
import defeatedcrow.hac.core.packet.HaCPacket;
import defeatedcrow.hac.core.packet.MessageClimateUpdate;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.machine.gui.ContainerPortalManager;
import defeatedcrow.hac.machine.item.ItemAdapterCard;
import defeatedcrow.hac.main.MainInit;
import defeatedcrow.hac.main.api.ISidedTankChecker;
import defeatedcrow.hac.main.packet.DCMainPacket;
import defeatedcrow.hac.main.packet.MessageSingleTank;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TilePortalManager
extends TileTorqueLockable
implements ITorqueReceiver,
ISidedInventory,
ISidedTankChecker {
    public DCTank inputT = new DCTank(5000);
    public boolean active = true;
    public int[] activeSlot = new int[]{0, 0, 0, 0, 0, 0};
    private int loadCount = 5;
    private int lastInT = 0;
    private int lastHeat = 0;
    public float requireTorque = 30.0f;
    private boolean flag = false;
    private int tickCount = 5;
    public DCInventory inv = new DCInventory(12);
    IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    IItemHandler handlerSide = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);
    IFluidHandler handlerFluid = new NitrogenTank();

    public void updateTile() {
        super.updateTile();
        this.checkSideTank();
        if (this.loadCount > 0) {
            --this.loadCount;
        } else {
            this.active = this.isActiveMachine();
            this.reduceCoolant();
        }
        for (int i = 0; i < 6; ++i) {
            this.activeSlot[i] = this.isActiveSlot(i);
        }
    }

    protected void onServerUpdate() {
        super.onServerUpdate();
        if (this.tickCount <= 0) {
            this.tickCount = 5;
            if (!this.field_145850_b.field_72995_K) {
                if (this.active) {
                    for (int i = 0; i < 6; ++i) {
                        if (this.activeSlot[i] <= 0) continue;
                        this.onTransferSlot(i);
                    }
                }
                boolean flag = false;
                if (this.inputT.getFluidAmount() != this.lastInT) {
                    flag = true;
                    this.lastInT = this.inputT.getFluidAmount();
                }
                if (flag) {
                    String name = this.inputT.isEmpty() ? "empty" : this.inputT.getFluidType().getName();
                    DCMainPacket.INSTANCE.sendToAll((IMessage)new MessageSingleTank(this.field_174879_c, name, this.inputT.getFluidAmount()));
                }
                boolean flag2 = false;
                if (this.current != null && this.current.getHeat().getID() != this.lastHeat) {
                    flag2 = true;
                    this.lastHeat = this.current.getHeat().getID();
                }
                if (flag2) {
                    HaCPacket.INSTANCE.sendToAll((IMessage)new MessageClimateUpdate(this.field_174879_c, this.lastHeat));
                }
            }
        } else {
            --this.tickCount;
        }
    }

    @Override
    public void checkSideTank() {
        for (EnumFacing face : EnumFacing.field_176754_o) {
            int i;
            FluidStack ret;
            int fill;
            FluidStack target;
            IFluidHandler tank;
            int cap = this.inputT.getCapacity();
            int amo = this.inputT.getFluidAmount();
            int mov = 50;
            if (amo >= cap) break;
            TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(face));
            if (tile == null || tile instanceof ISidedTankChecker || !tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face.func_176734_d()) || (tank = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face.func_176734_d())) == null || tank.getTankProperties() == null || tank.getTankProperties().length <= 0 || (target = tank.getTankProperties()[0].getContents()) == null || target.getFluid() == null || !FluidDictionaryDC.matchFluid((Fluid)target.getFluid(), (Fluid)MainInit.nitrogen) || (fill = this.inputT.fill(ret = tank.drain(i = Math.min(mov, cap - amo), false), false)) <= 0) continue;
            ret = tank.drain(fill, true);
            this.inputT.fill(ret, true);
            tile.func_70296_d();
            this.func_70296_d();
            break;
        }
    }

    public boolean isActiveMachine() {
        if (this.prevTorque > this.requireTorque) {
            return this.isSuitableClimate();
        }
        return false;
    }

    public boolean hasCoolant() {
        if (this.inputT.getFluidType() != null && this.inputT.getFluidType().getTemperature() < 130) {
            return this.inputT.drain(10, false) != null;
        }
        return false;
    }

    public void reduceCoolant() {
        if (this.hasCoolant()) {
            this.inputT.drain(10, true);
        }
    }

    public int isActiveSlot(int num) {
        ItemStack in = this.func_70301_a(num);
        ItemStack out = this.func_70301_a(num + 6);
        int dim = this.field_145850_b.field_73011_w.getDimension();
        if (!DCUtil.isEmpty((ItemStack)in) && !DCUtil.isEmpty((ItemStack)out) && in.func_77973_b() instanceof ItemAdapterCard && out.func_77973_b() instanceof ItemAdapterCard) {
            boolean a = false;
            boolean b = false;
            ItemAdapterCard card1 = (ItemAdapterCard)in.func_77973_b();
            ItemAdapterCard card2 = (ItemAdapterCard)out.func_77973_b();
            if (card1.getCardType(in.func_77952_i()) == card2.getCardType(out.func_77952_i())) {
                if (card1.getAccessType(in.func_77952_i()) == ItemAdapterCard.AccessType.INPUT && card1.getPos(in) != null && card1.getDim(in) == dim) {
                    a = true;
                }
                if (card2.getAccessType(out.func_77952_i()) == ItemAdapterCard.AccessType.OUTPUT && card2.getPos(out) != null && card2.getDim(out) == dim) {
                    b = true;
                }
                if (a && b) {
                    if (card1.getCardType(in.func_77952_i()) == ItemAdapterCard.CardType.FLUID) {
                        return 2;
                    }
                    return 1;
                }
            }
        }
        return 0;
    }

    public boolean onTransferSlot(int num) {
        ItemStack in = this.func_70301_a(num);
        ItemStack out = this.func_70301_a(num + 6);
        if (!DCUtil.isEmpty((ItemStack)in) && !DCUtil.isEmpty((ItemStack)out) && in.func_77973_b() instanceof ItemAdapterCard && out.func_77973_b() instanceof ItemAdapterCard) {
            TileEntity t2;
            TileEntity t1;
            ItemAdapterCard card1 = (ItemAdapterCard)in.func_77973_b();
            ItemAdapterCard card2 = (ItemAdapterCard)out.func_77973_b();
            TileEntity inT = null;
            TileEntity outT = null;
            BlockPos p1 = card1.getPos(in);
            EnumFacing f1 = card1.getFacing(in);
            if (p1 != null && f1 != null && (t1 = this.field_145850_b.func_175625_s(p1)) != null) {
                inT = t1;
            }
            BlockPos p2 = card2.getPos(out);
            EnumFacing f2 = card2.getFacing(out);
            if (p2 != null && f2 != null && (t2 = this.field_145850_b.func_175625_s(p2)) != null) {
                outT = t2;
            }
            if (inT != null && outT != null) {
                if (card1.getCardType(in.func_77952_i()) == ItemAdapterCard.CardType.ITEM && inT.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, f1) && outT.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, f2)) {
                    IItemHandler input = (IItemHandler)inT.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, f1);
                    IItemHandler output = (IItemHandler)outT.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, f2);
                    if (input != null && output != null) {
                        boolean b = false;
                        for (int i = 0; i < input.getSlots(); ++i) {
                            ItemStack item = input.extractItem(i, 1, true);
                            if (DCUtil.isEmpty((ItemStack)item)) continue;
                            ItemStack ins = item.func_77946_l();
                            ins.func_190920_e(1);
                            for (int j = 0; j < output.getSlots(); ++j) {
                                ItemStack ret = output.insertItem(j, ins, false);
                                if (!DCUtil.isEmpty((ItemStack)ret)) continue;
                                input.extractItem(i, 1, false);
                                inT.func_70296_d();
                                outT.func_70296_d();
                                return true;
                            }
                        }
                    }
                } else if (card1.getCardType(in.func_77952_i()) == ItemAdapterCard.CardType.FLUID && inT.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, f1) && outT.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, f2)) {
                    IFluidHandler intank = (IFluidHandler)inT.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, f1);
                    IFluidHandler outtank = (IFluidHandler)outT.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, f2);
                    if (intank != null && outtank != null) {
                        int limit = 1000;
                        FluidStack get = intank.drain(limit, false);
                        if (get == null || get.getFluid() == null || get.amount == 0) {
                            return false;
                        }
                        int ret = outtank.fill(get, false);
                        if (ret > 0) {
                            intank.drain(ret, true);
                            outtank.fill(get, true);
                        }
                    }
                }
            }
        }
        return false;
    }

    public boolean isInputSide(EnumFacing side) {
        return side == this.getBaseSide();
    }

    public boolean isOutputSide(EnumFacing side) {
        return false;
    }

    public boolean canReceiveTorque(float amount, EnumFacing side) {
        if (this.currentTorque >= this.maxTorque()) {
            return false;
        }
        return this.isInputSide(side.func_176734_d());
    }

    public float receiveTorque(float amount, EnumFacing side, boolean sim) {
        float f = this.maxTorque() - this.currentTorque;
        float ret = Math.min(amount, f);
        if (!sim) {
            this.currentTorque += ret;
        }
        return ret;
    }

    public float maxTorque() {
        return 512.0f;
    }

    public float getGearTier() {
        return 64.0f;
    }

    public float maxSpeed() {
        return 90.0f;
    }

    public boolean isSuitableClimate() {
        if (this.current == null) {
            return true;
        }
        if (this.current != null && this.current.getHeat().getTier() <= DCHeatTier.CRYOGENIC.getTier()) {
            return true;
        }
        return this.hasCoolant();
    }

    public String climateSuitableMassage() {
        if (this.isSuitableClimate()) {
            return "dcs.gui.message.suitableclimate";
        }
        return "dcs.gui.message.require.absolute";
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inv.readFromNBT(tag);
        this.inputT = this.inputT.readFromNBT(tag, "Tank");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.inv.writeToNBT(tag);
        this.inputT.writeToNBT(tag, "Tank");
        return tag;
    }

    public NBTTagCompound getNBT(NBTTagCompound tag) {
        super.getNBT(tag);
        this.inv.writeToNBT(tag);
        this.inputT.writeToNBT(tag, "Tank");
        return tag;
    }

    public void setNBT(NBTTagCompound tag) {
        super.setNBT(tag);
        this.inv.readFromNBT(tag);
        this.inputT = this.inputT.readFromNBT(tag, "Tank");
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        this.func_189515_b(nbtTagCompound);
        return new SPacketUpdateTileEntity(this.field_174879_c, -50, nbtTagCompound);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    protected int[] slotsTop() {
        return new int[]{0, 1, 2, 3, 4, 5};
    }

    protected int[] slotsBottom() {
        return new int[]{6, 7, 8, 9, 10, 11};
    }

    protected int[] slotsSides() {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
    }

    private boolean canIncrStack(ItemStack incr, int slot) {
        ItemStack check = this.func_70301_a(slot);
        return DCUtil.isEmpty((ItemStack)check) || DCUtil.isStackable((ItemStack)incr, (ItemStack)check);
    }

    public int incrStackSize(int i, ItemStack get) {
        if (i < 0 || i >= this.func_70302_i_() || DCUtil.isEmpty((ItemStack)get)) {
            return 0;
        }
        if (DCUtil.isSameItem((ItemStack)get, (ItemStack)this.inv.func_70301_a(i), (boolean)true)) {
            int i1 = this.inv.func_70301_a(i).func_190916_E() + get.func_190916_E();
            if (i1 > this.inv.func_70301_a(i).func_77976_d()) {
                i1 = this.inv.func_70301_a(i).func_77976_d() - this.inv.func_70301_a(i).func_190916_E();
                return i1;
            }
            return get.func_190916_E();
        }
        return 0;
    }

    public int func_70302_i_() {
        return 12;
    }

    public ItemStack func_70301_a(int i) {
        return this.inv.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int num) {
        return this.inv.func_70298_a(i, num);
    }

    public ItemStack func_70304_b(int i) {
        return this.inv.func_70304_b(i);
    }

    public void func_70299_a(int i, ItemStack stack) {
        this.inv.func_70299_a(i, stack);
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.func_145831_w().func_175625_s(this.field_174879_c) != this || player == null) {
            return false;
        }
        return Math.sqrt(player.func_174818_b(this.field_174879_c)) < 256.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        if (i >= 0 && i < 6) {
            return stack != null && stack.func_77973_b() != null;
        }
        return false;
    }

    public int func_174887_a_(int id) {
        if (id >= 0 && id < 6) {
            return this.activeSlot[id];
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        if (id >= 0 && id < 6) {
            this.activeSlot[id] = value;
        }
    }

    public int func_174890_g() {
        return 6;
    }

    public void func_174888_l() {
        this.inv.func_174888_l();
    }

    public String func_70005_c_() {
        return "dcs.gui.device.portalmanager";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? this.slotsBottom() : (side == EnumFacing.UP ? this.slotsTop() : this.slotsSides());
    }

    public boolean func_180462_a(int index, ItemStack itemStack, EnumFacing direction) {
        return false;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.func_145836_u();
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerPortalManager(this, playerIn);
    }

    public String func_174875_k() {
        return "dcs.gui.device.portal_manager";
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return false;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.handlerFluid;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return null;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean func_191420_l() {
        return this.inv.func_191420_l();
    }

    public class NitrogenTank
    implements IFluidHandler,
    ICapabilityProvider {
        @Nullable
        public FluidStack getFluid() {
            return TilePortalManager.this.inputT.getFluid();
        }

        public IFluidTankProperties[] getTankProperties() {
            return TilePortalManager.this.inputT.getTankProperties();
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (this.canFillFluidType(resource)) {
                return TilePortalManager.this.inputT.fill(resource, doFill);
            }
            return 0;
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return TilePortalManager.this.inputT.drain(resource.amount, doDrain);
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            return TilePortalManager.this.inputT.drain(maxDrain, doDrain);
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid == null || fluid.getFluid().getTemperature() >= 130;
        }

        public boolean canDrainFluidType(FluidStack fluid) {
            return true;
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? this : null);
        }
    }
}

