/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.machine.block;

import defeatedcrow.hac.api.blockstate.EnumSide;
import defeatedcrow.hac.api.climate.ClimateAPI;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.energy.ITorqueReceiver;
import defeatedcrow.hac.api.recipe.IReactorRecipe;
import defeatedcrow.hac.api.recipe.RecipeAPI;
import defeatedcrow.hac.core.energy.TileTorqueProcessor;
import defeatedcrow.hac.core.fluid.DCTank;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.machine.gui.ContainerReactor;
import defeatedcrow.hac.main.block.fluid.SidedFluidTankWrapper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.oredict.OreDictionary;

public class TileReactor
extends TileTorqueProcessor
implements ITorqueReceiver {
    private IReactorRecipe currentRecipe;
    public DCTank inputT1 = new DCTank(4000);
    public DCTank inputT2 = new DCTank(4000);
    public DCTank outputT1 = new DCTank(4000);
    public DCTank outputT2 = new DCTank(4000);
    public EnumSide tankSide1 = EnumSide.UP;
    public EnumSide tankSide2 = EnumSide.NORTH;
    public EnumSide tankSide3 = EnumSide.DOWN;
    public EnumSide tankSide4 = EnumSide.SOUTH;
    private int lastInT1 = 0;
    private int lastInT2 = 0;
    private int lastOutT1 = 0;
    private int lastOutT2 = 0;
    private int lastBurn = 0;
    private int count = 0;
    private int last = 0;
    SidedFluidTankWrapper handlerTank1 = new SidedFluidTankWrapper(this.inputT1, false, true);
    SidedFluidTankWrapper handlerTank2 = new SidedFluidTankWrapper(this.inputT2, false, true);
    SidedFluidTankWrapper handlerTank3 = new SidedFluidTankWrapper(this.outputT1, true, false);
    SidedFluidTankWrapper handlerTank4 = new SidedFluidTankWrapper(this.outputT2, true, false);

    public int getMaxTickCount() {
        return 1;
    }

    public boolean isInputSide(EnumFacing side) {
        if (this.getBaseSide().func_176740_k().func_176720_b()) {
            return side == EnumFacing.WEST;
        }
        return side == this.getBaseSide().func_176746_e().func_176734_d();
    }

    public boolean isOutputSide(EnumFacing side) {
        return false;
    }

    public boolean canReceiveTorque(float amount, EnumFacing side) {
        if (this.currentTorque >= this.maxTorque()) {
            return false;
        }
        return this.isInputSide(side.func_176734_d());
    }

    public float receiveTorque(float amount, EnumFacing side, boolean sim) {
        float f = this.maxTorque() - this.currentTorque;
        float ret = Math.min(amount, f);
        if (!sim) {
            this.currentTorque += ret;
        }
        return ret;
    }

    public float maxTorque() {
        return 512.0f;
    }

    public float getGearTier() {
        return 128.0f;
    }

    public float maxSpeed() {
        return 360.0f;
    }

    public DCHeatTier getHeat() {
        if (this.current != null) {
            return this.current.getHeat();
        }
        return DCHeatTier.ABSOLUTE;
    }

    public int func_70302_i_() {
        return 17;
    }

    protected int[] slotsTop() {
        return new int[]{0, 2, 4, 6, 9, 10, 11, 12};
    }

    protected int[] slotsBottom() {
        return new int[]{1, 3, 5, 7, 13, 14, 15, 16};
    }

    protected int[] slotsSides() {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        if (i == 0 || i == 2 || i == 4 || i == 6) {
            if (DCUtil.isEmpty((ItemStack)stack)) {
                return false;
            }
            IFluidHandlerItem cont = null;
            if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
                cont = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            } else if (stack.func_77973_b() instanceof IFluidHandlerItem) {
                cont = (IFluidHandlerItem)stack.func_77973_b();
            }
            return cont != null;
        }
        return i > 8 && i < 13;
    }

    public int canInsertResult(ItemStack item, int s1, int s2) {
        int ret = 0;
        if (DCUtil.isEmpty((ItemStack)item)) {
            return -1;
        }
        for (int i = s1; i < s2; ++i) {
            ret = this.inventory.canIncr(i, item);
            if (ret <= 0) continue;
            return ret;
        }
        return 0;
    }

    public List<ItemStack> getInputs() {
        return this.inventory.getInputs(9, 12);
    }

    public List<ItemStack> getOutputs() {
        return this.inventory.getOutputs(13, 16);
    }

    protected void onServerUpdate() {
        if (this.current != null) {
            super.onServerUpdate();
        }
        if (this.count <= 0) {
            if (this.inputT1.getFluidAmount() + this.inputT2.getFluidAmount() + this.outputT1.getFluidAmount() + this.outputT2.getFluidAmount() != this.last) {
                this.last = this.inputT1.getFluidAmount() + this.inputT2.getFluidAmount() + this.outputT1.getFluidAmount() + this.outputT2.getFluidAmount();
                if (!this.func_145830_o()) {
                    return;
                }
                List list = this.func_145831_w().field_73010_i;
                for (EntityPlayer player : list) {
                    if (!(player instanceof EntityPlayerMP)) continue;
                    ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)this.func_189518_D_());
                }
            }
            this.count = 10;
        } else {
            --this.count;
        }
    }

    public void updateTile() {
        if (!this.field_145850_b.field_72995_K) {
            this.processFluidSlots();
        }
        super.updateTile();
    }

    public void processFluidSlots() {
        this.processTank(this.inputT1, 0, 1, false);
        this.processTank(this.inputT2, 2, 3, false);
        this.processTank(this.outputT1, 4, 5, true);
        this.processTank(this.outputT2, 6, 7, true);
    }

    protected void processTank(DCTank tank, int slot1, int slot2, boolean flag) {
        if (!this.onDrainTank(tank, slot1, slot2, flag)) {
            this.onFillTank(tank, slot1, slot2);
        }
    }

    protected boolean onFillTank(DCTank tank, int slot1, int slot2) {
        ItemStack in = this.func_70301_a(slot1);
        ItemStack out = this.func_70301_a(slot2);
        if (DCUtil.isEmpty((ItemStack)in)) {
            return false;
        }
        IFluidHandlerItem dummy = null;
        ItemStack in2 = in.func_77946_l();
        if (in2.func_190916_E() > 1) {
            in2.func_190920_e(1);
        }
        if (in.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            dummy = (IFluidHandlerItem)in2.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        } else if (in.func_77973_b() instanceof IFluidHandlerItem) {
            dummy = (IFluidHandlerItem)in2.func_77973_b();
        }
        if (dummy != null && dummy.getTankProperties() != null && dummy.getTankProperties().length > 0) {
            boolean loose = false;
            ItemStack ret = ItemStack.field_190927_a;
            int max = dummy.getTankProperties()[0].getCapacity();
            FluidStack fc = dummy.drain(max, false);
            if (fc != null && fc.amount > 0 && tank.canFillTarget(fc)) {
                ret = ItemStack.field_190927_a;
                loose = false;
                boolean b = false;
                int rem = tank.getCapacity() - tank.getFluidAmount();
                fc = dummy.drain(rem, false);
                if (fc != null && fc.amount <= rem) {
                    FluidStack fill = null;
                    fill = dummy.drain(rem, true);
                    ret = dummy.getContainer();
                    if (fill != null && this.canInsertResult(ret, slot2, slot2 + 1) != 0) {
                        loose = true;
                        tank.fill(fill, true);
                    }
                }
            }
            if (loose) {
                this.func_70298_a(slot1, 1);
                this.incrStackInSlot(slot2, ret);
                this.func_70296_d();
                return true;
            }
        }
        return false;
    }

    protected boolean onDrainTank(DCTank tank, int slot1, int slot2, boolean flag) {
        ItemStack in = this.func_70301_a(slot1);
        ItemStack out = this.func_70301_a(slot2);
        if (DCUtil.isEmpty((ItemStack)in)) {
            return false;
        }
        IFluidHandlerItem dummy = null;
        ItemStack in2 = in.func_77946_l();
        if (in2.func_190916_E() > 1) {
            in2.func_190920_e(1);
        }
        if (in.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            dummy = (IFluidHandlerItem)in2.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        } else if (in.func_77973_b() instanceof IFluidHandlerItem) {
            dummy = (IFluidHandlerItem)in2.func_77973_b();
        }
        if (tank.getFluidAmount() > 0 && dummy != null && dummy.getTankProperties() != null && dummy.getTankProperties().length > 0) {
            boolean loose = false;
            ItemStack ret = null;
            int max = dummy.getTankProperties()[0].getCapacity();
            FluidStack fc = dummy.drain(max, false);
            boolean b = false;
            int rem = max;
            if (fc == null || fc.amount == 0) {
                b = true;
            } else {
                rem = max - fc.amount;
                if (tank.getFluidAmount() <= rem) {
                    b = true;
                }
            }
            if (b) {
                FluidStack drain = tank.drain(rem, false);
                int fill = 0;
                fill = dummy.fill(drain, true);
                ret = dummy.getContainer();
                if (fill > 0 && this.canInsertResult(ret, slot2, slot2 + 1) != 0) {
                    loose = true;
                    tank.drain(fill, true);
                }
            }
            if (loose) {
                this.func_70298_a(slot1, 1);
                this.incrStackInSlot(slot2, ret);
                this.func_70296_d();
                return true;
            }
        }
        return false;
    }

    public int getProcessTime() {
        return 1024;
    }

    public boolean isRecipeMaterial() {
        if (this.currentRecipe == null) {
            return false;
        }
        if (this.current != null && !this.currentRecipe.matchHeatTier(this.current.getHeat())) {
            this.currentRecipe = null;
            return false;
        }
        FluidStack inf1 = this.inputT1.getFluid();
        FluidStack inf2 = this.inputT2.getFluid();
        ArrayList<ItemStack> ins = new ArrayList<ItemStack>(this.getInputs());
        FluidStack outf1 = this.outputT1.getFluid();
        FluidStack outf2 = this.outputT2.getFluid();
        ArrayList<ItemStack> outs = new ArrayList<ItemStack>(this.getOutputs());
        ItemStack cat = this.func_70301_a(8);
        boolean b1 = this.currentRecipe.matches(ins, inf1, inf2);
        boolean b2 = this.currentRecipe.matchOutput(outs, outf1, outf2, 4);
        boolean b3 = this.currentRecipe.matchCatalyst(cat);
        boolean b4 = this.currentRecipe.additionalRequire(this.field_145850_b, this.field_174879_c);
        if (b1 && b2 && b3 && b4) {
            return true;
        }
        this.currentRecipe = null;
        return false;
    }

    public boolean canStartProcess() {
        if (this.current == null) {
            this.currentRecipe = null;
            return false;
        }
        FluidStack inf1 = this.inputT1.getFluid();
        FluidStack inf2 = this.inputT2.getFluid();
        ArrayList<ItemStack> ins = new ArrayList<ItemStack>(this.getInputs());
        FluidStack outf1 = this.outputT1.getFluid();
        FluidStack outf2 = this.outputT2.getFluid();
        ArrayList<ItemStack> outs = new ArrayList<ItemStack>(this.getOutputs());
        ItemStack cat = this.func_70301_a(8);
        IReactorRecipe recipe = RecipeAPI.registerReactorRecipes.getRecipe(this.current.getHeat(), ins, inf1, inf2, cat);
        if (recipe != null) {
            this.currentRecipe = recipe;
        }
        return this.currentRecipe != null;
    }

    public boolean onProcess() {
        if (this.currentRecipe != null) {
            int c2;
            int c1;
            ItemStack out = this.currentRecipe.getOutput();
            ItemStack sec = this.currentRecipe.getSecondary();
            float chance = MathHelper.func_76123_f((float)(this.currentRecipe.getSecondaryChance() * 100.0f));
            FluidStack inF1 = this.currentRecipe.getInputFluid();
            FluidStack inF2 = this.currentRecipe.getSubInputFluid();
            FluidStack outF1 = this.currentRecipe.getOutputFluid();
            FluidStack outF2 = this.currentRecipe.getSubOutputFluid();
            if (outF1 != null && (c1 = this.outputT1.fill(outF1, false)) < outF1.amount) {
                return false;
            }
            if (outF2 != null && (c2 = this.outputT2.fill(outF2, false)) < outF2.amount) {
                return false;
            }
            ArrayList required = new ArrayList(this.currentRecipe.getProcessedInput());
            if (!required.isEmpty()) {
                for (int i = 9; i < 13; ++i) {
                    ItemStack slot = this.inventory.func_70301_a(i);
                    if (DCUtil.isEmpty((ItemStack)slot)) continue;
                    boolean inRecipe = false;
                    Iterator req = required.iterator();
                    while (req.hasNext()) {
                        ArrayList list;
                        boolean match = false;
                        Object next = req.next();
                        int count = 1;
                        if (next instanceof ItemStack) {
                            count = ((ItemStack)next).func_190916_E();
                            match = OreDictionary.itemMatches((ItemStack)((ItemStack)next), (ItemStack)slot, (boolean)false) && slot.func_190916_E() >= count;
                        } else if (next instanceof ArrayList && (list = new ArrayList((ArrayList)next)) != null && !list.isEmpty()) {
                            for (ItemStack item : list) {
                                boolean f = OreDictionary.itemMatches((ItemStack)item, (ItemStack)slot, (boolean)false) && slot.func_190916_E() > 0;
                                if (!f) continue;
                                match = true;
                            }
                        }
                        if (!match) continue;
                        inRecipe = true;
                        required.remove(next);
                        this.func_70298_a(i, 1);
                        break;
                    }
                    if (!inRecipe) break;
                }
                if (!required.isEmpty()) {
                    return false;
                }
            }
            if (inF1 != null) {
                this.inputT1.drain(inF1.amount, true);
            }
            if (inF2 != null) {
                this.inputT2.drain(inF2.amount, true);
            }
            if (outF1 != null) {
                this.outputT1.fill(outF1, true);
            }
            if (outF2 != null) {
                this.outputT2.fill(outF2, true);
            }
            if (!DCUtil.isEmpty((ItemStack)out)) {
                this.inventory.insertResult(out.func_77946_l(), 13, 17);
            }
            if (!DCUtil.isEmpty((ItemStack)sec) && (float)this.field_145850_b.field_73012_v.nextInt(100) < chance) {
                this.inventory.insertResult(sec.func_77946_l(), 13, 17);
            }
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.currentBurnTime;
            }
            case 1: {
                return this.maxBurnTime;
            }
            case 2: {
                return this.current == null ? 0 : this.current.getClimateInt();
            }
            case 3: {
                return this.tankSide1 == null ? 1 : this.tankSide1.index;
            }
            case 4: {
                return this.tankSide2 == null ? 2 : this.tankSide2.index;
            }
            case 5: {
                return this.tankSide3 == null ? 0 : this.tankSide3.index;
            }
            case 6: {
                return this.tankSide4 == null ? 3 : this.tankSide4.index;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.currentBurnTime = value;
                break;
            }
            case 1: {
                this.maxBurnTime = value;
                break;
            }
            case 2: {
                this.current = ClimateAPI.register.getClimateFromInt(value);
                break;
            }
            case 3: {
                this.tankSide1 = EnumSide.fromIndex((int)value);
                break;
            }
            case 4: {
                this.tankSide2 = EnumSide.fromIndex((int)value);
                break;
            }
            case 5: {
                this.tankSide3 = EnumSide.fromIndex((int)value);
                break;
            }
            case 6: {
                this.tankSide4 = EnumSide.fromIndex((int)value);
            }
        }
    }

    public int func_174890_g() {
        return 7;
    }

    public String func_70005_c_() {
        return "dcs.gui.device.reactor";
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerReactor(this, playerInventory);
    }

    public String func_174875_k() {
        return "dcs.gui.device.reactor";
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (facing == this.tankSide1.face) {
                return (T)this.inputT1;
            }
            if (facing == this.tankSide2.face) {
                return (T)this.inputT2;
            }
            if (facing == this.tankSide3.face) {
                return (T)this.outputT1;
            }
            if (facing == this.tankSide4.face) {
                return (T)this.outputT2;
            }
            return (T)(facing == EnumFacing.DOWN ? this.handlerTank3 : (facing == EnumFacing.UP ? this.handlerTank1 : this.handlerTank4));
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inputT1 = this.inputT1.readFromNBT(tag, "Tank1");
        this.inputT2 = this.inputT2.readFromNBT(tag, "Tank2");
        this.outputT1 = this.outputT1.readFromNBT(tag, "Tank3");
        this.outputT2 = this.outputT2.readFromNBT(tag, "Tank4");
        byte i1 = tag.func_74771_c("Side1");
        byte i2 = tag.func_74771_c("Side2");
        byte i3 = tag.func_74771_c("Side3");
        byte i4 = tag.func_74771_c("Side4");
        this.tankSide1 = EnumSide.fromIndex((int)i1);
        this.tankSide2 = EnumSide.fromIndex((int)i2);
        this.tankSide3 = EnumSide.fromIndex((int)i3);
        this.tankSide4 = EnumSide.fromIndex((int)i4);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.inputT1.writeToNBT(tag, "Tank1");
        this.inputT2.writeToNBT(tag, "Tank2");
        this.outputT1.writeToNBT(tag, "Tank3");
        this.outputT2.writeToNBT(tag, "Tank4");
        tag.func_74774_a("Side1", (byte)this.tankSide1.index);
        tag.func_74774_a("Side2", (byte)this.tankSide2.index);
        tag.func_74774_a("Side3", (byte)this.tankSide3.index);
        tag.func_74774_a("Side4", (byte)this.tankSide4.index);
        return tag;
    }

    public NBTTagCompound getNBT(NBTTagCompound tag) {
        super.getNBT(tag);
        this.inputT1.writeToNBT(tag, "Tank1");
        this.inputT2.writeToNBT(tag, "Tank2");
        this.outputT1.writeToNBT(tag, "Tank3");
        this.outputT2.writeToNBT(tag, "Tank4");
        tag.func_74774_a("Side1", (byte)this.tankSide1.index);
        tag.func_74774_a("Side2", (byte)this.tankSide2.index);
        tag.func_74774_a("Side3", (byte)this.tankSide3.index);
        tag.func_74774_a("Side4", (byte)this.tankSide4.index);
        return tag;
    }

    public void setNBT(NBTTagCompound tag) {
        super.setNBT(tag);
        this.inputT1 = this.inputT1.readFromNBT(tag, "Tank1");
        this.inputT2 = this.inputT2.readFromNBT(tag, "Tank2");
        this.outputT1 = this.outputT1.readFromNBT(tag, "Tank3");
        this.outputT2 = this.outputT2.readFromNBT(tag, "Tank4");
        byte i1 = tag.func_74771_c("Side1");
        byte i2 = tag.func_74771_c("Side2");
        byte i3 = tag.func_74771_c("Side3");
        byte i4 = tag.func_74771_c("Side4");
        this.tankSide1 = EnumSide.fromIndex((int)i1);
        this.tankSide2 = EnumSide.fromIndex((int)i2);
        this.tankSide3 = EnumSide.fromIndex((int)i3);
        this.tankSide4 = EnumSide.fromIndex((int)i4);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        this.func_189515_b(nbtTagCompound);
        return new SPacketUpdateTileEntity(this.field_174879_c, -50, nbtTagCompound);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean func_191420_l() {
        return this.inventory.func_191420_l();
    }
}

