/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.machine.block;

import defeatedcrow.hac.api.energy.ITorqueReceiver;
import defeatedcrow.hac.api.recipe.ICrusherRecipe;
import defeatedcrow.hac.api.recipe.RecipeAPI;
import defeatedcrow.hac.core.climate.recipe.CrusherRecipe;
import defeatedcrow.hac.core.energy.TileTorqueProcessor;
import defeatedcrow.hac.core.fluid.DCTank;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.machine.MachineInit;
import defeatedcrow.hac.machine.gui.ContainerCrusher;
import defeatedcrow.hac.main.block.fluid.SidedFluidTankWrapper;
import defeatedcrow.hac.main.packet.DCMainPacket;
import defeatedcrow.hac.main.packet.MessageSingleTank;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.oredict.OreDictionary;

public class TileRollerCrusher
extends TileTorqueProcessor
implements ITorqueReceiver {
    private ICrusherRecipe currentRecipe;
    public DCTank outputT1 = new DCTank(5000);
    private int lastOutT1 = 0;
    private int lastBurn = 0;
    private int count = 0;
    private int last = 0;
    SidedFluidTankWrapper handlerTank3 = new SidedFluidTankWrapper(this.outputT1, true, false);

    public int getMaxTickCount() {
        return 1;
    }

    public boolean isInputSide(EnumFacing side) {
        return side == this.getBaseSide();
    }

    public boolean isOutputSide(EnumFacing side) {
        return false;
    }

    public boolean canReceiveTorque(float amount, EnumFacing side) {
        if (this.currentTorque >= this.maxTorque()) {
            return false;
        }
        return this.isInputSide(side.func_176734_d());
    }

    public float receiveTorque(float amount, EnumFacing side, boolean sim) {
        float f = this.maxTorque() - this.currentTorque;
        float ret = Math.min(amount, f);
        if (!sim) {
            this.currentTorque += ret;
        }
        return ret;
    }

    public float maxTorque() {
        return 512.0f;
    }

    public float getGearTier() {
        return 128.0f;
    }

    public float maxSpeed() {
        return 360.0f;
    }

    public int func_70302_i_() {
        return 7;
    }

    protected int[] slotsTop() {
        return new int[]{0, 1, 6};
    }

    protected int[] slotsBottom() {
        return new int[]{2, 3, 4, 5};
    }

    protected int[] slotsSides() {
        return new int[]{0, 1, 2, 3, 4, 5, 6};
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        if (i == 1) {
            if (DCUtil.isEmpty((ItemStack)stack)) {
                return false;
            }
            IFluidHandlerItem cont = null;
            if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
                cont = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            } else if (stack.func_77973_b() instanceof IFluidHandlerItem) {
                cont = (IFluidHandlerItem)stack.func_77973_b();
            }
            return cont != null;
        }
        return i == 0;
    }

    public int canInsertResult(ItemStack item, int s1, int s2) {
        int ret = 0;
        if (DCUtil.isEmpty((ItemStack)item)) {
            return -1;
        }
        for (int i = s1; i < s2; ++i) {
            ret = this.inventory.canIncr(i, item);
            if (ret <= 0) continue;
            return ret;
        }
        return 0;
    }

    public List<ItemStack> getInputs() {
        return this.inventory.getInputs(0, 0);
    }

    public List<ItemStack> getOutputs() {
        return this.inventory.getOutputs(3, 5);
    }

    public void updateTile() {
        if (!this.field_145850_b.field_72995_K) {
            this.processFluidSlots();
        }
        super.updateTile();
    }

    protected void onServerUpdate() {
        if (this.current != null) {
            super.onServerUpdate();
        }
        if (this.count <= 0) {
            if (this.outputT1.getFluidAmount() != this.last) {
                this.last = this.outputT1.getFluidAmount();
                DCMainPacket.INSTANCE.sendToAll((IMessage)new MessageSingleTank(this.field_174879_c, this.outputT1.getFluidIdName(), this.outputT1.getFluidAmount()));
            }
            this.count = 10;
        } else {
            --this.count;
        }
    }

    public void processFluidSlots() {
        this.processTank(this.outputT1, 1, 2, false);
    }

    protected void processTank(DCTank tank, int slot1, int slot2, boolean flag) {
        if (!this.onDrainTank(tank, slot1, slot2, flag)) {
            this.onFillTank(tank, slot1, slot2);
        }
    }

    protected boolean onFillTank(DCTank tank, int slot1, int slot2) {
        ItemStack in = this.func_70301_a(slot1);
        ItemStack out = this.func_70301_a(slot2);
        if (DCUtil.isEmpty((ItemStack)in)) {
            return false;
        }
        IFluidHandlerItem dummy = null;
        ItemStack in2 = in.func_77946_l();
        if (in2.func_190916_E() > 1) {
            in2.func_190920_e(1);
        }
        if (in.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            dummy = (IFluidHandlerItem)in2.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        } else if (in.func_77973_b() instanceof IFluidHandler) {
            dummy = (IFluidHandlerItem)in2.func_77973_b();
        }
        if (dummy != null && dummy.getTankProperties() != null && dummy.getTankProperties().length > 0) {
            boolean loose = false;
            ItemStack ret = ItemStack.field_190927_a;
            int max = dummy.getTankProperties()[0].getCapacity();
            FluidStack fc = dummy.drain(max, false);
            if (fc != null && fc.amount > 0 && tank.canFillTarget(fc)) {
                ret = ItemStack.field_190927_a;
                loose = false;
                boolean b = false;
                int rem = tank.getCapacity() - tank.getFluidAmount();
                fc = dummy.drain(rem, false);
                if (fc != null && fc.amount <= rem) {
                    FluidStack fill = null;
                    fill = dummy.drain(rem, true);
                    ret = dummy.getContainer();
                    if (fill != null && this.canInsertResult(ret, slot2, slot2 + 1) != 0) {
                        loose = true;
                        tank.fill(fill, true);
                    }
                }
            }
            if (loose) {
                this.func_70298_a(slot1, 1);
                this.incrStackInSlot(slot2, ret);
                this.func_70296_d();
                return true;
            }
        }
        return false;
    }

    protected boolean onDrainTank(DCTank tank, int slot1, int slot2, boolean flag) {
        ItemStack in = this.func_70301_a(slot1);
        ItemStack out = this.func_70301_a(slot2);
        if (DCUtil.isEmpty((ItemStack)in)) {
            return false;
        }
        IFluidHandlerItem dummy = null;
        ItemStack in2 = in.func_77946_l();
        if (in2.func_190916_E() > 1) {
            in2.func_190920_e(1);
        }
        if (in.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            dummy = (IFluidHandlerItem)in2.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        } else if (in.func_77973_b() instanceof IFluidHandlerItem) {
            dummy = (IFluidHandlerItem)in2.func_77973_b();
        }
        if (tank.getFluidAmount() > 0 && dummy != null && dummy.getTankProperties() != null && dummy.getTankProperties().length > 0) {
            boolean loose = false;
            ItemStack ret = null;
            int max = dummy.getTankProperties()[0].getCapacity();
            FluidStack fc = dummy.drain(max, false);
            boolean b = false;
            int rem = max;
            if (fc == null || fc.amount == 0) {
                b = true;
            } else {
                rem = max - fc.amount;
                if (tank.getFluidAmount() <= rem) {
                    b = true;
                }
            }
            if (b) {
                FluidStack drain = tank.drain(rem, false);
                int fill = 0;
                fill = dummy.fill(drain, true);
                ret = dummy.getContainer();
                if (fill > 0 && this.canInsertResult(ret, slot2, slot2 + 1) != 0) {
                    loose = true;
                    tank.drain(fill, true);
                }
            }
            if (loose) {
                this.func_70298_a(slot1, 1);
                this.incrStackInSlot(slot2, ret);
                this.func_70296_d();
                return true;
            }
        }
        return false;
    }

    public int getProcessTime() {
        return 512;
    }

    public boolean isRecipeMaterial() {
        if (this.currentRecipe == null) {
            return false;
        }
        ItemStack ins = this.func_70301_a(0);
        FluidStack outf1 = this.outputT1.getFluid();
        ArrayList<ItemStack> outs = new ArrayList<ItemStack>(this.getOutputs());
        ItemStack cat = this.func_70301_a(6);
        boolean b1 = this.currentRecipe.matches(ins);
        boolean b2 = this.currentRecipe.matchOutput(outs, outf1, 3);
        boolean b3 = this.currentRecipe.matchCatalyst(cat);
        if (b1 && b2 && b3) {
            return true;
        }
        this.currentRecipe = null;
        return false;
    }

    public boolean canStartProcess() {
        ItemStack cat;
        if (this.current == null) {
            this.currentRecipe = null;
            return false;
        }
        ItemStack ins = this.func_70301_a(0);
        ICrusherRecipe recipe = RecipeAPI.registerCrushers.getRecipe(ins, cat = this.func_70301_a(6));
        if (recipe != null) {
            this.currentRecipe = recipe;
        } else if (DCUtil.isSameItem((ItemStack)cat, (ItemStack)new ItemStack(MachineInit.rotaryBlade, 1, 3), (boolean)false)) {
            this.currentRecipe = this.getReverseRecipe();
        }
        return this.currentRecipe != null;
    }

    public boolean onProcess() {
        if (this.currentRecipe != null) {
            int c1;
            ItemStack out = this.currentRecipe.getOutput();
            ItemStack sec = this.currentRecipe.getSecondary();
            ItemStack tert = this.currentRecipe.getTertialy();
            float chance0 = this.currentRecipe.getChance() * 100.0f;
            float chance1 = this.currentRecipe.getSecondaryChance() * 100.0f;
            float chance2 = this.currentRecipe.getTertialyChance() * 100.0f;
            FluidStack outF1 = this.currentRecipe.getOutputFluid();
            if (outF1 != null && (c1 = this.outputT1.fill(outF1, false)) < outF1.amount) {
                return false;
            }
            ItemStack slot = this.inventory.func_70301_a(0);
            if (!this.currentRecipe.matches(slot)) {
                return false;
            }
            int consume = this.consumeAmo(slot);
            this.func_70298_a(0, consume);
            if (outF1 != null) {
                this.outputT1.fill(outF1, true);
            }
            this.field_145850_b.field_73012_v.nextInt(100);
            if (!DCUtil.isEmpty((ItemStack)out) && (float)this.field_145850_b.field_73012_v.nextInt(100) < chance0) {
                this.inventory.insertResult(out.func_77946_l(), 3, 6);
            }
            if (!DCUtil.isEmpty((ItemStack)sec) && (float)this.field_145850_b.field_73012_v.nextInt(100) < chance1) {
                this.inventory.insertResult(sec.func_77946_l(), 3, 6);
            }
            if (!DCUtil.isEmpty((ItemStack)tert) && (float)this.field_145850_b.field_73012_v.nextInt(100) < chance2) {
                this.inventory.insertResult(tert.func_77946_l(), 3, 6);
            }
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public int consumeAmo(ItemStack in) {
        if (this.currentRecipe == null) {
            return -1;
        }
        ArrayList required = new ArrayList(this.currentRecipe.getProcessedInput());
        if (!DCUtil.isEmpty((ItemStack)in) && !required.isEmpty()) {
            for (ItemStack next : required) {
                if (!DCUtil.isIntegratedItem((ItemStack)in, (ItemStack)next, (boolean)false) || in.func_190916_E() < next.func_190916_E()) continue;
                return next.func_190916_E();
            }
        }
        return -1;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.currentBurnTime;
            }
            case 1: {
                return this.maxBurnTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.currentBurnTime = value;
                break;
            }
            case 1: {
                this.maxBurnTime = value;
            }
        }
    }

    public int func_174890_g() {
        return 2;
    }

    public String func_70005_c_() {
        return "dcs.gui.device.crusher";
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerCrusher(this, playerInventory);
    }

    public String func_174875_k() {
        return "dcs.gui.device.reactor";
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.handlerTank3;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.outputT1 = this.outputT1.readFromNBT(tag, "Tank");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.outputT1.writeToNBT(tag, "Tank");
        return tag;
    }

    public NBTTagCompound getNBT(NBTTagCompound tag) {
        super.getNBT(tag);
        this.outputT1.writeToNBT(tag, "Tank");
        return tag;
    }

    public void setNBT(NBTTagCompound tag) {
        super.setNBT(tag);
        this.outputT1 = this.outputT1.readFromNBT(tag, "Tank");
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        this.func_189515_b(nbtTagCompound);
        return new SPacketUpdateTileEntity(this.field_174879_c, -50, nbtTagCompound);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean func_191420_l() {
        return this.inventory.func_191420_l();
    }

    public CrusherRecipe getReverseRecipe() {
        ItemStack ins = this.func_70301_a(0);
        ItemStack cat = this.func_70301_a(6);
        if (DCUtil.isSameItem((ItemStack)cat, (ItemStack)new ItemStack(MachineInit.rotaryBlade, 1, 3), (boolean)false)) {
            if (DCUtil.isEmpty((ItemStack)ins) || ins.func_77973_b() instanceof ItemBlock || this.isIngotOrGem(ins) != null) {
                return null;
            }
            IRecipe recipe = null;
            for (IRecipe rec : CraftingManager.field_193380_a) {
                ItemStack out = rec.func_77571_b();
                if (rec == null || DCUtil.isEmpty((ItemStack)out)) continue;
                if (ins.func_77973_b().func_77645_m() && ins.func_77973_b() == out.func_77973_b()) {
                    if (out.func_190916_E() != 1) break;
                    recipe = rec;
                    break;
                }
                if (!DCUtil.isSameItem((ItemStack)ins, (ItemStack)out, (boolean)false)) continue;
                if (out.func_190916_E() != 1) break;
                recipe = rec;
                break;
            }
            if (recipe == null) {
                return null;
            }
            NonNullList list = NonNullList.func_191196_a();
            NonNullList items = recipe.func_192400_c();
            for (Ingredient item : items) {
                ItemStack ret;
                ItemStack check;
                String name;
                if (DCUtil.isEmptyIngredient((Ingredient)item) || (name = this.getIngotOrGem(check = item.func_193365_a()[0])) == null || DCUtil.isEmpty((ItemStack)(ret = this.getNamedItem(name)))) continue;
                boolean b = false;
                for (ItemStack c2 : list) {
                    if (!DCUtil.isSameItem((ItemStack)ret, (ItemStack)c2, (boolean)false)) continue;
                    c2.func_190917_f(1);
                    b = true;
                    break;
                }
                if (b || list.size() >= 3) continue;
                list.add((Object)ret.func_77946_l());
            }
            if (!list.isEmpty()) {
                for (ItemStack c3 : list) {
                    if (c3.func_190916_E() <= 1) continue;
                    c3.func_190918_g(1);
                }
                ItemStack o1 = ((ItemStack)list.get(0)).func_77946_l();
                ItemStack o2 = list.size() < 2 ? ItemStack.field_190927_a : ((ItemStack)list.get(1)).func_77946_l();
                ItemStack o3 = list.size() < 3 ? ItemStack.field_190927_a : ((ItemStack)list.get(2)).func_77946_l();
                CrusherRecipe current = new CrusherRecipe(o1, 1.0f, o2, 1.0f, o3, 1.0f, null, cat, (Object)ins.func_77946_l().func_77979_a(1));
                return current;
            }
        }
        return null;
    }

    private String getIngotOrGem(ItemStack item) {
        int[] ids;
        for (int id : ids = OreDictionary.getOreIDs((ItemStack)item)) {
            String name = OreDictionary.getOreName((int)id);
            if (name.contains("ingot") || name.contains("gem") || name.contains("dust")) {
                return name;
            }
            if (name.contains("gear")) {
                String name2 = name.replace("gear", "ingot");
                return name2;
            }
            if (name.contains("plate")) {
                String name2 = name.replace("plate", "ingot");
                return name2;
            }
            if (!name.contains("blade")) continue;
            String name2 = name.replace("blade", "ingot");
            return name2;
        }
        return null;
    }

    private String isIngotOrGem(ItemStack item) {
        int[] ids;
        for (int id : ids = OreDictionary.getOreIDs((ItemStack)item)) {
            String name = OreDictionary.getOreName((int)id);
            if (!name.contains("ingot") && !name.contains("gem") && !name.contains("dust")) continue;
            return name;
        }
        return null;
    }

    private ItemStack getNamedItem(String name) {
        NonNullList ret = OreDictionary.getOres((String)name);
        if (!ret.isEmpty()) {
            return (ItemStack)ret.get(0);
        }
        return ItemStack.field_190927_a;
    }
}

