/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.machine.block;

import com.google.common.collect.Lists;
import defeatedcrow.hac.api.energy.ITorqueProvider;
import defeatedcrow.hac.api.energy.ITorqueReceiver;
import defeatedcrow.hac.core.energy.TileTorqueBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileShaft_TB
extends TileTorqueBase
implements ITorqueProvider,
ITorqueReceiver {
    public void updateTile() {
        super.updateTile();
        for (EnumFacing side : this.getOutputSide()) {
            this.provideTorque(this.field_145850_b, this.func_174877_v().func_177972_a(side), side, false);
        }
    }

    public boolean hasFaceSide() {
        return true;
    }

    public List<EnumFacing> getOutputSide() {
        ArrayList ret = Lists.newArrayList();
        byte i = this.facing;
        EnumFacing face = TileShaft_TB.rotateAround((int)i, (EnumFacing)this.getBaseSide());
        ret.add(face);
        ret.add(face.func_176734_d());
        return ret;
    }

    public float getAmount() {
        return this.getCurrentTorque() * this.getFrictionalForce();
    }

    public boolean canProvideTorque(World world, BlockPos outputPos, EnumFacing output) {
        TileEntity tile = world.func_175625_s(outputPos);
        float amo = this.getAmount() * 0.5f;
        if (tile != null && tile instanceof ITorqueReceiver && amo > 0.0f) {
            return ((ITorqueReceiver)tile).canReceiveTorque(amo, output.func_176734_d());
        }
        return false;
    }

    public float provideTorque(World world, BlockPos outputPos, EnumFacing output, boolean sim) {
        float amo = this.getAmount() * 0.5f;
        if (this.canProvideTorque(world, outputPos, output)) {
            ITorqueReceiver target = (ITorqueReceiver)world.func_175625_s(outputPos);
            float ret = target.receiveTorque(amo, output, sim);
            return ret;
        }
        return 0.0f;
    }

    public boolean isInputSide(EnumFacing side) {
        return side == this.getBaseSide().func_176734_d();
    }

    public boolean isOutputSide(EnumFacing side) {
        return this.getOutputSide().contains(side);
    }

    public boolean canReceiveTorque(float amount, EnumFacing side) {
        if (this.currentTorque >= this.maxTorque()) {
            return false;
        }
        return this.isInputSide(side.func_176734_d());
    }

    public float receiveTorque(float amount, EnumFacing side, boolean sim) {
        float f = this.maxTorque() - this.currentTorque;
        float ret = Math.min(amount, f);
        if (!sim) {
            this.currentTorque += ret;
        }
        return ret;
    }
}

