/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.machine.block;

import com.google.common.collect.Lists;
import defeatedcrow.hac.api.energy.ITorqueProvider;
import defeatedcrow.hac.api.energy.ITorqueReceiver;
import defeatedcrow.hac.api.recipe.ISpinningRecipe;
import defeatedcrow.hac.api.recipe.RecipeAPI;
import defeatedcrow.hac.core.energy.TileTorqueProcessor;
import defeatedcrow.hac.machine.gui.ContainerSpinning;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileSpinningMachine
extends TileTorqueProcessor
implements ITorqueProvider,
ITorqueReceiver {
    public void updateTile() {
        super.updateTile();
        for (EnumFacing side : this.getOutputSide()) {
            this.provideTorque(this.field_145850_b, this.func_174877_v().func_177972_a(side), side, false);
        }
    }

    public boolean isInputSide(EnumFacing side) {
        if (this.getBaseSide().func_176740_k().func_176720_b()) {
            return side == EnumFacing.WEST;
        }
        return side == this.getBaseSide().func_176746_e().func_176734_d();
    }

    public List<EnumFacing> getOutputSide() {
        ArrayList ret = Lists.newArrayList();
        if (this.getBaseSide().func_176740_k().func_176720_b()) {
            ret.add(EnumFacing.EAST);
        } else {
            ret.add(this.getBaseSide().func_176746_e());
        }
        return ret;
    }

    public float getAmount() {
        return this.getCurrentTorque() * this.getFrictionalForce();
    }

    public boolean canReceiveTorque(float amount, EnumFacing side) {
        if (this.currentTorque >= this.maxTorque()) {
            return false;
        }
        return this.isInputSide(side);
    }

    public float receiveTorque(float amount, EnumFacing side, boolean sim) {
        float f = this.maxTorque() - this.currentTorque;
        float ret = Math.min(amount, f);
        if (!sim) {
            this.currentTorque += ret;
        }
        return ret;
    }

    public boolean canProvideTorque(World world, BlockPos outputPos, EnumFacing output) {
        TileEntity tile = world.func_175625_s(outputPos);
        float amo = this.getAmount();
        if (tile != null && tile instanceof ITorqueReceiver && amo > 0.0f) {
            return ((ITorqueReceiver)tile).canReceiveTorque(amo, output.func_176734_d());
        }
        return false;
    }

    public float provideTorque(World world, BlockPos outputPos, EnumFacing output, boolean sim) {
        float amo = this.getAmount();
        if (this.canProvideTorque(world, outputPos, output)) {
            ITorqueReceiver target = (ITorqueReceiver)world.func_175625_s(outputPos);
            float ret = target.receiveTorque(amo, output, sim);
            return ret;
        }
        return 0.0f;
    }

    public float getGearTier() {
        return 16.0f;
    }

    public int getProcessTime() {
        return 64;
    }

    public boolean isRecipeMaterial() {
        ItemStack in = this.func_70301_a(0);
        ISpinningRecipe recipe = RecipeAPI.registerSpinningRecipes.getRecipe(in);
        return recipe != null;
    }

    public boolean canStartProcess() {
        ItemStack in = this.func_70301_a(0);
        ISpinningRecipe recipe = RecipeAPI.registerSpinningRecipes.getRecipe(in);
        if (recipe != null) {
            ItemStack out = this.func_70301_a(1);
            return recipe.matchOutput(out);
        }
        return false;
    }

    public boolean onProcess() {
        ItemStack out2;
        int i1;
        ItemStack in = this.func_70301_a(0);
        ItemStack out = this.func_70301_a(1);
        ISpinningRecipe recipe = RecipeAPI.registerSpinningRecipes.getRecipe(in);
        if (recipe != null && recipe.matchOutput(out) && (i1 = this.inventory.insertResult(out2 = recipe.getOutput(), 1, 2)) > 0) {
            this.func_70298_a(0, recipe.getInputCount());
            return true;
        }
        return false;
    }

    public String func_70005_c_() {
        return "dcs.gui.device.spinning";
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerSpinning(this, playerInventory);
    }

    public String func_174875_k() {
        return "dcs.gui.device.spinning_machine";
    }

    public boolean func_191420_l() {
        return this.inventory.func_191420_l();
    }
}

