/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.machine.block;

import defeatedcrow.hac.api.energy.ITorqueReceiver;
import defeatedcrow.hac.core.energy.TileTorqueBase;
import defeatedcrow.hac.core.fluid.DCTank;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.BlockFluidFinite;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileWaterPump
extends TileTorqueBase
implements ITorqueReceiver {
    public int currentProgressTime = 0;
    public static final int MAX_PROGRESS_TIME = 128;
    private int lastBurn = 0;
    public DCTank inputT = new DCTank(5000);
    private int loadCount = 3;

    public void updateTile() {
        super.updateTile();
        if (this.loadCount > 0) {
            --this.loadCount;
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            IFluidHandler tank;
            int ret;
            this.currentProgressTime += MathHelper.func_76141_d((float)this.prevTorque);
            int limit = this.currentProgressTime / 32;
            this.currentProgressTime = ret = this.currentProgressTime % 32;
            BlockPos next = this.func_174877_v().func_177977_b();
            BlockPos prev = this.func_174877_v().func_177977_b();
            int fill = 0;
            int count = 0;
            for (int i = 0; i < 4 && count < limit; ++count, ++i) {
                IBlockState state;
                if (this.field_145850_b.func_175623_d(next)) {
                    for (int d = 1; d < 5; ++d) {
                        if (this.field_145850_b.func_175623_d(next.func_177979_c(d))) continue;
                        next = next.func_177979_c(d);
                        break;
                    }
                }
                if ((state = this.field_145850_b.func_180495_p(next)) != null && state.func_177230_c() instanceof BlockLiquid) {
                    BlockLiquid liq = (BlockLiquid)state.func_177230_c();
                    fill = this.fillLiquid(liq, next, state);
                } else if (state != null && state.func_177230_c() instanceof BlockFluidBase) {
                    BlockFluidFinite flu;
                    if (state.func_177230_c() instanceof BlockFluidFinite) {
                        flu = (BlockFluidFinite)state.func_177230_c();
                        FluidStack get = flu.drain(this.field_145850_b, next, false);
                        if (get != null && this.inputT.fill(get, false) > 0) {
                            flu.drain(this.field_145850_b, next, true);
                            fill = this.inputT.fill(get, true);
                        }
                    } else if (state.func_177230_c() instanceof BlockFluidClassic) {
                        flu = (BlockFluidClassic)state.func_177230_c();
                        fill = this.fillFluid((BlockFluidClassic)flu, next, state);
                    }
                }
                if (fill <= 0) break;
                EnumFacing nF = EnumFacing.DOWN;
                for (EnumFacing f2 : EnumFacing.field_176754_o) {
                    BlockPos p2 = next.func_177972_a(f2);
                    IBlockState s2 = this.field_145850_b.func_180495_p(p2);
                    if (!(s2.func_177230_c() instanceof BlockLiquid) && !(s2.func_177230_c() instanceof BlockFluidBase) || s2.func_177230_c().func_176201_c(s2) >= state.func_177230_c().func_176201_c(state)) continue;
                    nF = f2;
                }
                next = next.func_177972_a(nF);
            }
            TileEntity uTile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177984_a());
            FluidStack fluid2 = this.inputT.getFluid();
            if (uTile != null && uTile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.DOWN) && (tank = (IFluidHandler)uTile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.DOWN)) != null && fluid2 != null && tank.fill(fluid2, false) > 0) {
                int ext2 = tank.fill(fluid2, true);
                this.inputT.drain(ext2, true);
                this.func_70296_d();
                uTile.func_70296_d();
            }
        }
    }

    private int fillLiquid(BlockLiquid liq, BlockPos tPos, IBlockState state) {
        int level = (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b);
        if (state.func_185904_a() == Material.field_151586_h) {
            FluidStack get = new FluidStack(FluidRegistry.WATER, 1000);
            if (this.inputT.fill(get, false) > 0) {
                return this.inputT.fill(get, true);
            }
        } else if (state.func_185904_a() == Material.field_151587_i) {
            FluidStack get = new FluidStack(FluidRegistry.LAVA, 1000);
            if (level == 0) {
                if (this.inputT.fill(get, false) > 0) {
                    this.field_145850_b.func_175698_g(tPos);
                    return this.inputT.fill(get, true);
                }
            } else {
                IBlockState s3;
                BlockPos next = tPos;
                int l2 = level;
                if (this.inputT.fill(get, false) <= 0) {
                    return 0;
                }
                for (int count = 0; count < 8; ++count) {
                    int[] ofs = new int[]{0, 0, 0};
                    for (EnumFacing f2 : EnumFacing.field_82609_l) {
                        BlockPos p2;
                        IBlockState s2;
                        if (f2 == EnumFacing.DOWN || !((s2 = this.field_145850_b.func_180495_p(p2 = next.func_177972_a(f2))).func_177230_c() instanceof BlockLiquid) || s2.func_185904_a() != Material.field_151587_i) continue;
                        BlockLiquid liq2 = (BlockLiquid)s2.func_177230_c();
                        if ((Integer)s2.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
                            ofs = new int[]{f2.func_82601_c(), f2.func_96559_d(), f2.func_82599_e()};
                            l2 = (Integer)s2.func_177229_b((IProperty)BlockLiquid.field_176367_b);
                            break;
                        }
                        if ((Integer)s2.func_177229_b((IProperty)BlockLiquid.field_176367_b) < l2) {
                            ofs = new int[]{f2.func_82601_c(), f2.func_96559_d(), f2.func_82599_e()};
                            l2 = (Integer)s2.func_177229_b((IProperty)BlockLiquid.field_176367_b);
                            continue;
                        }
                        BlockPos p3 = p2.func_177984_a();
                        IBlockState s32 = this.field_145850_b.func_180495_p(p3);
                        if (!(s32.func_177230_c() instanceof BlockLiquid) || s32.func_185904_a() != Material.field_151587_i) continue;
                        ofs = new int[]{f2.func_82601_c(), f2.func_96559_d() + 1, f2.func_82599_e()};
                        l2 = (Integer)s32.func_177229_b((IProperty)BlockLiquid.field_176367_b);
                        break;
                    }
                    if (ofs[0] == 0 && ofs[1] == 0 && ofs[2] == 0 || (Integer)this.field_145850_b.func_180495_p(next = next.func_177982_a(ofs[0], ofs[1], ofs[2])).func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) break;
                }
                if (!next.equals((Object)tPos) && (s3 = this.field_145850_b.func_180495_p(next)).func_177230_c() instanceof BlockLiquid && (Integer)s3.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0 && this.inputT.fill(get, false) > 0) {
                    this.field_145850_b.func_175698_g(next);
                    return this.inputT.fill(get, true);
                }
            }
        }
        return 0;
    }

    private int fillFluid(BlockFluidClassic flu, BlockPos tPos, IBlockState state) {
        IBlockState s4;
        boolean gas;
        int level = (Integer)state.func_177229_b((IProperty)BlockFluidBase.LEVEL);
        Fluid fluid = flu.getFluid();
        boolean bl = gas = flu.getFluid().getDensity() < 0;
        if (fluid == null) {
            return 0;
        }
        FluidStack get = new FluidStack(fluid, 1000);
        if (flu.isSourceBlock((IBlockAccess)this.field_145850_b, tPos)) {
            if (this.inputT.fill(get, false) > 0) {
                flu.drain(this.field_145850_b, tPos, true);
                return this.inputT.fill(get, true);
            }
            return 0;
        }
        BlockPos next = tPos;
        int l2 = flu.getQuantaValue((IBlockAccess)this.field_145850_b, tPos);
        for (int count = 0; count < 8; ++count) {
            int[] ofs = new int[3];
            for (EnumFacing f2 : EnumFacing.field_82609_l) {
                BlockFluidClassic flu3;
                BlockFluidClassic flu2;
                BlockPos p2;
                IBlockState s2;
                if (!gas && f2 == EnumFacing.DOWN || !((s2 = this.field_145850_b.func_180495_p(p2 = next.func_177972_a(f2))).func_177230_c() instanceof BlockFluidClassic) || (flu2 = (BlockFluidClassic)s2.func_177230_c()).getFluid() != fluid) continue;
                if (flu2.isSourceBlock((IBlockAccess)this.field_145850_b, p2)) {
                    ofs = new int[]{f2.func_82601_c(), f2.func_96559_d(), f2.func_82599_e()};
                    l2 = flu2.getQuantaValue((IBlockAccess)this.field_145850_b, p2);
                    break;
                }
                if (flu2.getQuantaValue((IBlockAccess)this.field_145850_b, p2) > l2) {
                    ofs = new int[]{f2.func_82601_c(), f2.func_96559_d(), f2.func_82599_e()};
                    l2 = flu2.getQuantaValue((IBlockAccess)this.field_145850_b, p2);
                    continue;
                }
                BlockPos p3 = gas ? p2.func_177977_b() : p2.func_177984_a();
                IBlockState s3 = this.field_145850_b.func_180495_p(p3);
                if (!(s3.func_177230_c() instanceof BlockFluidClassic) || (flu3 = (BlockFluidClassic)s3.func_177230_c()).getFluid() != fluid) continue;
                ofs = new int[]{f2.func_82601_c(), f2.func_96559_d() + (gas ? -1 : 1), f2.func_82599_e()};
                l2 = flu3.getQuantaValue((IBlockAccess)this.field_145850_b, p3);
                break;
            }
            if (ofs[0] == 0 && ofs[1] == 0 && ofs[2] == 0 || this.field_145850_b.func_180495_p(next = next.func_177982_a(ofs[0], ofs[1], ofs[2])).func_177230_c() instanceof BlockFluidBase && (Integer)this.field_145850_b.func_180495_p(next).func_177229_b((IProperty)BlockFluidBase.LEVEL) == 0) break;
        }
        if (!next.equals((Object)tPos) && (s4 = this.field_145850_b.func_180495_p(next)).func_177230_c() instanceof BlockFluidClassic && (Integer)s4.func_177229_b((IProperty)BlockFluidBase.LEVEL) == 0 && this.inputT.fill(get, false) > 0) {
            flu.drain(this.field_145850_b, next, true);
            return this.inputT.fill(get, true);
        }
        return 0;
    }

    public boolean isInputSide(EnumFacing side) {
        return side != EnumFacing.DOWN && side != EnumFacing.UP;
    }

    public boolean isOutputSide(EnumFacing side) {
        return side == this.getBaseSide().func_176734_d();
    }

    public boolean canReceiveTorque(float amount, EnumFacing side) {
        if (this.currentTorque >= this.maxTorque()) {
            return false;
        }
        return this.isInputSide(side.func_176734_d());
    }

    public float receiveTorque(float amount, EnumFacing side, boolean sim) {
        float f = this.maxTorque() - this.currentTorque;
        float ret = Math.min(amount, f);
        if (!sim) {
            this.currentTorque += ret;
        }
        return ret;
    }

    public float maxTorque() {
        return 128.0f;
    }

    public float getGearTier() {
        return 16.0f;
    }

    public float maxSpeed() {
        return 360.0f;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.currentProgressTime = tag.func_74762_e("BurnTime");
        this.inputT = this.inputT.readFromNBT(tag, "Tank1");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("BurnTime", this.currentProgressTime);
        this.inputT.writeToNBT(tag, "Tank1");
        return tag;
    }

    public NBTTagCompound getNBT(NBTTagCompound tag) {
        super.getNBT(tag);
        tag.func_74768_a("BurnTime", this.currentProgressTime);
        this.inputT.writeToNBT(tag, "Tank1");
        return tag;
    }

    public void setNBT(NBTTagCompound tag) {
        super.setNBT(tag);
        this.currentProgressTime = tag.func_74762_e("BurnTime");
        this.inputT = this.inputT.readFromNBT(tag, "Tank1");
    }
}

