/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.machine.block;

import com.google.common.collect.Lists;
import defeatedcrow.hac.api.energy.ITorqueProvider;
import defeatedcrow.hac.api.energy.ITorqueReceiver;
import defeatedcrow.hac.core.energy.TileTorqueBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileWatermill
extends TileTorqueBase
implements ITorqueProvider {
    public void updateTile() {
        if (!this.field_145850_b.field_72995_K) {
            float flow = 0.0f;
            IBlockState state = this.field_145850_b.func_180495_p(this.getWaterCheckPos());
            if (state.func_177230_c() instanceof BlockLiquid) {
                BlockLiquid liq = (BlockLiquid)state.func_177230_c();
                IBlockState under = this.field_145850_b.func_180495_p(this.getWaterCheckPos().func_177977_b());
                IBlockState upper = this.field_145850_b.func_180495_p(this.getWaterCheckPos().func_177984_a());
                if ((under.func_185904_a().func_76230_c() || under.func_185904_a().func_76224_d()) && (upper.func_185904_a().func_76230_c() || upper.func_185904_a().func_76224_d())) {
                    flow = this.getGearTier();
                }
            } else if (state.func_177230_c() instanceof BlockFluidClassic) {
                BlockFluidClassic flu = (BlockFluidClassic)state.func_177230_c();
                if (BlockFluidClassic.getDensity((IBlockAccess)this.field_145850_b, (BlockPos)this.getWaterCheckPos()) > 0 && flu.isFlowingVertically((IBlockAccess)this.field_145850_b, this.getWaterCheckPos())) {
                    flow = this.getGearTier();
                }
            }
            if (flow == 0.0f) {
                IBlockState sec = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b());
                IBlockState sec2 = this.field_145850_b.func_180495_p(this.getWaterCheckPos().func_177977_b());
                if (sec.func_177230_c() instanceof BlockLiquid && sec2.func_177230_c() instanceof BlockLiquid) {
                    if ((Integer)sec.func_177229_b((IProperty)BlockLiquid.field_176367_b) > (Integer)sec2.func_177229_b((IProperty)BlockLiquid.field_176367_b)) {
                        float f = (15.0f - (float)((Integer)sec.func_177229_b((IProperty)BlockLiquid.field_176367_b)).intValue()) / 15.0f;
                        flow = this.getGearTier() * f;
                    }
                } else if (sec.func_177230_c() instanceof BlockFluidClassic && sec2.func_177230_c() instanceof BlockFluidClassic) {
                    BlockFluidClassic flu = (BlockFluidClassic)sec.func_177230_c();
                    if (BlockFluidClassic.getDensity((IBlockAccess)this.field_145850_b, (BlockPos)this.field_174879_c.func_177977_b()) > 0 && (Integer)sec.func_177229_b((IProperty)BlockFluidBase.LEVEL) > (Integer)sec2.func_177229_b((IProperty)BlockFluidBase.LEVEL)) {
                        float f = (15.0f - (float)((Integer)sec.func_177229_b((IProperty)BlockLiquid.field_176367_b)).intValue()) / 15.0f;
                        flow = this.getGearTier() * f;
                    }
                }
            }
            this.currentTorque = flow;
            for (EnumFacing side : this.getOutputSide()) {
                this.provideTorque(this.field_145850_b, this.func_174877_v().func_177972_a(side), side, false);
            }
        }
        super.updateTile();
    }

    public float maxTorque() {
        return 128.0f;
    }

    public float getGearTier() {
        return 16.0f;
    }

    public float maxSpeed() {
        return 360.0f;
    }

    public List<EnumFacing> getOutputSide() {
        ArrayList ret = Lists.newArrayList();
        ret.add(this.getBaseSide());
        return ret;
    }

    public float getAmount() {
        return this.getCurrentTorque();
    }

    public boolean canProvideTorque(World world, BlockPos outputPos, EnumFacing output) {
        TileEntity tile = world.func_175625_s(outputPos);
        float amo = this.getCurrentTorque();
        if (tile != null && tile instanceof ITorqueReceiver && amo > 0.0f) {
            return ((ITorqueReceiver)tile).canReceiveTorque(amo, output.func_176734_d());
        }
        return false;
    }

    public float provideTorque(World world, BlockPos outputPos, EnumFacing output, boolean sim) {
        float amo = this.getCurrentTorque();
        if (this.canProvideTorque(world, outputPos, output)) {
            ITorqueReceiver target = (ITorqueReceiver)world.func_175625_s(outputPos);
            float ret = target.receiveTorque(amo, output, sim);
            return ret;
        }
        return 0.0f;
    }

    public boolean isInputSide(EnumFacing side) {
        return side == this.getBaseSide().func_176734_d();
    }

    public boolean isOutputSide(EnumFacing side) {
        return side == this.getBaseSide();
    }

    public EnumFacing getWaterCheckSide() {
        EnumFacing side = this.getBaseSide().func_176732_a(EnumFacing.Axis.Y);
        return side;
    }

    public BlockPos getWaterCheckPos() {
        EnumFacing side = this.getBaseSide().func_176732_a(EnumFacing.Axis.Y);
        return this.field_174879_c.func_177972_a(side);
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 16384.0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB bb = INFINITE_EXTENT_AABB;
        bb = new AxisAlignedBB(this.func_174877_v().func_177982_a(-1, -1, -1), this.func_174877_v().func_177982_a(1, 1, 1));
        return bb;
    }
}

