/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.machine.block;

import com.google.common.collect.Lists;
import defeatedcrow.hac.api.climate.ClimateAPI;
import defeatedcrow.hac.api.climate.DCAirflow;
import defeatedcrow.hac.api.energy.ITorqueProvider;
import defeatedcrow.hac.api.energy.ITorqueReceiver;
import defeatedcrow.hac.core.energy.TileTorqueBase;
import defeatedcrow.hac.core.util.DCUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileWindmill
extends TileTorqueBase
implements ITorqueProvider {
    public void updateTile() {
        if (!this.field_145850_b.field_72995_K) {
            DCAirflow air = ClimateAPI.calculator.getAirflow(this.field_145850_b, this.field_174879_c);
            float wind = this.getGearTier() * 0.125f;
            switch (air) {
                case TIGHT: {
                    wind *= 0.0f;
                    break;
                }
                case NORMAL: {
                    wind *= 0.5f;
                    break;
                }
                case FLOW: {
                    wind *= 1.0f;
                    break;
                }
                case WIND: {
                    wind *= 2.0f;
                    break;
                }
            }
            if (this.getBaseSide() == DCUtil.getWorldWind((World)this.field_145850_b).func_176734_d()) {
                wind *= 2.0f;
            }
            this.currentTorque = wind;
            for (EnumFacing side : this.getOutputSide()) {
                this.provideTorque(this.field_145850_b, this.func_174877_v().func_177972_a(side), side, false);
            }
        }
        super.updateTile();
    }

    public float getGearTier() {
        return 8.0f;
    }

    public List<EnumFacing> getOutputSide() {
        ArrayList ret = Lists.newArrayList();
        ret.add(this.getBaseSide());
        return ret;
    }

    public float getAmount() {
        return this.getCurrentTorque();
    }

    public boolean canProvideTorque(World world, BlockPos outputPos, EnumFacing output) {
        TileEntity tile = world.func_175625_s(outputPos);
        float amo = this.getCurrentTorque();
        if (tile != null && tile instanceof ITorqueReceiver && amo > 0.0f) {
            return ((ITorqueReceiver)tile).canReceiveTorque(amo, output.func_176734_d());
        }
        return false;
    }

    public float provideTorque(World world, BlockPos outputPos, EnumFacing output, boolean sim) {
        float amo = this.getCurrentTorque();
        if (this.canProvideTorque(world, outputPos, output)) {
            ITorqueReceiver target = (ITorqueReceiver)world.func_175625_s(outputPos);
            float ret = target.receiveTorque(amo, output, sim);
            return ret;
        }
        return 0.0f;
    }

    public boolean isInputSide(EnumFacing side) {
        return side == this.getBaseSide().func_176734_d();
    }

    public boolean isOutputSide(EnumFacing side) {
        return this.getOutputSide().contains(side);
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 16384.0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB bb = INFINITE_EXTENT_AABB;
        bb = new AxisAlignedBB(this.func_174877_v().func_177982_a(-1, -1, -1), this.func_174877_v().func_177982_a(1, 1, 1));
        return bb;
    }
}

