/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.machine.block.tankyard;

import com.google.common.collect.Lists;
import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.api.climate.IClimate;
import defeatedcrow.hac.api.energy.IWrenchDC;
import defeatedcrow.hac.core.ClimateCore;
import defeatedcrow.hac.core.base.DCTileBlock;
import defeatedcrow.hac.core.fluid.DCFluidUtil;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.machine.MachineInit;
import defeatedcrow.hac.machine.block.tankyard.TileTankYard;
import defeatedcrow.hac.machine.block.tankyard.TileYardPart;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockYardPart
extends DCTileBlock {
    public BlockYardPart(String s) {
        super(Material.field_151571_B, s, 3);
        this.func_149752_b(120.0f);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileYardPart();
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return DCState.getInt((IBlockState)state, (PropertyInteger)DCState.TYPE4) <= 1;
    }

    public boolean onRightClick(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player != null) {
            ItemStack heldItem = player.func_184586_b(hand);
            if (hand == EnumHand.MAIN_HAND) {
                TileEntity tile = world.func_175625_s(pos);
                if (!world.field_72995_K && tile instanceof TileYardPart) {
                    TileEntity tile2;
                    TileYardPart part = (TileYardPart)tile;
                    if (heldItem.func_77973_b() instanceof ItemBlock) {
                        return false;
                    }
                    if (heldItem.func_77973_b() instanceof IWrenchDC) {
                        TileEntity tile22;
                        BlockPos core = this.getTankCore(world, pos, 128);
                        if (core != null && (tile22 = world.func_175625_s(core)) instanceof TileTankYard) {
                            ((TileTankYard)tile22).setRequest(true);
                        }
                    } else if (part.parent != null && world.func_175667_e(part.parent) && (tile2 = world.func_175625_s(part.parent)) instanceof TileTankYard) {
                        TileTankYard parent = (TileTankYard)tile2;
                        if (!DCUtil.isEmpty((ItemStack)heldItem)) {
                            if (DCFluidUtil.onActivateDCTank((TileEntity)parent, (ItemStack)heldItem, (World)world, (IBlockState)state, (EnumFacing)side, (EntityPlayer)player)) {
                                world.func_184133_a(null, pos, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.8f, 2.0f);
                            }
                        } else {
                            FluidStack f = parent.getTank().getFluid();
                            int lim = parent.getLimit();
                            if (f != null) {
                                String name = f.getLocalizedName();
                                int i = f.amount;
                                String mes1 = "Stored Fluid: " + name + " " + i + "/" + lim + "mB";
                                player.func_145747_a((ITextComponent)new TextComponentString(mes1));
                            } else {
                                String mes1 = "Stored Fluid: EMPTY 0/" + lim + "mB";
                                player.func_145747_a((ITextComponent)new TextComponentString(mes1));
                            }
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }

    public BlockPos getTankCore(World world, BlockPos pos, int limit) {
        while (!world.func_189509_E(pos.func_177977_b())) {
            if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == MachineInit.tankYard) {
                return pos.func_177977_b();
            }
            if (world.func_180495_p(pos.func_177977_b()).func_177230_c() != MachineInit.tankYardPart) break;
            pos = pos.func_177977_b();
        }
        ArrayList<Object> nextTargets = new ArrayList<Object>();
        BlockPos core = null;
        nextTargets.add(pos);
        LinkedHashSet<BlockPos> founds = new LinkedHashSet<BlockPos>();
        while (founds.size() <= limit && core == null) {
            ArrayList<BlockPos> facing = new ArrayList<BlockPos>();
            Iterator itr = nextTargets.iterator();
            while (itr.hasNext()) {
                BlockPos b1 = (BlockPos)itr.next();
                for (EnumFacing f : EnumFacing.field_176754_o) {
                    BlockPos b = b1.func_177972_a(f);
                    if (!world.func_175667_e(b)) continue;
                    if (world.func_180495_p(b).func_177230_c() == MachineInit.tankYard) {
                        core = b;
                        continue;
                    }
                    if (world.func_180495_p(b).func_177230_c() != MachineInit.tankYardPart || !founds.add(b)) continue;
                    facing.add(b);
                }
                itr.remove();
            }
            nextTargets.addAll(facing);
            facing.clear();
            if (!nextTargets.isEmpty()) continue;
            break;
        }
        return core;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile2;
        TileEntity tile = world.func_175625_s(pos);
        if (!world.field_72995_K && tile instanceof TileYardPart && ((TileYardPart)tile).parent != null && (tile2 = world.func_175625_s(((TileYardPart)tile).parent)) instanceof TileTankYard) {
            TileTankYard parent = (TileTankYard)tile2;
            if (parent.multi) {
                parent.multi = false;
                parent.setRequest(false);
            }
        }
        world.func_175713_t(pos);
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    public List<ItemStack> getSubItemList() {
        ArrayList list = Lists.newArrayList();
        list.add(new ItemStack((Block)this, 1, 0));
        return list;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
    }

    public boolean onClimateChange(World world, BlockPos pos, IBlockState state, IClimate clm) {
        return false;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        int meta = state.func_177230_c().func_176201_c(state);
        return meta > 1 ? 0 : 255;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        BlockPos check = pos.func_177972_a(side);
        IBlockState state2 = world.func_180495_p(check);
        if (state2 != null && state2.func_177230_c() == this && DCState.getInt((IBlockState)state, (PropertyInteger)DCState.TYPE4) == DCState.getInt((IBlockState)state2, (PropertyInteger)DCState.TYPE4)) {
            return false;
        }
        return super.func_176225_a(state, world, pos, side);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        if (ClimateCore.proxy.isShiftKeyDown()) {
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Tips ===");
            tooltip.add(I18n.func_135052_a((String)"dcs.tip.tankyard1", (Object[])new Object[0]));
            tooltip.add(I18n.func_135052_a((String)"dcs.tip.tankyard2", (Object[])new Object[0]));
        } else {
            tooltip.add(TextFormatting.ITALIC.toString() + "=== Press shift key: Tooltip expands ===");
        }
    }
}

