/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.machine.block.tankyard;

import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.core.DCLogger;
import defeatedcrow.hac.core.base.DCTileEntity;
import defeatedcrow.hac.core.base.ITagGetter;
import defeatedcrow.hac.core.fluid.DCTank;
import defeatedcrow.hac.machine.MachineInit;
import defeatedcrow.hac.machine.block.tankyard.TileYardPart;
import defeatedcrow.hac.main.packet.DCMainPacket;
import defeatedcrow.hac.main.packet.MessageSingleTank;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileTankYard
extends DCTileEntity
implements ITagGetter {
    private int limit = 200000;
    private DCTank inT;
    private boolean updateRequest = false;
    private boolean forcedUpdate = false;
    private boolean lastMulti;
    private int lastInT = 0;
    private int lastSize = 0;
    private int count = 20;
    public int width = 1;
    public int height = 1;
    public boolean multi;

    public void setRequest(boolean force) {
        this.updateRequest = true;
        this.forcedUpdate = force;
    }

    public void setTankYard(int w, int h) {
        this.width = w;
        this.height = h;
        int i = w * w * h;
        if (i > 5000) {
            i = 5000;
        }
        this.limit = 200000 * i;
        FluidStack fluid = null;
        if (!this.inT.isEmpty()) {
            fluid = this.inT.getFluid().copy();
        }
        this.inT = new DCTank(this.limit).setFluid(fluid);
        DCLogger.debugInfoLog((String)("Created new tank! w:" + w + " h:" + h + " limit:" + this.limit));
    }

    public boolean startYard() {
        int w = 0;
        int h = 0;
        if (!this.forcedUpdate && this.width > 0 && this.height > 1) {
            w = (this.width - 1) / 2;
            h = this.height - 1;
        } else {
            while (this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(w + 1, 0, w + 1)).func_177230_c() == MachineInit.tankYardPart) {
                ++w;
            }
            while (this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(w, h + 1, w)).func_177230_c() == MachineInit.tankYardPart) {
                ++h;
            }
        }
        DCLogger.debugInfoLog((String)("width:" + w + " height:" + h));
        if (w == 0 && h == 0) {
            this.setTankYard(1, 1);
            return true;
        }
        for (BlockPos p : BlockPos.MutableBlockPos.func_177980_a((BlockPos)new BlockPos((Vec3i)this.field_174879_c.func_177982_a(-w, 0, -w)), (BlockPos)new BlockPos((Vec3i)this.field_174879_c.func_177982_a(w, h, w)))) {
            if (!this.field_145850_b.func_175667_e(p) || p.equals((Object)this.field_174879_c) || !(p.func_177958_n() == this.field_174879_c.func_177958_n() - w || p.func_177958_n() == this.field_174879_c.func_177958_n() + w || p.func_177952_p() == this.field_174879_c.func_177952_p() - w || p.func_177952_p() == this.field_174879_c.func_177952_p() + w || p.func_177956_o() == this.field_174879_c.func_177956_o() || p.func_177956_o() == this.field_174879_c.func_177956_o() + h ? this.field_145850_b.func_180495_p(p).func_177230_c() != MachineInit.tankYardPart : !this.field_145850_b.func_175623_d(p))) continue;
            return false;
        }
        this.forcedUpdate = false;
        this.setTankYard(w * 2 + 1, h + 1);
        return true;
    }

    public void updateTankYard(boolean flag) {
        if (this.width > 0 && this.height > 1) {
            int w = (this.width - 1) / 2;
            int h = this.height - 1;
            for (BlockPos p : BlockPos.MutableBlockPos.func_177980_a((BlockPos)new BlockPos((Vec3i)this.field_174879_c.func_177982_a(-w, 0, -w)), (BlockPos)new BlockPos((Vec3i)this.field_174879_c.func_177982_a(w, h, w)))) {
                IBlockState state;
                if (!this.field_145850_b.func_175667_e(p) || p.equals((Object)this.field_174879_c)) continue;
                TileEntity te = this.field_145850_b.func_175625_s(p);
                IBlockState next = state = this.field_145850_b.func_180495_p(p);
                if (!(te instanceof TileYardPart) || state.func_177230_c() != MachineInit.tankYardPart) continue;
                if (flag) {
                    ((TileYardPart)te).parent = this.field_174879_c;
                    boolean i = true;
                    if (this.width >= 3 && this.height >= 2) {
                        if (p.func_177958_n() == this.field_174879_c.func_177958_n() - w && p.func_177952_p() == this.field_174879_c.func_177952_p() - w) {
                            next = state.func_177226_a((IProperty)DCState.FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)DCState.TYPE4, (Comparable)Integer.valueOf(2));
                        } else if (p.func_177958_n() == this.field_174879_c.func_177958_n() + w && p.func_177952_p() == this.field_174879_c.func_177952_p() + w) {
                            next = state.func_177226_a((IProperty)DCState.FACING, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)DCState.TYPE4, (Comparable)Integer.valueOf(2));
                        } else if (p.func_177958_n() == this.field_174879_c.func_177958_n() - w && p.func_177952_p() == this.field_174879_c.func_177952_p() + w) {
                            next = state.func_177226_a((IProperty)DCState.FACING, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)DCState.TYPE4, (Comparable)Integer.valueOf(2));
                        } else if (p.func_177958_n() == this.field_174879_c.func_177958_n() + w && p.func_177952_p() == this.field_174879_c.func_177952_p() - w) {
                            next = state.func_177226_a((IProperty)DCState.FACING, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)DCState.TYPE4, (Comparable)Integer.valueOf(2));
                        } else if (p.func_177956_o() > this.field_174879_c.func_177956_o() && p.func_177956_o() < this.field_174879_c.func_177956_o() + h && (p.func_177958_n() == this.field_174879_c.func_177958_n() || p.func_177952_p() == this.field_174879_c.func_177952_p())) {
                            next = state.func_177226_a((IProperty)DCState.TYPE4, (Comparable)Integer.valueOf(3));
                        }
                    }
                    this.field_145850_b.func_180501_a(p, next, 3);
                    this.field_145850_b.func_175685_c(this.field_174879_c, state.func_177230_c(), true);
                    continue;
                }
                ((TileYardPart)te).parent = null;
                next = state.func_177226_a((IProperty)DCState.TYPE4, (Comparable)Integer.valueOf(0));
                this.field_145850_b.func_180501_a(p, next, 3);
                this.field_145850_b.func_175685_c(this.field_174879_c, state.func_177230_c(), true);
            }
        }
    }

    public int getLimit() {
        return this.limit;
    }

    public DCTank getTank() {
        if (this.inT == null) {
            this.inT = new DCTank(this.limit);
        }
        return this.inT;
    }

    protected void onServerUpdate() {
        if (this.updateRequest) {
            DCLogger.debugInfoLog((String)"start checking");
            this.multi = this.startYard();
            DCLogger.debugInfoLog((String)("checking: " + this.multi));
            this.updateRequest = false;
            return;
        }
        int size = this.width + this.height;
        if (this.multi != this.lastMulti || size != this.lastSize) {
            this.updateTankYard(this.multi);
            if (!this.func_145830_o()) {
                return;
            }
            List list = this.func_145831_w().field_73010_i;
            for (EntityPlayer player : list) {
                if (!(player instanceof EntityPlayerMP)) continue;
                ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)this.func_189518_D_());
            }
            this.lastMulti = this.multi;
            this.lastSize = size;
            return;
        }
        if (this.count > 0) {
            --this.count;
        } else {
            boolean flag = false;
            if (this.getTank().getFluidAmount() != this.lastInT) {
                flag = true;
                this.lastInT = this.getTank().getFluidAmount();
            }
            if (flag) {
                String name = this.getTank().isEmpty() ? "empty" : this.getTank().getFluidType().getName();
                DCMainPacket.INSTANCE.sendToAll((IMessage)new MessageSingleTank(this.field_174879_c, name, this.getTank().getFluidAmount()));
            }
            this.count = 20;
        }
    }

    public void updateTile() {
        if (this.field_145850_b.field_72995_K && this.inT.getCapacity() < this.limit) {
            FluidStack fluid = null;
            if (!this.inT.isEmpty()) {
                fluid = this.inT.getFluid().copy();
            }
            this.inT = new DCTank(this.limit).setFluid(fluid);
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.getTank();
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.func_145836_u();
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.setNBT(tag);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.getNBT(tag);
        return tag;
    }

    public NBTTagCompound getNBT(NBTTagCompound tag) {
        super.getNBT(tag);
        tag.func_74768_a("width", this.width);
        tag.func_74768_a("height", this.height);
        tag.func_74757_a("multi", this.multi);
        tag.func_74768_a("limit", this.limit);
        this.getTank().writeToNBT(tag, "Tank");
        return tag;
    }

    public void setNBT(NBTTagCompound tag) {
        super.setNBT(tag);
        this.width = tag.func_74762_e("width");
        this.height = tag.func_74762_e("height");
        this.multi = tag.func_74767_n("multi");
        this.limit = tag.func_74762_e("limit");
        this.inT = this.getTank().readFromNBT(tag, "Tank");
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        this.func_189515_b(nbtTagCompound);
        return new SPacketUpdateTileEntity(this.field_174879_c, -50, nbtTagCompound);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }
}

