/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.machine.entity;

import defeatedcrow.hac.core.base.DCInventory;
import defeatedcrow.hac.core.fluid.DCTank;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.machine.MachineInit;
import defeatedcrow.hac.main.ClimateMain;
import defeatedcrow.hac.main.api.MainAPIManager;
import defeatedcrow.hac.main.packet.DCMainPacket;
import defeatedcrow.hac.main.packet.MessageEntityTank;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class EntityScooter
extends Entity
implements IInventory {
    protected static final DataParameter<Boolean> POWERED = EntityDataManager.func_187226_a(EntityScooter.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(EntityScooter.class, (DataSerializer)DataSerializers.field_187192_b);
    public float headYaw;
    public float prevHeadYaw;
    protected int lerpSteps;
    protected double lastX;
    protected double lastY;
    protected double lastZ;
    protected double lastYaw;
    protected double lastRot;
    public double lastMoveY;
    protected int lastInT;
    public boolean brake;
    public Status status = Status.IN_AIR;
    protected Status prevStatus = Status.IN_AIR;
    public final DCInventory tankSlot = new DCInventory(3);
    public final InventoryBasic inv = new InventoryBasic("Items", false, 18);
    public final DCTank tank = new DCTank(5000);
    protected int currentBurnTime = 0;
    protected int maxBurnTime = 1;
    protected int cooltime = 20;
    IItemHandler handler = new InvWrapper((IInventory)this.inv);

    public EntityScooter(World worldIn) {
        super(worldIn);
        this.field_70156_m = true;
        this.func_70105_a(1.5f, 1.0f);
        this.field_70138_W = 1.25f;
        this.func_70299_a(2, new ItemStack(Items.field_151133_ar));
    }

    public EntityScooter(World worldIn, double x, double y, double z) {
        this(worldIn);
        this.func_70107_b(x, y, z);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    public EntityScooter(World worldIn, double posX, double posY, double posZ, @Nullable EntityPlayer player) {
        this(worldIn, posX, posY, posZ);
        if (player != null) {
            this.field_70177_z = player.field_70177_z;
        }
    }

    public double func_70042_X() {
        return 0.6;
    }

    public void func_70071_h_() {
        boolean flag;
        this.prevStatus = this.status;
        this.status = this.getStatus();
        this.prevHeadYaw = this.headYaw;
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.lastMoveY = this.field_70181_x;
        super.func_70071_h_();
        this.tickLerp();
        this.updatePowered();
        EntityPlayer rider = null;
        boolean stop = false;
        if (!this.func_184188_bt().isEmpty() && this.func_184188_bt().get(0) instanceof EntityPlayer) {
            rider = (EntityPlayer)this.func_184188_bt().get(0);
        }
        if (this.brake || rider == null) {
            stop = true;
        }
        if (rider == null) {
            if (!this.func_184188_bt().isEmpty()) {
                ((Entity)this.func_184188_bt().get(0)).func_184210_p();
            }
            if (this.func_184188_bt().size() > 1) {
                ((Entity)this.func_184188_bt().get(1)).func_184210_p();
            }
        }
        this.updateYaw(rider);
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        while (this.headYaw - this.prevHeadYaw < -180.0f) {
            this.prevHeadYaw -= 360.0f;
        }
        while (this.headYaw - this.prevHeadYaw >= 180.0f) {
            this.prevHeadYaw += 360.0f;
        }
        this.updateFalling(rider);
        if (!this.field_70170_p.field_72995_K) {
            this.updateSpeed(rider, stop);
            if (stop) {
                this.field_70159_w *= 0.5;
                this.field_70179_y *= 0.5;
            } else {
                this.field_70159_w *= 0.99;
                this.field_70179_y *= 0.99;
            }
            float speed = (float)Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
            if ((double)speed < 0.01) {
                this.field_70159_w = 0.0;
                this.field_70179_y = 0.0;
            }
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.func_145775_I();
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72321_a(0.2, 0.5, 0.2), EntitySelectors.field_152785_b);
        if (!list.isEmpty()) {
            flag = !this.field_70170_p.field_72995_K && !(this.func_184179_bs() instanceof EntityPlayer);
            for (int j = 0; j < list.size(); ++j) {
                Entity entity = (Entity)list.get(j);
                if (entity == null || entity.field_70170_p.field_72995_K || entity.func_184196_w((Entity)this) || !(entity instanceof EntityLivingBase)) continue;
                if (rider != null && this.func_184188_bt().size() < 2) {
                    entity.func_184220_m((Entity)this);
                    continue;
                }
                this.func_70108_f(entity);
            }
        }
        if (this.status == Status.IN_TILE) {
            this.func_70107_b(this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v);
        }
        if (this.field_70170_p.field_72995_K) {
            this.addParticle();
        } else {
            flag = false;
            if (this.tank.getFluidAmount() + this.tank.getFluidIdName().hashCode() != this.lastInT) {
                flag = true;
                this.lastInT = this.tank.getFluidAmount() + this.tank.getFluidIdName().hashCode();
            }
            if (flag) {
                String f1 = this.tank.getFluidType() == null ? "empty" : this.tank.getFluidType().getName();
                int a1 = this.tank.getFluidAmount();
                DCMainPacket.INSTANCE.sendToAll((IMessage)new MessageEntityTank(this.func_145782_y(), f1, a1));
            }
        }
    }

    protected void addParticle() {
        if (this.getPowered()) {
            int c = ClimateMain.proxy.getParticleCount();
            if (ClimateMain.proxy.getParticleCount() > 0 && this.field_70146_Z.nextInt(c) == 0) {
                double px = this.field_70165_t - Math.sin(-this.field_70177_z * ((float)Math.PI / 180)) * 0.75 - Math.cos(this.field_70177_z * ((float)Math.PI / 180)) * 0.25;
                double pz = this.field_70161_v - Math.cos(this.field_70177_z * ((float)Math.PI / 180)) * 0.75 - Math.sin(this.field_70177_z * ((float)Math.PI / 180)) * 0.25;
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, px, this.field_70163_u + 0.25, pz, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public int getBurnTime(Fluid fluid) {
        int burn = MainAPIManager.fuelRegister.getBurningTime(fluid);
        return burn;
    }

    public void updateFalling(EntityPlayer rider) {
        this.field_70143_R = 0.0f;
        if (rider != null) {
            rider.field_70143_R = 0.0f;
        }
        this.field_70181_x = this.status == Status.ON_TILE ? (this.field_70181_x += 0.1) : (this.status == Status.UNDER_WATER ? (this.field_70181_x -= 0.02) : (this.field_70122_E ? (this.field_70181_x *= 0.5) : (this.field_70181_x -= 0.05)));
    }

    protected void updateSpeed(EntityPlayer rider, boolean brake) {
        float yaw = this.field_70177_z * ((float)Math.PI / 180);
        if (rider != null && !brake && rider.field_191988_bg > 0.0f) {
            double d1 = -Math.sin(yaw);
            double d2 = Math.cos(yaw);
            double d9 = this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y;
            double d10 = Math.sqrt(d9);
            this.field_70159_w += d1 * 0.2;
            this.field_70179_y += d2 * 0.2;
            if (d10 > (double)this.getMaxSpeed()) {
                this.field_70159_w = d1 * (double)this.getMaxSpeed();
                this.field_70179_y = d2 * (double)this.getMaxSpeed();
            }
            rider.field_191988_bg = 0.0f;
        } else {
            this.field_70159_w *= 0.5;
            this.field_70179_y *= 0.5;
        }
        if (this.status == Status.UNDER_WATER) {
            this.field_70159_w *= 0.75;
            this.field_70179_y *= 0.75;
        }
    }

    protected void updateYaw(EntityPlayer rider) {
        if (rider == null) {
            return;
        }
        float f1 = this.field_70177_z;
        double d3 = MathHelper.func_76138_g((double)((double)rider.field_70177_z - (double)this.field_70177_z));
        this.field_70177_z = (float)((double)this.field_70177_z + d3 / 2.0);
        this.headYaw = this.field_70177_z - f1 > 5.0f ? 45.0f : (this.field_70177_z - f1 < -5.0f ? -45.0f : 0.0f);
    }

    protected boolean updatePowered() {
        if (!this.field_70170_p.field_72995_K && this.cooltime <= 0) {
            int i;
            FluidStack f;
            this.cooltime = 20;
            this.processTank();
            if (this.currentBurnTime > 0 && !this.func_184188_bt().isEmpty()) {
                --this.currentBurnTime;
            }
            if (this.currentBurnTime == 0 && (f = this.tank.getFluid()) != null && f.getFluid() != null && this.tank.getFluidAmount() > 0 && (i = this.getBurnTime(f.getFluid())) > 0) {
                this.currentBurnTime = i;
                this.maxBurnTime = i;
                this.tank.drain(1, true);
                this.func_70296_d();
            }
            if (this.currentBurnTime > 0 && !this.getPowered()) {
                this.setPowered(true);
            } else if (this.currentBurnTime == 0 && this.getPowered()) {
                this.setPowered(false);
            }
            boolean flag = false;
            if (this.tank.getFluidAmount() + this.tank.getFluidIdName().hashCode() != this.lastInT) {
                flag = true;
                this.lastInT = this.tank.getFluidAmount() + this.tank.getFluidIdName().hashCode();
            }
            if (flag) {
                String f1 = this.tank.getFluidType() == null ? "empty" : this.tank.getFluidType().getName();
                int a1 = this.tank.getFluidAmount();
                DCMainPacket.INSTANCE.sendToAll((IMessage)new MessageEntityTank(this.func_145782_y(), f1, a1));
            }
        } else {
            --this.cooltime;
        }
        return this.getPowered();
    }

    protected void setBucketTag() {
        NBTTagCompound tag;
        ItemStack bu = this.func_70301_a(2);
        if (DCUtil.isEmpty((ItemStack)bu)) {
            this.func_70299_a(2, new ItemStack(Items.field_151133_ar));
        }
        if ((tag = bu.func_77978_p()) == null) {
            tag = new NBTTagCompound();
        }
        if (!this.tank.isEmpty()) {
            tag = this.tank.getFluid().writeToNBT(tag);
        } else {
            tag.func_74778_a("FluidName", "NONE");
            tag.func_74768_a("Amount", 0);
        }
        bu.func_77982_d(tag);
        this.func_70299_a(2, bu);
        this.func_70296_d();
    }

    public FluidStack getBucketTag() {
        ItemStack bu = this.func_70301_a(2);
        if (!DCUtil.isEmpty((ItemStack)bu)) {
            NBTTagCompound tag = bu.func_77978_p();
            if (tag != null) {
                tag = new NBTTagCompound();
            }
            FluidStack f = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag);
            return f;
        }
        return null;
    }

    protected Status getStatus() {
        return this.getUnderGround();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Status getUnderGround() {
        AxisAlignedBB aabb = this.func_174813_aQ();
        int i = MathHelper.func_76128_c((double)aabb.field_72340_a);
        int j = MathHelper.func_76143_f((double)aabb.field_72336_d);
        int k = MathHelper.func_76128_c((double)aabb.field_72338_b);
        int l = MathHelper.func_76143_f((double)(aabb.field_72338_b + 0.001));
        int i1 = MathHelper.func_76128_c((double)aabb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)aabb.field_72334_f);
        boolean flag = false;
        boolean flag2 = false;
        BlockPos.PooledMutableBlockPos mpos = BlockPos.PooledMutableBlockPos.func_185346_s();
        try {
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = k; l1 < l; ++l1) {
                    for (int i2 = i1; i2 < j1; ++i2) {
                        double d;
                        mpos.func_181079_c(k1, l1, i2);
                        IBlockState state = this.field_70170_p.func_180495_p((BlockPos)mpos);
                        if (state.func_185904_a() == Material.field_151586_h && state.func_185900_c((IBlockAccess)this.field_70170_p, (BlockPos)mpos) != null) {
                            d = state.func_185900_c((IBlockAccess)this.field_70170_p, (BlockPos)mpos).field_72337_e + (double)mpos.func_177956_o();
                            if (!(this.field_70163_u < d)) continue;
                            flag2 = true;
                            continue;
                        }
                        if (state.func_185890_d((IBlockAccess)this.field_70170_p, (BlockPos)mpos) == null || !(this.field_70163_u < (d = state.func_185890_d((IBlockAccess)this.field_70170_p, (BlockPos)mpos).field_72337_e + (double)mpos.func_177956_o()))) continue;
                        flag = true;
                    }
                }
            }
        }
        finally {
            mpos.func_185344_t();
        }
        return flag ? Status.ON_TILE : (flag2 ? Status.UNDER_WATER : Status.IN_AIR);
    }

    protected void tickLerp() {
        if (this.lerpSteps > 0 && !this.func_184186_bw()) {
            double d0 = this.field_70165_t + (this.lastX - this.field_70165_t);
            double d1 = this.field_70163_u + (this.lastY - this.field_70163_u);
            double d2 = this.field_70161_v + (this.lastZ - this.field_70161_v);
            double d3 = MathHelper.func_76138_g((double)(this.lastYaw - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + d3);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.lastRot - (double)this.field_70125_A));
            this.func_70107_b(d0, d1, d2);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.lastX = x;
        this.lastY = y;
        this.lastZ = z;
        this.lastYaw = yaw;
        this.lastRot = pitch;
        this.lerpSteps = 5;
    }

    @Nullable
    public Entity func_184179_bs() {
        List list = this.func_184188_bt();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    public boolean func_184230_a(EntityPlayer player, @Nullable EnumHand hand) {
        if (player.func_70093_af()) {
            int id = this.func_145782_y();
            player.openGui((Object)ClimateMain.instance, id, this.field_70170_p, this.func_180425_c().func_177958_n(), this.func_180425_c().func_177956_o(), this.func_180425_c().func_177952_p());
            return true;
        }
        if (this.func_184207_aI() && this.func_184188_bt().size() < 2) {
            return true;
        }
        if (!this.field_70170_p.field_72995_K) {
            player.func_184220_m((Entity)this);
        }
        return true;
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger) && passenger != this.func_184179_bs()) {
            float f = 0.0f;
            float f1 = (float)((this.field_70128_L ? 0.01 : this.func_70042_X()) + passenger.func_70033_W());
            if (this.func_184188_bt().size() > 1) {
                int i = this.func_184188_bt().indexOf(passenger);
                f = i == 0 ? 0.2f : -0.6f;
                if (passenger instanceof EntityAnimal) {
                    f = (float)((double)f + 0.2);
                }
            }
            Vec3d vec3d = new Vec3d((double)f, 0.0, 0.0).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
            passenger.func_70107_b(this.field_70165_t + vec3d.field_72450_a, this.field_70163_u + (double)f1, this.field_70161_v + vec3d.field_72449_c);
            passenger.field_70177_z = this.field_70177_z;
            passenger.func_70034_d(this.field_70177_z);
            this.applyYawToEntity(passenger);
        } else {
            super.func_184232_k(passenger);
        }
    }

    protected void applyYawToEntity(Entity entityToUpdate) {
        entityToUpdate.func_181013_g(this.field_70177_z);
        float f = MathHelper.func_76142_g((float)(entityToUpdate.field_70177_z - this.field_70177_z));
        float f1 = MathHelper.func_76131_a((float)f, (float)-105.0f, (float)105.0f);
        entityToUpdate.field_70126_B += f1 - f;
        entityToUpdate.field_70177_z += f1 - f;
        entityToUpdate.func_70034_d(entityToUpdate.field_70177_z);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_184190_l(Entity entityToUpdate) {
        this.applyYawToEntity(entityToUpdate);
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() < 2;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!(this.field_70170_p.field_72995_K || this.field_70128_L || this.func_184179_bs() instanceof EntityPlayer)) {
            if (this.func_180431_b(source)) {
                this.func_70106_y();
            } else if (source instanceof EntityDamageSource && !source.func_76352_a() && ((EntityDamageSource)source).func_76346_g() instanceof EntityPlayer) {
                int m = this.getColorID();
                ItemStack itemstack = new ItemStack(MachineInit.scooter, 1, m);
                NBTTagCompound tag = new NBTTagCompound();
                this.getNBTFromEntity(tag);
                itemstack.func_77982_d(tag);
                this.func_70099_a(itemstack, 0.0f);
                this.func_70106_y();
            }
        }
        return false;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(COLOR, (Object)0);
        this.field_70180_af.func_187214_a(POWERED, (Object)false);
    }

    protected void func_70037_a(NBTTagCompound tag) {
        int c = tag.func_74762_e("dcs.color");
        this.setColor(c);
        this.currentBurnTime = tag.func_74762_e("BurnTime");
        this.maxBurnTime = tag.func_74762_e("MaxTime");
        NBTTagList nbttaglist = tag.func_150295_c("InvItems", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.func_70302_i_()) continue;
            this.func_70299_a(b0, new ItemStack(nbttagcompound1));
        }
        this.tank.readFromNBT(tag, "Tank");
    }

    protected void func_70014_b(NBTTagCompound tag) {
        tag.func_74768_a("dcs.color", this.getColorID());
        tag.func_74768_a("BurnTime", this.currentBurnTime);
        tag.func_74768_a("MaxTime", this.maxBurnTime);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.func_70301_a(i).func_77955_b(nbttagcompound1);
            list.func_74742_a((NBTBase)nbttagcompound1);
        }
        tag.func_74782_a("InvItems", (NBTBase)list);
        this.tank.writeToNBT(tag, "Tank");
    }

    public void getNBTFromEntity(NBTTagCompound tag) {
        this.func_70014_b(tag);
    }

    public void setNBTToEntity(NBTTagCompound tag) {
        this.func_70037_a(tag);
    }

    public void setPowered(boolean b) {
        this.field_70180_af.func_187227_b(POWERED, (Object)b);
    }

    public boolean getPowered() {
        return (Boolean)this.field_70180_af.func_187225_a(POWERED);
    }

    protected boolean func_70041_e_() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    protected float getMaxSpeed() {
        return this.getPowered() ? 1.8f : 0.4f;
    }

    public int getColorID() {
        return (Integer)this.field_70180_af.func_187225_a(COLOR);
    }

    public void setColor(int i) {
        this.field_70180_af.func_187227_b(COLOR, (Object)i);
    }

    public InventoryBasic getInventory() {
        return this.inv;
    }

    public DCTank getFuelTank() {
        return this.tank;
    }

    public boolean isActive() {
        return this.currentBurnTime > 0;
    }

    public int getCurrentBurnTime() {
        return this.currentBurnTime;
    }

    public int getMaxBurnTime() {
        return this.maxBurnTime;
    }

    public void setCurrentBurnTime(int i) {
        this.currentBurnTime = i;
    }

    public void setMaxBurnTime(int i) {
        this.maxBurnTime = i;
    }

    protected void processTank() {
        if (!this.onDrainTank(this.tank, 0, 1)) {
            this.onFillTank(this.tank, 0, 1);
        }
    }

    protected boolean onFillTank(DCTank tank, int slot1, int slot2) {
        block9: {
            ItemStack ret;
            boolean loose;
            block10: {
                FluidStack fill;
                block11: {
                    ItemStack in = this.func_70301_a(slot1);
                    ItemStack out = this.func_70301_a(slot2);
                    if (DCUtil.isEmpty((ItemStack)in)) {
                        return false;
                    }
                    IFluidHandlerItem dummy = null;
                    ItemStack in2 = in.func_77946_l();
                    if (in2.func_190916_E() > 1) {
                        in2.func_190920_e(1);
                    }
                    if (in.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
                        dummy = (IFluidHandlerItem)in2.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                    } else if (in.func_77973_b() instanceof IFluidHandler) {
                        dummy = (IFluidHandlerItem)in2.func_77973_b();
                    }
                    if (dummy == null || dummy.getTankProperties() == null || dummy.getTankProperties().length <= 0) break block9;
                    loose = false;
                    ret = ItemStack.field_190927_a;
                    int max = dummy.getTankProperties()[0].getCapacity();
                    FluidStack fc = dummy.drain(max, false);
                    if (fc == null || fc.amount <= 0 || !tank.canFillTarget(fc)) break block10;
                    ret = ItemStack.field_190927_a;
                    loose = false;
                    boolean b = false;
                    int rem = tank.getCapacity() - tank.getFluidAmount();
                    fc = dummy.drain(rem, false);
                    if (fc == null || fc.amount > rem) break block10;
                    fill = null;
                    fill = dummy.drain(rem, true);
                    ret = dummy.getContainer();
                    if (fill == null) break block10;
                    if (DCUtil.isEmpty((ItemStack)ret)) break block11;
                    if (EntityScooter.isItemStackable(ret, this.func_70301_a(slot2)) <= 0) break block10;
                }
                loose = true;
                tank.fill(fill, true);
            }
            if (loose) {
                this.func_70298_a(slot1, 1);
                this.incrStackInSlot(slot2, ret);
                this.func_70296_d();
                return true;
            }
        }
        return false;
    }

    protected boolean onDrainTank(DCTank tank, int slot1, int slot2) {
        block12: {
            ItemStack ret;
            boolean loose;
            block13: {
                int fill;
                block14: {
                    ItemStack in = this.func_70301_a(slot1);
                    ItemStack out = this.func_70301_a(slot2);
                    if (DCUtil.isEmpty((ItemStack)in)) {
                        return false;
                    }
                    IFluidHandlerItem dummy = null;
                    ItemStack in2 = in.func_77946_l();
                    if (in2.func_190916_E() > 1) {
                        in2.func_190920_e(1);
                    }
                    if (in.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
                        dummy = (IFluidHandlerItem)in2.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                    } else if (in.func_77973_b() instanceof IFluidHandler) {
                        dummy = (IFluidHandlerItem)in2.func_77973_b();
                    }
                    if (tank.getFluidAmount() <= 0 || dummy == null || dummy.getTankProperties() == null || dummy.getTankProperties().length <= 0) break block12;
                    loose = false;
                    ret = ItemStack.field_190927_a;
                    int max = dummy.getTankProperties()[0].getCapacity();
                    FluidStack fc = dummy.drain(max, false);
                    boolean b = false;
                    int rem = max;
                    if (fc == null || fc.amount == 0) {
                        b = true;
                    } else {
                        rem = max - fc.amount;
                        if (tank.getFluidAmount() <= rem) {
                            b = true;
                        }
                    }
                    if (!b) break block13;
                    FluidStack drain = tank.drain(rem, false);
                    fill = 0;
                    fill = dummy.fill(drain, true);
                    ret = dummy.getContainer();
                    if (fill <= 0) break block13;
                    if (DCUtil.isEmpty((ItemStack)ret)) break block14;
                    if (EntityScooter.isItemStackable(ret, this.func_70301_a(slot2)) <= 0) break block13;
                }
                loose = true;
                tank.drain(fill, true);
            }
            if (loose) {
                this.func_70298_a(slot1, 1);
                this.incrStackInSlot(slot2, ret);
                this.func_70296_d();
                return true;
            }
        }
        return false;
    }

    public static int isItemStackable(ItemStack target, ItemStack current) {
        if (DCUtil.isEmpty((ItemStack)target)) {
            return 0;
        }
        if (DCUtil.isEmpty((ItemStack)current)) {
            return target.func_190916_E();
        }
        if (target.func_77973_b() == current.func_77973_b() && target.func_77960_j() == current.func_77960_j() && ItemStack.func_77970_a((ItemStack)target, (ItemStack)current)) {
            int i = current.func_190916_E() + target.func_190916_E();
            if (i > current.func_77976_d()) {
                i = current.func_77976_d() - current.func_190916_E();
                return i;
            }
            return target.func_190916_E();
        }
        return 0;
    }

    public void incrStackInSlot(int i, ItemStack input) {
        if (i < this.func_70302_i_() && !DCUtil.isEmpty((ItemStack)input)) {
            if (!DCUtil.isEmpty((ItemStack)this.func_70301_a(i))) {
                if (this.func_70301_a(i).func_77973_b() == input.func_77973_b() && this.func_70301_a(i).func_77960_j() == input.func_77960_j() && ItemStack.func_77970_a((ItemStack)this.func_70301_a(i), (ItemStack)input)) {
                    DCUtil.addStackSize((ItemStack)this.func_70301_a(i), (int)input.func_190916_E());
                    if (this.func_70301_a(i).func_190916_E() > this.func_70297_j_()) {
                        this.func_70301_a(i).func_190920_e(this.func_70297_j_());
                    }
                }
            } else {
                this.func_70299_a(i, input);
            }
        }
    }

    public int func_70302_i_() {
        return this.inv.func_70302_i_() + this.tankSlot.func_70302_i_();
    }

    public ItemStack func_70301_a(int index) {
        if (index < 3) {
            return this.tankSlot.func_70301_a(index);
        }
        return this.inv.func_70301_a(index - 3);
    }

    public ItemStack func_70298_a(int index, int count) {
        if (index < 3) {
            return this.tankSlot.func_70298_a(index, count);
        }
        return this.inv.func_70298_a(index - 3, count);
    }

    public ItemStack func_70304_b(int index) {
        if (index < 3) {
            return this.tankSlot.func_70304_b(index);
        }
        return this.inv.func_70304_b(index - 3);
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (index < 3) {
            this.tankSlot.func_70299_a(index, stack);
        } else {
            this.inv.func_70299_a(index - 3, stack);
        }
    }

    public int func_70297_j_() {
        return this.inv.func_70297_j_();
    }

    public void func_70296_d() {
        this.inv.func_70296_d();
        this.tankSlot.func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.inv.func_70300_a(player);
    }

    public void func_174889_b(EntityPlayer player) {
        this.inv.func_174889_b(player);
    }

    public void func_174886_c(EntityPlayer player) {
        this.inv.func_174886_c(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index < 3) {
            return !DCUtil.isEmpty((ItemStack)stack) && stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
        }
        return this.inv.func_94041_b(index - 3, stack);
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.currentBurnTime;
            }
            case 1: {
                return this.maxBurnTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.currentBurnTime = value;
                break;
            }
            case 1: {
                this.maxBurnTime = value;
                break;
            }
            default: {
                return;
            }
        }
    }

    public int func_174890_g() {
        return 2;
    }

    public void func_174888_l() {
        this.inv.func_174888_l();
        this.tankSlot.func_174888_l();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tank;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.handler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean func_191420_l() {
        return this.inv.func_191420_l() && this.tankSlot.func_191420_l();
    }

    public static enum Status {
        IN_TILE,
        UNDER_WATER,
        IN_AIR,
        ON_TILE;

    }
}

