/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.machine.gui;

import defeatedcrow.hac.core.client.base.GuiBaseDC;
import defeatedcrow.hac.machine.block.TilePortalManager;
import defeatedcrow.hac.machine.gui.ContainerPortalManager;
import java.util.ArrayList;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiPortalManager
extends GuiBaseDC {
    private static final ResourceLocation TEXTURE = new ResourceLocation("dcs_climate", "textures/gui/portal_manager_gui.png");
    private static final ResourceLocation iconTex = new ResourceLocation("dcs_climate", "textures/gui/gui_icons.png");
    private final TilePortalManager tile;
    private final InventoryPlayer playerInventory;

    public GuiPortalManager(TilePortalManager inv, EntityPlayer player) {
        super((Container)new ContainerPortalManager(inv, player));
        this.tile = inv;
        this.playerInventory = player.field_71071_by;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String s = I18n.func_74838_a((String)this.tile.func_70005_c_());
        this.field_146289_q.func_78276_b(s, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(s) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(this.playerInventory.func_145748_c_().func_150260_c(), 8, this.field_147000_g - 96 + 2, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        for (int k = 0; k < 6; ++k) {
            if (this.tile.func_174887_a_(k) == 1) {
                this.func_73729_b(i + 18 * k + 50, j + 38, 176, 0, 4, 12);
                continue;
            }
            if (this.tile.func_174887_a_(k) != 2) continue;
            this.func_73729_b(i + 18 * k + 50, j + 38, 176, 12, 4, 12);
        }
        this.field_146297_k.func_110434_K().func_110577_a(iconTex);
        if (this.tile.isSuitableClimate()) {
            this.func_73729_b(i - 20, j + 4, 48, 0, 20, 20);
        } else {
            this.func_73729_b(i - 20, j + 4, 48, 20, 20, 20);
        }
        if (!this.tile.inputT.isEmpty()) {
            Fluid in = this.tile.inputT.getFluidType();
            int inAmo = 50 * this.tile.inputT.getFluidAmount() / 5000;
            this.renderFluid(in, inAmo, i + 18, j + 17, 12, 50);
        }
    }

    public void func_73863_a(int x, int y, float par3) {
        this.func_146276_q_();
        super.func_73863_a(x, y, par3);
        ArrayList<String> list = new ArrayList<String>();
        if (this.func_146978_c(18, 17, 12, 50, x, y) && !this.tile.inputT.isEmpty()) {
            int inAmo = 5000 * this.tile.inputT.getFluidAmount() / 5000;
            Fluid fluid = this.tile.inputT.getFluidType();
            if (fluid != null && inAmo > 0) {
                String nameIn = fluid.getLocalizedName(new FluidStack(fluid, 1000));
                list.add(nameIn);
                list.add(inAmo + " mB");
            }
        }
        if (this.func_146978_c(45, 20, 108, 18, x, y) && this.tile != null) {
            list.add("Input Card");
        }
        if (this.func_146978_c(45, 50, 108, 18, x, y) && this.tile != null) {
            list.add("Output Card");
        }
        if (this.func_146978_c(-20, 4, 20, 20, x, y) && this.tile != null) {
            list.add(I18n.func_74838_a((String)this.tile.climateSuitableMassage()));
        }
        this.func_146283_a(list, x, y);
        this.func_191948_b(x, y);
    }
}

