/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.machine.gui;

import defeatedcrow.hac.api.climate.ClimateAPI;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.climate.IClimate;
import defeatedcrow.hac.core.client.base.GuiBaseDC;
import defeatedcrow.hac.machine.block.TileReactorIBC;
import defeatedcrow.hac.machine.gui.ContainerReactorIBC;
import java.util.ArrayList;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiReactorIBC
extends GuiBaseDC {
    private static final ResourceLocation guiTex = new ResourceLocation("dcs_climate", "textures/gui/reactor_ibc_gui.png");
    private static final ResourceLocation iconTex = new ResourceLocation("dcs_climate", "textures/gui/gui_icons.png");
    private final InventoryPlayer playerInventory;
    private final TileReactorIBC machine;

    public GuiReactorIBC(TileReactorIBC te, InventoryPlayer playerInv) {
        super((Container)new ContainerReactorIBC(te, playerInv));
        this.playerInventory = playerInv;
        this.machine = te;
        this.field_147000_g = 200;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String s = I18n.func_135052_a((String)this.machine.func_70005_c_(), (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(s, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(s) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(this.playerInventory.func_145748_c_().func_150260_c(), 8, this.field_147000_g - 92, 0x404040);
    }

    public void func_73863_a(int x, int y, float partialTicks) {
        IClimate clm;
        String nameIn;
        Fluid fluid;
        int inAmo;
        this.func_146276_q_();
        super.func_73863_a(x, y, partialTicks);
        ArrayList<String> list = new ArrayList<String>();
        if (this.func_146978_c(30, 30, 12, 40, x, y) && this.machine.inputT1.getFluidAmount() > 0) {
            inAmo = this.machine.inputT1.getFluidAmount();
            fluid = this.machine.inputT1.getFluidType();
            if (fluid != null && inAmo > 0) {
                nameIn = fluid.getLocalizedName(new FluidStack(fluid, 1000));
                list.add(nameIn);
                list.add(inAmo + " mB");
            }
        }
        if (this.func_146978_c(113, 30, 12, 40, x, y) && this.machine.outputT1.getFluidAmount() > 0) {
            inAmo = this.machine.outputT1.getFluidAmount();
            fluid = this.machine.outputT1.getFluidType();
            if (fluid != null && inAmo > 0) {
                nameIn = fluid.getLocalizedName(new FluidStack(fluid, 1000));
                list.add(nameIn);
                list.add(inAmo + " mB");
            }
        }
        if (this.func_146978_c(105, 100, 40, 10, x, y) && (clm = ClimateAPI.register.getClimateFromInt(this.machine.func_174887_a_(2))) != null) {
            DCHeatTier h = clm.getHeat();
            list.add(h.toString());
        }
        this.func_146283_a(list, x, y);
        this.func_191948_b(x, y);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int inAmo;
        Fluid in;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(GuiReactorIBC.guiTex());
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        int l = this.getCookProgressScaled(39);
        this.func_73729_b(i + 68, j + 36, 176, 0, l, 21);
        if (this.machine.inputT1.getFluidAmount() > 0) {
            in = this.machine.inputT1.getFluidType();
            inAmo = 40 * this.machine.inputT1.getFluidAmount() / 4000;
            this.renderFluid(in, inAmo, i + 30, j + 32, 12, 40);
        }
        if (this.machine.outputT1.getFluidAmount() > 0) {
            in = this.machine.outputT1.getFluidType();
            inAmo = 40 * this.machine.outputT1.getFluidAmount() / 4000;
            this.renderFluid(in, inAmo, i + 113, j + 32, 12, 40);
        }
        this.field_146297_k.func_110434_K().func_110577_a(iconTex);
        this.func_73729_b(i + 105, j + 102, 0, 16, 46, 7);
        IClimate clm = ClimateAPI.register.getClimateFromInt(this.machine.func_174887_a_(2));
        if (clm != null) {
            int cl = clm.getHeat().getID() * 3;
            this.func_73729_b(i + 106 + cl, j + 99, 1, 25, 5, 10);
        }
    }

    private int getCookProgressScaled(int pixels) {
        int i = this.machine.func_174887_a_(0);
        int j = this.machine.getMaxBurnTime();
        return i != 0 && j != 0 ? i * pixels / j : 0;
    }

    protected static ResourceLocation guiTex() {
        return guiTex;
    }
}

