/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.machine.item;

import defeatedcrow.hac.core.base.DCItem;
import defeatedcrow.hac.core.util.DCUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;

public class ItemAdapterCard
extends DCItem {
    private final int maxMeta = names.length - 1;
    private static String[] names = new String[]{"item_input", "item_output", "fluid_input", "fluid_output"};

    public ItemAdapterCard() {
        this.func_77625_d(1);
    }

    public int getMaxMeta() {
        return this.maxMeta;
    }

    public String[] getNameSuffix() {
        return names;
    }

    public String getTexPath(int meta, boolean f) {
        String s = "items/misc/card_" + names[meta];
        if (f) {
            s = "textures/" + s;
        }
        return "dcs_climate:" + s;
    }

    public CardType getCardType(int meta) {
        if (meta == 0 || meta == 1) {
            return CardType.ITEM;
        }
        return CardType.FLUID;
    }

    public AccessType getAccessType(int meta) {
        if (meta == 0 || meta == 2) {
            return AccessType.INPUT;
        }
        return AccessType.OUTPUT;
    }

    public EnumActionResult onItemUse2(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player != null && !world.field_72995_K && player.func_70093_af()) {
            ItemStack held = player.func_184586_b(hand);
            IBlockState state = world.func_180495_p(pos);
            TileEntity tile = world.func_175625_s(pos);
            if (!DCUtil.isEmpty((ItemStack)held) && tile != null) {
                if (this.getCardType(held.func_77952_i()) == CardType.ITEM && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) {
                    String mes1 = "Stored inventory coordinate: " + pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p();
                    player.func_145747_a((ITextComponent)new TextComponentString(mes1));
                    NBTTagCompound tag = held.func_77978_p();
                    if (tag == null) {
                        tag = new NBTTagCompound();
                    }
                    tag.func_74768_a("card.dim", world.field_73011_w.getDimension());
                    tag.func_74768_a("card.X", pos.func_177958_n());
                    tag.func_74768_a("card.Y", pos.func_177956_o());
                    tag.func_74768_a("card.Z", pos.func_177952_p());
                    tag.func_74768_a("card.facing", facing.func_176745_a());
                    held.func_77982_d(tag);
                    return EnumActionResult.SUCCESS;
                }
                if (this.getCardType(held.func_77952_i()) == CardType.FLUID && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing)) {
                    String mes1 = "Stored fluidtank coordinate: " + pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p();
                    player.func_145747_a((ITextComponent)new TextComponentString(mes1));
                    NBTTagCompound tag = held.func_77978_p();
                    if (tag == null) {
                        tag = new NBTTagCompound();
                    }
                    tag.func_74768_a("card.dim", world.field_73011_w.getDimension());
                    tag.func_74768_a("card.X", pos.func_177958_n());
                    tag.func_74768_a("card.Y", pos.func_177956_o());
                    tag.func_74768_a("card.Z", pos.func_177952_p());
                    tag.func_74768_a("card.facing", facing.func_176745_a());
                    held.func_77982_d(tag);
                    return EnumActionResult.SUCCESS;
                }
            }
        }
        return EnumActionResult.PASS;
    }

    public BlockPos getPos(ItemStack item) {
        NBTTagCompound tag;
        if (!DCUtil.isEmpty((ItemStack)item) && item.func_77942_o() && (tag = item.func_77978_p()).func_74764_b("card.dim")) {
            int x = tag.func_74762_e("card.X");
            int y = tag.func_74762_e("card.Y");
            int z = tag.func_74762_e("card.Z");
            return new BlockPos(x, y, z);
        }
        return null;
    }

    public int getDim(ItemStack item) {
        NBTTagCompound tag;
        if (!DCUtil.isEmpty((ItemStack)item) && item.func_77942_o() && (tag = item.func_77978_p()).func_74764_b("card.dim")) {
            return tag.func_74762_e("card.dim");
        }
        return 0;
    }

    public EnumFacing getFacing(ItemStack item) {
        int id;
        NBTTagCompound tag;
        if (!DCUtil.isEmpty((ItemStack)item) && item.func_77942_o() && (tag = item.func_77978_p()).func_74764_b("card.dim") && (id = tag.func_74762_e("card.facing")) >= 0 && id < 6) {
            return EnumFacing.func_82600_a((int)id);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation2(ItemStack stack, @Nullable World world, List<String> tooltip) {
        if (!DCUtil.isEmpty((ItemStack)stack) && stack.func_77942_o()) {
            int dim = this.getDim(stack);
            BlockPos pos = this.getPos(stack);
            EnumFacing face = this.getFacing(stack);
            if (pos != null && face != null) {
                tooltip.add(TextFormatting.BOLD.toString() + "Stored data");
                tooltip.add("Dim: " + dim);
                tooltip.add("Pos: " + pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p());
                tooltip.add("Side: " + face);
            }
        } else {
            tooltip.add(TextFormatting.AQUA.toString() + I18n.func_135052_a((String)"dcs.tip.adaptercard", (Object[])new Object[0]));
        }
    }

    public static enum AccessType {
        INPUT,
        OUTPUT;

    }

    public static enum CardType {
        ITEM,
        FLUID;

    }
}

