/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.machine.item;

import defeatedcrow.hac.core.base.DCItem;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.food.FoodInit;
import defeatedcrow.hac.machine.MachineInit;
import defeatedcrow.hac.main.MainInit;
import defeatedcrow.hac.main.api.IPressMold;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemAluminiumMold
extends DCItem
implements IPressMold {
    private final int maxMeta;

    public ItemAluminiumMold() {
        this.maxMeta = 5;
    }

    public int getMaxMeta() {
        return this.maxMeta;
    }

    public String[] getNameSuffix() {
        return null;
    }

    public String getTexPath(int meta, boolean f) {
        String s = "items/misc/mold_aluminium";
        if (f) {
            s = "textures/" + s;
        }
        return "dcs_climate:" + s;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation2(ItemStack stack, @Nullable World world, List<String> tooltip) {
        if (!DCUtil.isEmpty((ItemStack)stack)) {
            ItemStack output = this.getOutput(stack);
            if (!DCUtil.isEmpty((ItemStack)output)) {
                tooltip.add(TextFormatting.BOLD.toString() + "Output: " + output.func_82833_r());
            } else {
                tooltip.add(I18n.func_135052_a((String)"dcs.tip.mold1", (Object[])new Object[0]));
            }
        }
        tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Tips ===");
        tooltip.add(I18n.func_135052_a((String)"dcs.tip.mold2", (Object[])new Object[0]));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return !DCUtil.isEmpty((ItemStack)stack) && stack.func_77952_i() > 0;
    }

    @Override
    public ItemStack setOutput(ItemStack mold, ItemStack output, int num) {
        int meta = -1;
        if (DCUtil.isSameItem((ItemStack)output, (ItemStack)new ItemStack(MachineInit.synthetic, 1, 0), (boolean)false) || this.matchOreName(output, "string")) {
            meta = 1;
        } else if (DCUtil.isSameItem((ItemStack)output, (ItemStack)new ItemStack(MachineInit.synthetic, 1, 2), (boolean)false) || DCUtil.isSameItem((ItemStack)output, (ItemStack)new ItemStack(Blocks.field_150410_aZ), (boolean)false)) {
            meta = 2;
        } else if (DCUtil.isSameItem((ItemStack)output, (ItemStack)new ItemStack(MainInit.syntheticBlock, 1, 8), (boolean)false) || DCUtil.isSameItem((ItemStack)output, (ItemStack)new ItemStack(Blocks.field_150359_w), (boolean)false)) {
            meta = 3;
        } else if (DCUtil.isSameItem((ItemStack)output, (ItemStack)new ItemStack(MachineInit.synthetic, 1, 2), (boolean)false) || this.matchOreName(output, "leather")) {
            meta = 4;
        } else if (DCUtil.isSameItem((ItemStack)output, (ItemStack)new ItemStack(MachineInit.synthetic, 1, 2), (boolean)false) || this.matchOreName(output, "rabbithide")) {
            meta = 5;
        }
        if (meta > 0) {
            ItemStack next = new ItemStack(mold.func_77973_b(), mold.func_190916_E(), meta);
            return next;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack getOutput(ItemStack mold) {
        if (!DCUtil.isEmpty((ItemStack)mold)) {
            int m = mold.func_77952_i();
            if (m == 1) {
                return new ItemStack(MachineInit.synthetic, 2, 0);
            }
            if (m == 2) {
                return new ItemStack(MachineInit.synthetic, 4, 2);
            }
            if (m == 3) {
                return new ItemStack(MainInit.syntheticBlock, 1, 0);
            }
            if (m == 4) {
                return new ItemStack(MachineInit.synthetic, 1, 3);
            }
            if (m == 5) {
                return new ItemStack(MachineInit.synthetic, 1, 4);
            }
        }
        return null;
    }

    @Override
    public int getRecipeNumber(ItemStack mold) {
        return 0;
    }

    @Override
    public List<ItemStack> getInputs(ItemStack mold) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack(MachineInit.reagent, 1, 2));
        if (mold.func_77952_i() == 4) {
            list.add(new ItemStack(MainInit.clothes, 1, 2));
        }
        if (mold.func_77952_i() == 5) {
            list.add(new ItemStack(FoodInit.crops, 1, 5));
        }
        return list;
    }

    private boolean matchOreName(ItemStack item, String name) {
        NonNullList list = OreDictionary.getOres((String)name);
        for (ItemStack check : list) {
            if (!OreDictionary.itemMatches((ItemStack)item, (ItemStack)check, (boolean)false)) continue;
            return true;
        }
        return false;
    }
}

