/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.machine.item.plating;

import defeatedcrow.hac.api.item.IPlatingTool;
import defeatedcrow.hac.core.base.DCItem;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.main.util.DCName;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemPlatingBase
extends DCItem
implements IPlatingTool {
    public int getMaxMeta() {
        return 0;
    }

    public String[] getNameSuffix() {
        return null;
    }

    public String func_77667_c(ItemStack stack) {
        int meta = stack.func_77952_i();
        return super.func_77658_a() + "_" + this.getItemName(meta);
    }

    public String getTexPath(int meta, boolean f) {
        String s = "items/misc/coating_" + this.getItemName(meta);
        if (f) {
            s = "textures/" + s;
        }
        return "dcs_climate:" + s;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation2(ItemStack stack, @Nullable World world, List<String> tooltip) {
        if (!DCUtil.isEmpty((ItemStack)stack)) {
            int meta = stack.func_77952_i();
            if (this.getEnchantments(meta) != null && this.getEnchantments(meta).length > 0) {
                tooltip.add(TextFormatting.BOLD.toString() + "Enchantments: ");
                for (Enchantment enc : this.getEnchantments(meta)) {
                    tooltip.add(TextFormatting.AQUA.toString() + enc.func_77316_c(1));
                }
            }
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Tips ===");
            tooltip.add(DCName.ON_ANVIL.getLocalizedName());
        }
    }

    public static boolean canAddEnchantment(ItemStack target, Enchantment enc) {
        int i = EnchantmentHelper.func_77506_a((Enchantment)enc, (ItemStack)target);
        int max = enc.func_77325_b();
        if (i > 0) {
            return i < max;
        }
        if (enc.func_92089_a(target)) {
            return true;
        }
        if (target.func_77973_b().func_77645_m() && !(target.func_77973_b() instanceof ItemArmor) && enc.field_77351_y == EnumEnchantmentType.DIGGER) {
            return true;
        }
        return target.func_77973_b().func_77645_m() && enc.field_77351_y == EnumEnchantmentType.BREAKABLE;
    }

    public abstract String getItemName(int var1);

    public abstract Enchantment[] getEnchantments(int var1);

    public boolean canEnchant(ItemStack target, ItemStack tool) {
        if (!DCUtil.isEmpty((ItemStack)target) && !DCUtil.isEmpty((ItemStack)tool)) {
            int meta = tool.func_77952_i();
            byte b = 0;
            boolean flag = false;
            if (target.func_77942_o() && target.func_77978_p().func_74764_b("dcs.plated")) {
                b = target.func_77978_p().func_74771_c("dcs.plated");
            }
            for (Enchantment enc : this.getEnchantments(meta)) {
                if (!ItemPlatingBase.canAddEnchantment(target, enc)) continue;
                flag = true;
            }
            return flag && b < 3;
        }
        return false;
    }

    public ItemStack getEnchantedItem(ItemStack target, ItemStack tool) {
        int meta = tool.func_77952_i();
        ItemStack ret = target.func_77946_l();
        Map map = EnchantmentHelper.func_82781_a((ItemStack)ret);
        for (Enchantment enc : this.getEnchantments(meta)) {
            int max;
            int i;
            if (!ItemPlatingBase.canAddEnchantment(target, enc) || (i = EnchantmentHelper.func_77506_a((Enchantment)enc, (ItemStack)ret)) >= (max = enc.func_77325_b())) continue;
            map.put(enc, i + 1);
        }
        if (!map.isEmpty()) {
            EnchantmentHelper.func_82782_a((Map)map, (ItemStack)ret);
            byte b = target.func_77942_o() ? target.func_77978_p().func_74771_c("dcs.plated") : (byte)0;
            ret.func_77978_p().func_74774_a("dcs.plated", (byte)(b + 1));
            return ret;
        }
        return ItemStack.field_190927_a;
    }
}

