/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.magic.block;

import com.google.common.collect.Lists;
import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.core.ClimateCore;
import defeatedcrow.hac.core.base.BlockDC;
import defeatedcrow.hac.magic.MagicInit;
import defeatedcrow.hac.main.packet.DCMainPacket;
import defeatedcrow.hac.main.packet.MessageBiomeGlass;
import defeatedcrow.hac.main.util.DCName;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Biomes;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBiomeGlass
extends BlockDC {
    public final int maxMeta;

    public BlockBiomeGlass(String s) {
        super(Material.field_151592_s, s);
        this.func_149711_c(0.2f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)DCState.TYPE4, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)DCState.POWERED, (Comparable)Boolean.valueOf(false)));
        this.maxMeta = 3;
        this.field_149787_q = false;
        this.field_149786_r = 0;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public List<ItemStack> getSubItemList() {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < this.maxMeta + 1; ++i) {
            list.add(new ItemStack((Block)this, 1, i));
        }
        return list;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)DCState.POWERED) != false ? 15 : 0;
    }

    public int func_180651_a(IBlockState state) {
        int i = (Integer)state.func_177229_b((IProperty)DCState.TYPE4);
        if (i > this.maxMeta) {
            i = this.maxMeta;
        }
        return i;
    }

    public IBlockState func_176203_a(int meta) {
        int i = meta & 3;
        if (i > this.maxMeta) {
            i = this.maxMeta;
        }
        boolean f = (meta & 8) > 0;
        IBlockState state = this.func_176223_P().func_177226_a((IProperty)DCState.TYPE4, (Comparable)Integer.valueOf(i));
        state = state.func_177226_a((IProperty)DCState.POWERED, (Comparable)Boolean.valueOf(f));
        return state;
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        int f = 0;
        i = (Integer)state.func_177229_b((IProperty)DCState.TYPE4);
        if (i > this.maxMeta) {
            i = this.maxMeta;
        }
        f = (Boolean)state.func_177229_b((IProperty)DCState.POWERED) != false ? 8 : 0;
        return i + f;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DCState.POWERED, DCState.TYPE4});
    }

    public boolean onRightClick(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player != null) {
            BlockBiomeGlass.changePowerState(world, pos);
            world.func_184133_a(null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.8f, 2.0f);
        }
        return true;
    }

    public static void changePowerState(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == MagicInit.biomeOrb) {
            boolean m = DCState.getBool((IBlockState)state, (PropertyBool)DCState.POWERED);
            if (m) {
                if (!world.field_72995_K) {
                    world.func_180501_a(pos, state.func_177226_a((IProperty)DCState.POWERED, (Comparable)Boolean.valueOf(false)), 3);
                }
                BlockBiomeGlass.rebuildBiome(world, pos);
            } else {
                if (!world.field_72995_K) {
                    world.func_180501_a(pos, state.func_177226_a((IProperty)DCState.POWERED, (Comparable)Boolean.valueOf(true)), 3);
                }
                BlockBiomeGlass.shapeBiome(world, pos, DCState.getInt((IBlockState)state, (PropertyInteger)DCState.TYPE4));
            }
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        BlockBiomeGlass.rebuildBiome(world, pos);
        super.func_180663_b(world, pos, state);
    }

    public static void shapeBiome(World world, BlockPos pos, int meta) {
        BlockPos st = pos.func_177982_a(-7, 0, -7);
        BlockPos en = pos.func_177982_a(7, 0, 7);
        Iterable poses = BlockPos.func_177980_a((BlockPos)st, (BlockPos)en);
        for (BlockPos p : poses) {
            Chunk c = world.func_175726_f(p);
            int i = p.func_177958_n() & 0xF;
            int j = p.func_177952_p() & 0xF;
            int k = c.func_76605_m()[j << 4 | i] & 0xFF;
            Biome biome = Biomes.field_76772_c;
            switch (meta) {
                case 1: {
                    biome = Biomes.field_76782_w;
                    break;
                }
                case 2: {
                    biome = Biomes.field_76769_d;
                    break;
                }
                case 3: {
                    biome = Biomes.field_76774_n;
                    break;
                }
            }
            k = Biome.func_185362_a((Biome)biome);
            c.func_76605_m()[j << 4 | i] = (byte)(k & 0xFF);
        }
    }

    public static void rebuildBiome(World world, BlockPos pos) {
        BlockPos st = pos.func_177982_a(-7, 0, -7);
        BlockPos en = pos.func_177982_a(7, 0, 7);
        Iterable poses = BlockPos.func_177980_a((BlockPos)st, (BlockPos)en);
        for (BlockPos p : poses) {
            Chunk c = world.func_175726_f(p);
            int i = p.func_177958_n() & 0xF;
            int j = p.func_177952_p() & 0xF;
            int k = c.func_76605_m()[j << 4 | i] & 0xFF;
            Biome biome = world.func_72959_q().func_180300_a(p, Biomes.field_76772_c);
            k = Biome.func_185362_a((Biome)biome);
            c.func_76605_m()[j << 4 | i] = (byte)(k & 0xFF);
        }
        if (!world.field_72995_K) {
            Biome biome2 = world.func_72959_q().func_180300_a(pos, Biomes.field_76772_c);
            int k2 = Biome.func_185362_a((Biome)biome2) & 0xFF;
            DCMainPacket.INSTANCE.sendToAll((IMessage)new MessageBiomeGlass(pos, (short)k2));
        }
    }

    public static void rebuildBiomeFromID(World world, BlockPos pos, int biomeId) {
        BlockPos st = pos.func_177982_a(-7, 0, -7);
        BlockPos en = pos.func_177982_a(7, 0, 7);
        Iterable poses = BlockPos.func_177980_a((BlockPos)st, (BlockPos)en);
        for (BlockPos p : poses) {
            Chunk c = world.func_175726_f(p);
            int i = p.func_177958_n() & 0xF;
            int j = p.func_177952_p() & 0xF;
            int k = c.func_76605_m()[j << 4 | i] & 0xFF;
            c.func_76605_m()[j << 4 | i] = (byte)(biomeId & 0xFF);
        }
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        boolean b;
        boolean bl = b = world.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151579_a;
        return !b && world.func_180495_p(pos.func_177972_a(face)).func_185904_a() == Material.field_151586_h;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        if (ClimateCore.proxy.isShiftKeyDown()) {
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Tips ===");
            tooltip.add(I18n.func_135052_a((String)"dcs.tip.biomeglass", (Object[])new Object[0]));
            tooltip.add(DCName.RIGHT_CLICK.getLocalizedName() + ": " + DCName.TURN_OFF.getLocalizedName());
        } else {
            tooltip.add(TextFormatting.ITALIC.toString() + "=== Lshift key: expand tooltip ===");
        }
    }
}

