/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.magic.block;

import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.api.climate.ClimateAPI;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.core.base.DCSimpleBlock;
import defeatedcrow.hac.core.base.ITexturePath;
import defeatedcrow.hac.main.ClimateMain;
import defeatedcrow.hac.main.client.particle.ParticleBlink;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockColorCube
extends DCSimpleBlock
implements ITexturePath {
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.5, 0.75);
    protected static final AxisAlignedBB AABB2 = new AxisAlignedBB(0.25, 0.25, 0.25, 0.75, 0.75, 0.75);
    private static String[] names = new String[]{"u1", "g1", "r1", "b1", "w1", "u2", "g2", "r2", "b2", "w2"};

    public BlockColorCube(Material m, String s) {
        super(m, s, 9, false);
        this.func_149675_a(true);
        this.func_149711_c(1.0f);
        this.func_149752_b(15.0f);
    }

    public String[] getNameSuffix() {
        return names;
    }

    public String getTexPath(int meta, boolean f) {
        if (meta >= names.length) {
            meta = names.length - 1;
        }
        String s = "blocks/magic/color_crystal_" + names[meta];
        if (f) {
            s = "textures/" + s;
        }
        return "dcs_climate:" + s;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return DCState.getInt((IBlockState)state, (PropertyInteger)DCState.TYPE16) > 4 ? AABB2 : AABB;
    }

    @Nullable
    public AxisAlignedBB getCollisionBox(IBlockState state, IBlockAccess world, BlockPos pos) {
        return DCState.getInt((IBlockState)state, (PropertyInteger)DCState.TYPE16) > 4 ? AABB2 : AABB;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        boolean b;
        boolean bl = b = world.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151579_a;
        return !b && world.func_180495_p(pos.func_177972_a(face)).func_185904_a() == Material.field_151586_h;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        int c = ClimateMain.proxy.getParticleCount();
        if ((DCState.getInt((IBlockState)state, (PropertyInteger)DCState.TYPE16) > 4 || this.suitablePlace(world, pos, state)) && ClimateMain.proxy.getParticleCount() > 0) {
            double x = (double)pos.func_177958_n() + rand.nextDouble();
            double y = (double)pos.func_177956_o() + 0.25 + rand.nextDouble();
            double z = (double)pos.func_177952_p() + rand.nextDouble();
            Particle p = new ParticleBlink.Factory().func_178902_a(0, world, x, y, z, 0.0, 0.0, 0.0, new int[0]);
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a(p);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        if (stack.func_77952_i() < 5) {
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Requirement ===");
            tooltip.add(I18n.func_135052_a((String)("dcs.tip.color_cube" + stack.func_77952_i()), (Object[])new Object[0]));
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(world, pos, state, rand);
        if (!world.field_72995_K && this.suitablePlace(world, pos, state)) {
            IBlockState retS;
            int st = DCState.getInt((IBlockState)state, (PropertyInteger)DCState.TYPE16);
            if (world.field_73012_v.nextInt(5) == 0 && st != -1 && st < 5 && world.func_180501_a(pos, retS = this.func_176203_a(st + 5), 2)) {
                world.func_175685_c(pos, (Block)this, true);
                world.func_184133_a(null, pos, SoundEvents.field_187561_bM, SoundCategory.BLOCKS, 0.8f, 2.0f);
            }
        }
    }

    private boolean suitablePlace(World world, BlockPos pos, IBlockState state) {
        int num = DCState.getInt((IBlockState)state, (PropertyInteger)DCState.TYPE16);
        if (num == 0) {
            for (int y = 1; y < 5; ++y) {
                if (world.func_180495_p(pos.func_177981_b(y)).func_185904_a() == Material.field_151586_h) continue;
                return false;
            }
            return true;
        }
        if (num == 1) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    IBlockState tb;
                    if (x == 0 && z == 0 || (tb = world.func_180495_p(pos.func_177982_a(x, 0, z))).func_185904_a() == Material.field_151585_k || tb.func_185904_a() == Material.field_151584_j) continue;
                    return false;
                }
            }
            return true;
        }
        if (num == 2 && ClimateAPI.calculator.getAverageTemp(world, pos).getTier() > DCHeatTier.SMELTING.getTier()) {
            return true;
        }
        if (num == 3 && pos.func_177956_o() < 11 && world.func_175699_k(pos) == 0) {
            return true;
        }
        return num == 4 && world.func_175710_j(pos) && pos.func_177956_o() > 135;
    }
}

