/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.magic.entity;

import com.google.common.base.Predicate;
import defeatedcrow.hac.api.magic.MagicColor;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.magic.PictureList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class EntityBlackDog
extends EntityWolf {
    private BlockPos picturePos = null;

    public EntityBlackDog(World world) {
        super(world);
        this.func_70105_a(0.6f, 0.85f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, new AIAvoidEntity<EntityGolem>(this, EntityGolem.class, 24.0f, 1.5, 0.5));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.5, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIPlayerHurtByTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityMob.class, 50, false, true, (Predicate)null));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187869_gK, 0.15f, 1.0f);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187861_gG;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187863_gH;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187859_gF;
    }

    public void func_70903_f(boolean tamed) {
        super.func_70903_f(tamed);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return null;
    }

    public static void registerFixesWolf(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntityBlackDog.class);
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.8f;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        return false;
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_72935_r()) {
            this.func_70106_y();
        }
    }

    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.picturePos == null) {
                int cx = this.func_180425_c().func_177958_n() >> 4;
                int cz = this.func_180425_c().func_177952_p() >> 4;
                ChunkPos chunk = new ChunkPos(cx, cz);
                BlockPos pos = PictureList.getPos(chunk, MagicColor.BLACK);
                if (pos != null) {
                    this.setPicturePos(new BlockPos((Vec3i)pos));
                }
            } else {
                IItemHandler chest = null;
                for (int y = 1; chest == null && y < 10; ++y) {
                    TileEntity tile = this.field_70170_p.func_175625_s(this.picturePos.func_177979_c(y));
                    if (tile == null || !tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP)) continue;
                    chest = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
                }
                if (chest != null) {
                    AxisAlignedBB bb = this.func_174813_aQ().func_72314_b(1.0, 0.5, 1.0);
                    List list = this.field_70170_p.func_72872_a(EntityItem.class, bb);
                    block1: for (int i = 0; i < list.size(); ++i) {
                        EntityItem drop = (EntityItem)list.get(i);
                        if (drop.field_70128_L || DCUtil.isEmpty((ItemStack)drop.func_92059_d())) continue;
                        ItemStack ins = drop.func_92059_d().func_77946_l();
                        if (this.func_110143_aJ() < this.func_110138_aP() && ins.func_77973_b() instanceof ItemFood && ((ItemFood)ins.func_77973_b()).func_77845_h()) {
                            ins.func_77979_a(1);
                            this.func_70691_i(16.0f);
                            if (ins.func_190916_E() < 1) {
                                drop.func_70106_y();
                            }
                        }
                        for (int j = 0; j < chest.getSlots(); ++j) {
                            ItemStack rem = chest.insertItem(j, ins, true);
                            if (rem.func_190916_E() < ins.func_190916_E()) {
                                chest.insertItem(j, ins, false);
                                if (!DCUtil.isEmpty((ItemStack)rem) && rem.func_190916_E() > 0) {
                                    drop.func_92059_d().func_190920_e(rem.func_190916_E());
                                } else {
                                    drop.func_92059_d().func_190920_e(0);
                                    drop.func_70106_y();
                                }
                            }
                            if (drop.func_92059_d().func_190926_b()) continue block1;
                        }
                    }
                }
            }
        }
        super.func_70636_d();
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.picturePos == null) {
                int cx = this.func_180425_c().func_177958_n() >> 4;
                int cz = this.func_180425_c().func_177952_p() >> 4;
                ChunkPos chunk = new ChunkPos(cx, cz);
                BlockPos pos = PictureList.getPos(chunk, MagicColor.BLACK);
                if (pos != null) {
                    this.setPicturePos(new BlockPos((Vec3i)pos));
                }
            } else {
                IItemHandler chest = null;
                for (int y = 1; chest == null && y < 10; ++y) {
                    TileEntity tile = this.field_70170_p.func_175625_s(this.picturePos.func_177979_c(y));
                    if (tile == null || !tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP)) continue;
                    chest = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
                }
                for (ItemStack item : this.func_184214_aD()) {
                    if (DCUtil.isEmpty((ItemStack)item)) continue;
                    if (chest != null) {
                        for (int j = 0; j < chest.getSlots(); ++j) {
                            ItemStack rem = chest.insertItem(j, item, true);
                            if (rem.func_190916_E() >= item.func_190916_E()) continue;
                            chest.insertItem(j, item, false);
                            if (!DCUtil.isEmpty((ItemStack)rem) && rem.func_190916_E() > 0) {
                                item.func_190920_e(rem.func_190916_E());
                                continue;
                            }
                            item.func_190920_e(0);
                        }
                    }
                    if (item.func_190926_b()) continue;
                    EntityItem drop = new EntityItem(this.field_70170_p, (double)this.func_180425_c().func_177958_n(), (double)this.func_180425_c().func_177956_o() + 0.125, (double)this.func_180425_c().func_177952_p(), item.func_77946_l());
                    this.field_70170_p.func_72838_d((Entity)drop);
                }
            }
        }
        super.func_70645_a(cause);
    }

    public boolean func_70652_k(Entity entityIn) {
        if (entityIn instanceof EntityCreeper) {
            boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), ((EntityCreeper)entityIn).func_110138_aP() * 2.0f);
            return flag;
        }
        return super.func_70652_k(entityIn);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (entity != null && entity instanceof EntityZombie) {
            amount /= 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public void setPicturePos(BlockPos pos) {
        this.picturePos = pos;
    }

    public BlockPos getPicturePos() {
        return this.picturePos;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.picturePos != null) {
            compound.func_74768_a("p_posx", this.picturePos.func_177958_n());
            compound.func_74768_a("p_posy", this.picturePos.func_177956_o());
            compound.func_74768_a("p_posz", this.picturePos.func_177952_p());
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("p_posx")) {
            int x = compound.func_74762_e("p_posx");
            int y = compound.func_74762_e("p_posy");
            int z = compound.func_74762_e("p_posz");
            this.picturePos = new BlockPos(x, y, z);
        }
    }

    public class EntityAIPlayerHurtByTarget
    extends EntityAITarget {
        EntityBlackDog dog;
        EntityLivingBase attacker;
        EntityPlayer nearest;
        private int timestamp;

        public EntityAIPlayerHurtByTarget(EntityBlackDog theDefendingIn) {
            super((EntityCreature)theDefendingIn, false);
            this.dog = theDefendingIn;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            this.nearest = this.dog.field_70170_p.func_184137_a(EntityBlackDog.this.field_70165_t, EntityBlackDog.this.field_70163_u, EntityBlackDog.this.field_70161_v, 16.0, false);
            if (this.nearest == null || !this.nearest.func_70089_S()) {
                return false;
            }
            this.attacker = this.nearest.func_70643_av();
            int i = this.nearest.func_142015_aE();
            return i != this.timestamp && this.func_75296_a(this.attacker, false);
        }

        public void func_75249_e() {
            this.field_75299_d.func_70624_b(this.attacker);
            if (this.nearest != null && !this.nearest.func_70089_S()) {
                this.timestamp = this.nearest.func_142015_aE();
            }
            super.func_75249_e();
        }
    }

    class AIAvoidEntity<T extends Entity>
    extends EntityAIAvoidEntity<T> {
        private final EntityBlackDog wolf;

        public AIAvoidEntity(EntityBlackDog wolfIn, Class<T> classIn, float dist, double far, double near) {
            super((EntityCreature)wolfIn, classIn, dist, far, near);
            this.wolf = wolfIn;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && this.field_75376_d instanceof EntityGolem;
        }

        public void func_75249_e() {
            EntityBlackDog.this.func_70624_b(null);
            super.func_75249_e();
        }

        public void func_75246_d() {
            EntityBlackDog.this.func_70624_b(null);
            super.func_75246_d();
        }
    }
}

