/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.magic.entity;

import com.google.common.base.Optional;
import defeatedcrow.hac.core.base.DCEntityBase;
import defeatedcrow.hac.core.util.DCTimeHelper;
import defeatedcrow.hac.magic.proj.EntityFlowerBolt;
import defeatedcrow.hac.main.config.MainCoreConfig;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntityFlowerTurret
extends DCEntityBase {
    protected static final DataParameter<Boolean> TAMED = EntityDataManager.func_187226_a(EntityFlowerTurret.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(EntityFlowerTurret.class, (DataSerializer)DataSerializers.field_187203_m);
    public int maxLivingTime = MainCoreConfig.flower_turret_limit;
    public int livingDay = 0;
    public int lastDay = 0;
    public EntityLivingBase targetEntity = null;
    public EntityLivingBase targetClose = null;
    private int coolTime = 12;
    private int count = 0;

    public EntityFlowerTurret(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 1.0f);
    }

    public double func_70042_X() {
        return 1.0;
    }

    public EntityFlowerTurret(World worldIn, double posX, double posY, double posZ) {
        super(worldIn, posX, posY, posZ);
    }

    public EntityFlowerTurret(World worldIn, double posX, double posY, double posZ, @Nullable EntityPlayer player) {
        super(worldIn, posX, posY, posZ, player);
    }

    public void setMaxLivingTime(int i) {
        this.maxLivingTime = i;
    }

    protected ItemStack drops() {
        return ItemStack.field_190927_a;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.coolTime <= 0) {
                if (this.keepMeleeAttack()) {
                    this.count = 0;
                    this.onMeleeAttack();
                    this.coolTime = 4;
                } else if (this.keepRangedAttack()) {
                    this.onRangedAttack();
                    ++this.count;
                    if (this.count > 2) {
                        this.count = 0;
                        this.coolTime = 20;
                    } else {
                        this.coolTime = 2;
                    }
                } else {
                    this.count = 0;
                    this.coolTime = this.updateTarget() ? 20 : 80;
                }
            } else {
                --this.coolTime;
            }
            EntityLivingBase owner = this.getOwner();
            EntityLivingBase look = null;
            if (this.targetClose != null) {
                look = this.targetClose;
            } else if (this.targetEntity != null) {
                look = this.targetEntity;
            } else if (owner != null) {
                look = owner;
            }
            if (look != null) {
                double lookX = look.field_70165_t;
                double lookY = look.field_70163_u + (double)look.func_70047_e() * 0.5;
                double lookZ = look.field_70161_v;
                double d0 = lookX - this.field_70165_t;
                double d1 = lookY - (this.field_70163_u + 1.0);
                double d2 = lookZ - this.field_70161_v;
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
                float f1 = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.29577951308232));
                this.field_70125_A = this.updateRotation(this.field_70125_A, f1, 40.0f);
                this.field_70177_z = this.updateRotation(this.field_70177_z, f, 10.0f);
            }
            if (this.livingDay > this.maxLivingTime) {
                this.func_70106_y();
            } else {
                int day = (int)(DCTimeHelper.totalTime((World)this.field_70170_p) / 24000L);
                if (day > this.lastDay) {
                    ++this.livingDay;
                    this.lastDay = day;
                }
            }
            this.field_70181_x -= 0.04;
            this.func_70072_I();
            if (this.field_70171_ac) {
                this.field_70181_x += 0.08;
                if (this.field_70181_x > 0.15) {
                    this.field_70181_x = 0.15;
                }
            } else {
                this.field_70181_x = this.field_70122_E ? (this.field_70181_x *= 0.5) : (this.field_70181_x *= 0.95);
            }
        }
        this.field_70159_w = 0.0;
        this.field_70179_y = 0.0;
    }

    private boolean canAttackPlayer(@Nonnull EntityLivingBase target) {
        if (this.getOwner() instanceof EntityPlayer && target instanceof EntityPlayer) {
            return ((EntityPlayer)this.getOwner()).func_96122_a((EntityPlayer)target);
        }
        return true;
    }

    private boolean keepMeleeAttack() {
        if (this.targetClose != null && this.targetClose.func_70089_S() && this.canAttackPlayer(this.targetClose)) {
            if (!this.func_184188_bt().isEmpty() && this.func_184188_bt().size() > 0) {
                if (this.func_184188_bt().get(0) == this.targetClose) {
                    return true;
                }
                this.func_184226_ay();
            } else if (this.targetClose != null && !this.func_184207_aI()) {
                if (this.targetClose.func_184218_aH()) {
                    this.targetClose.func_184210_p();
                }
                this.targetClose.func_184220_m((Entity)this);
            }
            return true;
        }
        return false;
    }

    private boolean onMeleeAttack() {
        return this.targetClose.func_70097_a(DamageSource.field_76367_g, (float)(MainCoreConfig.flower_turret_damage * 2.0));
    }

    private boolean keepRangedAttack() {
        return this.targetClose == null && this.targetEntity != null && this.targetEntity.func_70089_S() && this.targetEntity.func_70685_l((Entity)this);
    }

    private boolean onRangedAttack() {
        EntityFlowerBolt entityarrow = new EntityFlowerBolt(this.field_70170_p, (Entity)this);
        entityarrow.setAim((Entity)this, this.field_70125_A, this.field_70177_z, 0.0f, 5.0f, 0.1f);
        entityarrow.setTarget(this.targetEntity);
        this.func_184185_a(SoundEvents.field_187638_cR, 0.75f, 1.5f);
        return this.field_70170_p.func_72838_d((Entity)entityarrow);
    }

    private boolean updateTarget() {
        this.updateCloseTarget();
        this.updateRangedTarget();
        return this.targetClose != null || this.targetEntity != null;
    }

    private void updateRangedTarget() {
        if (this.targetEntity != null) {
            float dist = MathHelper.func_76133_a((double)this.targetEntity.func_70068_e((Entity)this));
            if (this.targetEntity.func_70089_S() && dist < 5.0f) {
                this.targetClose = this.targetEntity;
                this.targetEntity = null;
            } else if (!this.targetEntity.func_70089_S() || dist > 36.0f) {
                this.targetEntity = null;
            }
        }
        if (this.targetEntity == null) {
            EntityLivingBase owner = this.getOwner();
            if (owner != null) {
                if (owner.func_110144_aD() != null && owner.func_110144_aD() != this.targetClose && MathHelper.func_76133_a((double)owner.func_110144_aD().func_70068_e((Entity)this)) <= 36.0f) {
                    this.targetEntity = owner.func_110144_aD();
                    return;
                }
                if (owner.func_70643_av() != null && owner.func_70643_av() != this.targetClose && MathHelper.func_76133_a((double)owner.func_70643_av().func_70068_e((Entity)this)) <= 36.0f) {
                    this.targetEntity = owner.func_70643_av();
                    return;
                }
            }
            AxisAlignedBB aabb = new AxisAlignedBB(this.field_70165_t - 32.0, this.field_70163_u - 12.0, this.field_70161_v - 32.0, this.field_70165_t + 32.0, this.field_70163_u + 12.0, this.field_70161_v + 32.0);
            List list = this.field_70170_p.func_72872_a(EntityLivingBase.class, aabb);
            float d0 = 36.0f;
            for (int i = 0; i < list.size(); ++i) {
                EntityLivingBase mob = (EntityLivingBase)list.get(i);
                if (mob == null) continue;
                float d1 = MathHelper.func_76133_a((double)mob.func_70068_e((Entity)this));
                if (owner != null && mob.func_70643_av() == owner && d1 < 36.0f && mob != this.targetClose) {
                    this.targetEntity = mob;
                    return;
                }
                if (!(mob instanceof IMob) || mob == this.targetClose || !(d1 > 5.0f) || !(d1 < d0) || !mob.func_70685_l((Entity)this)) continue;
                this.targetEntity = mob;
                d0 = d1;
            }
        }
    }

    private void updateCloseTarget() {
        if (this.targetClose != null) {
            float dist = MathHelper.func_76133_a((double)this.targetClose.func_70068_e((Entity)this));
            if (this.targetClose.func_70089_S() && dist >= 5.0f && dist <= 36.0f) {
                this.targetEntity = this.targetClose;
                this.targetClose = null;
            } else if (!this.targetClose.func_70089_S() || dist > 36.0f) {
                this.targetClose = null;
            }
        }
        if (this.targetClose == null) {
            EntityLivingBase owner;
            if (!this.func_184188_bt().isEmpty() && this.func_184188_bt().size() > 0 && this.func_184188_bt().get(0) instanceof EntityLivingBase) {
                this.targetClose = (EntityLivingBase)this.func_184188_bt().get(0);
            }
            if ((owner = this.getOwner()) != null) {
                if (owner.func_110144_aD() != null && MathHelper.func_76133_a((double)owner.func_110144_aD().func_70068_e((Entity)this)) < 5.0f) {
                    this.targetClose = owner.func_110144_aD();
                    return;
                }
                if (owner.func_70643_av() != null && MathHelper.func_76133_a((double)owner.func_70643_av().func_70068_e((Entity)this)) < 5.0f) {
                    this.targetClose = owner.func_70643_av();
                    return;
                }
            }
            AxisAlignedBB aabb = new AxisAlignedBB(this.field_70165_t - 3.0, this.field_70163_u - 2.0, this.field_70161_v - 3.0, this.field_70165_t + 3.0, this.field_70163_u + 2.0, this.field_70161_v + 3.0);
            List list = this.field_70170_p.func_72872_a(EntityLivingBase.class, aabb);
            float d0 = 6.0f;
            for (int i = 0; i < list.size(); ++i) {
                EntityLivingBase mob = (EntityLivingBase)list.get(i);
                if (mob == null) continue;
                float d1 = MathHelper.func_76133_a((double)mob.func_70068_e((Entity)this));
                if (owner != null && mob.func_70643_av() == owner & d1 < 5.0f) {
                    this.targetClose = mob;
                    return;
                }
                if (!(mob instanceof IMob) || !(d1 < d0)) continue;
                this.targetClose = mob;
                d0 = d1;
            }
        }
    }

    private float updateRotation(float f1, float f2, float f3) {
        float f = MathHelper.func_76142_g((float)(f2 - f1));
        if (f > f3) {
            f = f3;
        }
        if (f < -f3) {
            f = -f3;
        }
        return f1 + f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TAMED, (Object)false);
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, (Object)Optional.absent());
    }

    protected void func_70037_a(NBTTagCompound tag) {
        String s;
        super.func_70037_a(tag);
        this.livingDay = tag.func_74762_e("LivingDay");
        this.lastDay = tag.func_74762_e("LastDay");
        if (tag.func_150297_b("OwnerUUID", 8)) {
            s = tag.func_74779_i("OwnerUUID");
        } else {
            String s1 = tag.func_74779_i("Owner");
            s = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s1);
        }
        if (!s.isEmpty()) {
            try {
                this.setOwnerId(UUID.fromString(s));
                this.setTamed(true);
            }
            catch (Throwable var4) {
                this.setTamed(false);
            }
        }
    }

    protected void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a("LivingDay", this.livingDay);
        tag.func_74768_a("LastDay", this.lastDay);
        if (this.getOwnerId() == null) {
            tag.func_74778_a("OwnerUUID", "");
        } else {
            tag.func_74778_a("OwnerUUID", this.getOwnerId().toString());
        }
    }

    public boolean isTamed() {
        return (Boolean)this.field_70180_af.func_187225_a(TAMED);
    }

    public void setTamed(boolean tamed) {
        boolean b0 = (Boolean)this.field_70180_af.func_187225_a(TAMED);
        if (tamed != b0) {
            this.field_70180_af.func_187227_b(TAMED, (Object)tamed);
        }
    }

    @Nullable
    public UUID getOwnerId() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orNull();
    }

    public void setOwnerId(@Nullable UUID p_184754_1_) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, (Object)Optional.fromNullable((Object)p_184754_1_));
    }

    public void setTamedBy(EntityPlayer player) {
        this.setTamed(true);
        this.setOwnerId(player.func_110124_au());
    }

    @Nullable
    public EntityLivingBase getOwner() {
        try {
            UUID uuid = this.getOwnerId();
            return uuid == null ? null : this.field_70170_p.func_152378_a(uuid);
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    public boolean isOwner(EntityLivingBase entityIn) {
        return entityIn == this.getOwner();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    public boolean isCollectable(@Nullable ItemStack item) {
        return false;
    }

    protected boolean isFallable() {
        return false;
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        EntityLivingBase owner = this.getOwner();
        if (owner != null && player == owner) {
            this.func_184185_a(SoundEvents.field_187638_cR, 1.0f, 1.0f);
            if (this.field_70170_p instanceof WorldServer) {
                ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.VILLAGER_HAPPY, this.field_70165_t, this.field_70163_u, this.field_70161_v, 8, 0.5, 0.5, 0.5, 0.5, new int[0]);
            }
            this.deadPos = this.func_180425_c();
            return true;
        }
        return false;
    }
}

