/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.magic.event;

import com.google.common.collect.Lists;
import defeatedcrow.hac.api.climate.ClimateCalculateEvent;
import defeatedcrow.hac.api.climate.DCAirflow;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.climate.IClimate;
import defeatedcrow.hac.api.climate.WorldHeatTierEvent;
import defeatedcrow.hac.api.magic.IJewel;
import defeatedcrow.hac.api.magic.MagicColor;
import defeatedcrow.hac.api.recipe.ICrusherRecipe;
import defeatedcrow.hac.api.recipe.IMillRecipe;
import defeatedcrow.hac.api.recipe.RecipeAPI;
import defeatedcrow.hac.core.ClimateCore;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.machine.MachineInit;
import defeatedcrow.hac.magic.MagicInit;
import defeatedcrow.hac.magic.PictureList;
import defeatedcrow.hac.magic.entity.EntityBlackDog;
import defeatedcrow.hac.main.ClimateMain;
import defeatedcrow.hac.main.MainInit;
import defeatedcrow.hac.main.config.ModuleConfig;
import defeatedcrow.hac.main.item.tool.ItemScytheDC;
import defeatedcrow.hac.main.util.MainUtil;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class MagicCommonEvent {
    int count = 60;

    @SubscribeEvent
    public void onAttackEvent(LivingAttackEvent event) {
        EntityLivingBase target = event.getEntityLiving();
        DamageSource source = event.getSource();
        if (target != null && source != null) {
            EntityLivingBase owner;
            if (source.func_76346_g() instanceof EntityTameable) {
                EntityTameable living = (EntityTameable)source.func_76346_g();
                boolean amu = DCUtil.hasCharmItem((EntityLivingBase)living, (ItemStack)new ItemStack(MagicInit.colorBadge, 1, 3));
                if (amu && living.func_70902_q() instanceof EntityPlayer) {
                    target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)living.func_70902_q())), event.getAmount());
                    event.setCanceled(true);
                } else if (DCUtil.hasCharmItem((EntityLivingBase)living, (ItemStack)new ItemStack(MagicInit.colorPendant, 1, 4)) && !(target instanceof IMob)) {
                    event.setCanceled(true);
                    return;
                }
            } else if (source.func_76346_g() instanceof EntityLivingBase && (owner = (EntityLivingBase)source.func_76346_g()) != null) {
                if (DCUtil.hasCharmItem((EntityLivingBase)owner, (ItemStack)new ItemStack(MagicInit.colorBadge, 1, 3))) {
                    target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)target), event.getAmount());
                    event.setCanceled(true);
                } else if (DCUtil.hasCharmItem((EntityLivingBase)owner, (ItemStack)new ItemStack(MagicInit.colorPendant, 1, 4)) && !(target instanceof IMob)) {
                    event.setCanceled(true);
                    return;
                }
                if (MagicCommonEvent.getOffhandJewelColor(owner) == MagicColor.GREEN) {
                    float healamo = event.getAmount() * 0.25f;
                    owner.func_70691_i(healamo);
                    event.getSource().func_76348_h();
                }
            }
        }
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        EntityPlayer player = event.getEntityPlayer();
        Entity target = event.getTarget();
        if (player != null && target != null) {
            if (player.func_70093_af() && !player.field_70170_p.field_72995_K && DCUtil.hasCharmItem((EntityLivingBase)player, (ItemStack)new ItemStack(MagicInit.colorRing2, 1, 0))) {
                if (target instanceof EntityLiving) {
                    player.openGui((Object)ClimateMain.instance, target.func_145782_y(), player.field_70170_p, target.func_180425_c().func_177958_n(), target.func_180425_c().func_177956_o(), target.func_180425_c().func_177952_p());
                    event.setCancellationResult(EnumActionResult.SUCCESS);
                }
            } else if (MagicCommonEvent.getOffhandJewelColor(event.getEntityLiving()) == MagicColor.WHITE && target instanceof EntityLiving && target.func_184187_bx() != player) {
                target.func_184205_a((Entity)player, true);
            }
        }
    }

    private void playTameEffect(Entity animal) {
        EnumParticleTypes enumparticletypes = EnumParticleTypes.HEART;
        for (int i = 0; i < 7; ++i) {
            double d0 = animal.func_130014_f_().field_73012_v.nextGaussian() * 0.02;
            double d1 = animal.func_130014_f_().field_73012_v.nextGaussian() * 0.02;
            double d2 = animal.func_130014_f_().field_73012_v.nextGaussian() * 0.02;
            animal.func_130014_f_().func_175688_a(enumparticletypes, animal.field_70165_t + (double)(animal.func_130014_f_().field_73012_v.nextFloat() * animal.field_70130_N * 2.0f) - (double)animal.field_70130_N, animal.field_70163_u + 0.5 + (double)(animal.func_130014_f_().field_73012_v.nextFloat() * animal.field_70131_O), animal.field_70161_v + (double)(animal.func_130014_f_().field_73012_v.nextFloat() * animal.field_70130_N * 2.0f) - (double)animal.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    @SubscribeEvent
    public void afterWarpDimEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        ItemStack charm;
        EntityPlayer player = event.player;
        if (player != null && !DCUtil.isEmpty((ItemStack)(charm = MainUtil.getCharmItem((EntityLivingBase)player, new ItemStack(MagicInit.colorBadge, 1, 1))))) {
            int dim = player.field_70170_p.field_73011_w.getDimension();
            String dimName = player.field_70170_p.field_73011_w.func_186058_p().func_186065_b();
            int x = MathHelper.func_76128_c((double)player.field_70165_t);
            int y = MathHelper.func_76128_c((double)player.field_70163_u);
            int z = MathHelper.func_76128_c((double)player.field_70161_v);
            NBTTagCompound tag = charm.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            tag.func_74778_a("dcs.portal.dimname", dimName);
            tag.func_74768_a("dcs.portal.dim", dim);
            tag.func_74768_a("dcs.portal.x", x);
            tag.func_74768_a("dcs.portal.y", y);
            tag.func_74768_a("dcs.portal.z", z);
            charm.func_77982_d(tag);
        }
    }

    @SubscribeEvent
    public void onDrop(LivingDropsEvent event) {
        EntityLivingBase living = event.getEntityLiving();
        DamageSource source = event.getSource();
        int level = event.getLootingLevel();
        if (living == null) {
            return;
        }
        if (!living.field_70170_p.field_72995_K) {
            ItemStack head;
            int lu1 = 0;
            int lb2 = 0;
            boolean blue = false;
            if (!(source.func_76346_g() instanceof EntityLivingBase)) {
                return;
            }
            EntityLivingBase liv2 = (EntityLivingBase)source.func_76346_g();
            int eff = MathHelper.func_76141_d((float)(MainUtil.magicSuitEff(liv2) * 2.0f)) - 1;
            lu1 = MainUtil.getCharmLevel(liv2, new ItemStack(MagicInit.colorRing, 1, 0)) * eff;
            lb2 = MainUtil.getCharmLevel(liv2, new ItemStack(MagicInit.colorRing2, 1, 3)) * eff;
            blue = MagicCommonEvent.getOffhandJewelColor(liv2) == MagicColor.BLUE;
            int m = 1 + (lu1 + level) * 5;
            if (living.field_70170_p.field_73012_v.nextInt(100) < m) {
                int meta = MagicCommonEvent.getDropMeta(living);
                ItemStack item1 = new ItemStack(MagicInit.colorDrop, 1, meta);
                EntityItem drop = new EntityItem(living.field_70170_p, living.field_70165_t, living.field_70163_u, living.field_70161_v, item1);
                event.getDrops().add(drop);
            }
            int m2 = lb2 * 10;
            if (living.field_70170_p.field_73012_v.nextInt(100) < m2 && !event.getDrops().isEmpty()) {
                int i = event.getDrops().size();
                int i2 = living.field_70170_p.field_73012_v.nextInt(i);
                ((EntityItem)event.getDrops().get(i2)).func_92059_d().func_190917_f(1);
            }
            if (blue && living.field_70170_p.field_73012_v.nextInt(100) < 25 && !(head = MagicCommonEvent.getDropSkull(living)).func_190926_b()) {
                EntityItem drop2 = new EntityItem(living.field_70170_p, living.field_70165_t, living.field_70163_u, living.field_70161_v, head);
                event.getDrops().add(drop2);
            }
        }
    }

    @SubscribeEvent
    public void onBlockDrop(BlockEvent.HarvestDropsEvent event) {
        if (event.getHarvester() != null) {
            if (MagicCommonEvent.getOffhandJewelColor((EntityLivingBase)event.getHarvester()) == MagicColor.BLACK) {
                ItemStack off = event.getHarvester().func_184586_b(EnumHand.OFF_HAND);
                float eff = MainUtil.magicSuitEff((EntityLivingBase)event.getHarvester());
                ArrayList nList = Lists.newArrayList();
                boolean flag = false;
                for (ItemStack i : event.getDrops()) {
                    if (DCUtil.isEmpty((ItemStack)i)) continue;
                    ICrusherRecipe cr = null;
                    if (eff >= 2.0f && ModuleConfig.machine_advanced) {
                        cr = RecipeAPI.registerCrushers.getRecipe(i, new ItemStack(MachineInit.rotaryBlade));
                        ICrusherRecipe cr2 = RecipeAPI.registerCrushers.getRecipe(i, new ItemStack(MachineInit.rotaryBlade, 1, 1));
                        if (cr2 != null) {
                            cr = cr2;
                        }
                    }
                    if (cr != null) {
                        ItemStack o3;
                        ItemStack o2;
                        ItemStack o1 = cr.getOutput();
                        if (!DCUtil.isEmpty((ItemStack)o1)) {
                            nList.add(o1);
                        }
                        if (!DCUtil.isEmpty((ItemStack)(o2 = cr.getSecondary())) && event.getWorld().field_73012_v.nextFloat() < cr.getSecondaryChance() * eff) {
                            nList.add(o2);
                        }
                        if (!DCUtil.isEmpty((ItemStack)(o3 = cr.getSecondary())) && event.getWorld().field_73012_v.nextFloat() < cr.getTertialyChance() * eff) {
                            nList.add(o3);
                        }
                        flag = true;
                        continue;
                    }
                    IMillRecipe recipe = RecipeAPI.registerMills.getRecipe(i);
                    if (recipe != null) {
                        ItemStack o2;
                        ItemStack o1 = recipe.getOutput();
                        if (!DCUtil.isEmpty((ItemStack)o1)) {
                            nList.add(o1);
                        }
                        if (!DCUtil.isEmpty((ItemStack)(o2 = recipe.getSecondary())) && event.getWorld().field_73012_v.nextFloat() < recipe.getSecondaryChance() * eff) {
                            nList.add(o2);
                        }
                        flag = true;
                        continue;
                    }
                    nList.add(i.func_77946_l());
                }
                event.getDrops().clear();
                event.getDrops().addAll(nList);
            }
            if (DCUtil.hasCharmItem((EntityLivingBase)event.getHarvester(), (ItemStack)new ItemStack(MagicInit.colorPendant2, 1, 2))) {
                ArrayList nList = Lists.newArrayList();
                for (ItemStack i : event.getDrops()) {
                    if (DCUtil.isEmpty((ItemStack)i)) continue;
                    ItemStack burnt = FurnaceRecipes.func_77602_a().func_151395_a(i);
                    if (burnt.func_190926_b()) {
                        nList.add(i.func_77946_l());
                        continue;
                    }
                    int d = burnt.func_190916_E() * i.func_190916_E();
                    burnt.func_190920_e(d);
                    nList.add(burnt.func_77946_l());
                }
                event.getDrops().clear();
                event.getDrops().addAll(nList);
            }
        }
    }

    static int getDropMeta(EntityLivingBase living) {
        if (living.func_70668_bt() == EnumCreatureAttribute.ILLAGER || living instanceof EntityEnderman || living instanceof EntityVillager) {
            return 4;
        }
        if (living.func_70662_br() || living.func_70668_bt() == EnumCreatureAttribute.UNDEAD) {
            return 3;
        }
        if (living instanceof EntityCreeper || living.field_70178_ae) {
            return 2;
        }
        if (living instanceof EntitySlime || living instanceof EntityGuardian || living instanceof EntityShulker) {
            return 0;
        }
        return 1;
    }

    static ItemStack getDropSkull(EntityLivingBase living) {
        if (living instanceof EntityWitherSkeleton) {
            return new ItemStack(Items.field_151144_bL, 1, 1);
        }
        if (living instanceof EntitySkeleton) {
            return new ItemStack(Items.field_151144_bL, 1, 0);
        }
        if (living instanceof EntityZombie) {
            return new ItemStack(Items.field_151144_bL, 1, 2);
        }
        if (living instanceof EntityCreeper) {
            return new ItemStack(Items.field_151144_bL, 1, 4);
        }
        return ItemStack.field_190927_a;
    }

    @SubscribeEvent
    public void onLeftClick(PlayerInteractEvent.LeftClickEmpty event) {
        EntityPlayer player = event.getEntityPlayer();
        if (ClimateCore.isDebug && player != null && player.func_70051_ag() && MagicCommonEvent.getOffhandJewelColor(event.getEntityLiving()) == MagicColor.BLUE && event.getItemStack().func_77973_b() instanceof ItemScytheDC) {
            double x = player.func_189651_aD().field_72450_a * 0.5 + player.field_70159_w;
            double y = 0.05;
            double z = player.func_189651_aD().field_72449_c * 0.5 + player.field_70179_y;
            player.field_70159_w = x;
            player.field_70181_x = y;
            player.field_70179_y = z;
        }
    }

    @SubscribeEvent
    public void onCrit(CriticalHitEvent event) {
        if (MagicCommonEvent.getOffhandJewelColor((EntityLivingBase)event.getEntityPlayer()) == MagicColor.BLUE && event.getEntityPlayer().func_184614_ca().func_77973_b() instanceof ItemScytheDC) {
            event.setDamageModifier(1.8f);
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void onLiving(LivingEvent.LivingUpdateEvent event) {
        if (MagicCommonEvent.getOffhandJewelColor(event.getEntityLiving()) == MagicColor.RED) {
            if (event.getEntityLiving().field_70123_F) {
                event.getEntityLiving().field_70181_x = 0.2;
            } else if (this.isCollidedBlock(event.getEntityLiving()) && event.getEntityLiving().func_70093_af()) {
                event.getEntityLiving().field_70181_x = 0.0;
                event.getEntityLiving().field_70159_w *= 0.5;
                event.getEntityLiving().field_70179_y *= 0.5;
            }
            event.getEntityLiving().field_70143_R = 0.0f;
        } else if (MagicCommonEvent.getOffhandJewelColor(event.getEntityLiving()) == MagicColor.WHITE && event.getEntityLiving().func_70093_af() && event.getEntityLiving().func_184207_aI()) {
            event.getEntityLiving().func_184226_ay();
        }
        if (event.getEntityLiving() != null && !event.getEntityLiving().field_70170_p.field_72995_K) {
            BlockPos pos = event.getEntityLiving().func_180425_c();
            int cx = pos.func_177958_n() >> 4;
            int cz = pos.func_177952_p() >> 4;
            ChunkPos chunk = new ChunkPos(cx, cz);
            if (PictureList.hasColor(chunk, MagicColor.GREEN) && event.getEntityLiving() instanceof EntityPlayer) {
                event.getEntityLiving().func_70690_d(new PotionEffect(MainInit.bird, 205, 0));
            }
            if (PictureList.hasColor(chunk, MagicColor.RED) && !(event.getEntityLiving() instanceof IMob)) {
                event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_76422_e, 205, 0));
                event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_76429_m, 205, 0));
                event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_76420_g, 205, 0));
            }
            if (event.getEntityLiving() instanceof IMob && event.getEntityLiving().func_184216_O().contains("blackdog")) {
                EntityBlackDog dog = new EntityBlackDog(event.getEntityLiving().func_130014_f_());
                dog.func_82149_j((Entity)event.getEntityLiving());
                event.getEntityLiving().func_130014_f_().func_72838_d((Entity)dog);
                event.getEntityLiving().func_70106_y();
            }
            if (event.getEntityLiving() instanceof EntityPlayer) {
                if (this.count < 0) {
                    PictureList.checkList(event.getEntityLiving().func_130014_f_());
                }
                this.count = 60;
            } else {
                --this.count;
            }
        }
    }

    boolean isCollidedBlock(EntityLivingBase living) {
        World world = living.func_130014_f_();
        EnumFacing f = living.func_174811_aO();
        AxisAlignedBB bb = living.func_174813_aQ().func_72314_b(0.1, 0.0, 0.1);
        return !world.func_184144_a((Entity)living, bb).isEmpty();
    }

    public static MagicColor getOffhandJewelColor(EntityLivingBase player) {
        if (player == null || DCUtil.isEmpty((ItemStack)player.func_184586_b(EnumHand.OFF_HAND))) {
            return MagicColor.NONE;
        }
        ItemStack held = player.func_184586_b(EnumHand.OFF_HAND);
        if (held.func_77973_b() instanceof IJewel) {
            return ((IJewel)held.func_77973_b()).getColor(held.func_77952_i());
        }
        return MagicColor.NONE;
    }

    /*
     * Enabled aggressive block sorting
     */
    @SubscribeEvent
    public void onSpawn(LivingSpawnEvent.CheckSpawn event) {
        EntityLivingBase living = event.getEntityLiving();
        if (!(living instanceof IMob)) return;
        int cx = (int)event.getX() >> 4;
        int cz = (int)event.getZ() >> 4;
        ChunkPos chunk = new ChunkPos(cx, cz);
        if (!event.getEntityLiving().func_130014_f_().func_72935_r() && !event.getEntityLiving().func_70090_H()) {
            if (PictureList.hasColor(chunk, MagicColor.BLACK)) {
                if (event.getWorld().field_73012_v.nextInt(100) >= 50 && !(event.getEntityLiving() instanceof EntityCreeper)) {
                    event.setResult(Event.Result.DENY);
                    return;
                }
                event.getEntityLiving().func_184211_a("blackdog");
                return;
            }
        }
        if (!PictureList.hasColor(chunk, MagicColor.WHITE)) return;
        event.setResult(Event.Result.DENY);
    }

    @SubscribeEvent
    public void onCalcClimate(ClimateCalculateEvent event) {
        IClimate old;
        BlockPos pos = event.getPos();
        int cx = pos.func_177958_n() >> 4;
        int cz = pos.func_177952_p() >> 4;
        ChunkPos chunk = new ChunkPos(cx, cz);
        if (PictureList.hasColor(chunk, MagicColor.GREEN) && (old = event.currentClimate()).getAirflow() != DCAirflow.TIGHT) {
            event.setNewClimate(old.addAirTier(1));
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void onBiomeTemp(WorldHeatTierEvent event) {
        BlockPos pos = event.getPos();
        int cx = pos.func_177958_n() >> 4;
        int cz = pos.func_177952_p() >> 4;
        ChunkPos chunk = new ChunkPos(cx, cz);
        if (PictureList.hasColor(chunk, MagicColor.BLUE)) {
            DCHeatTier old = event.currentClimate();
            event.setNewClimate(old.addTier(4));
            event.setResult(Event.Result.ALLOW);
        }
    }
}

