/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.magic.item;

import defeatedcrow.hac.api.magic.CharmType;
import defeatedcrow.hac.api.magic.IJewel;
import defeatedcrow.hac.api.magic.MagicColor;
import defeatedcrow.hac.api.magic.MagicType;
import defeatedcrow.hac.core.base.ITexturePath;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.magic.MagicInit;
import defeatedcrow.hac.main.ClimateMain;
import defeatedcrow.hac.main.MainInit;
import defeatedcrow.hac.main.util.DCMaterialEnum;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemArmorGemBoots
extends ItemArmor
implements ITexturePath,
IJewel {
    private final String tex;
    private final DCMaterialEnum material;

    public ItemArmorGemBoots(ItemArmor.ArmorMaterial m, DCMaterialEnum mat, EntityEquipmentSlot slot, String t) {
        super(m, 2, slot);
        this.material = mat;
        this.tex = t;
    }

    public String getTexPath(int meta, boolean isFull) {
        return "dcs_climate:items/equip/boots_gem_" + this.tex;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "dcs_climate:textures/models/armor/gemboots_" + this.tex + "_layer_2.png";
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        ModelBiped next = ClimateMain.proxy.getArmorModel(8);
        if (next != null) {
            next.func_178686_a((ModelBase)_default);
            return next;
        }
        return _default;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        if (!world.field_72995_K && !DCUtil.isEmpty((ItemStack)stack) && player != null) {
            if (stack.func_77973_b() == MagicInit.gemBootsBird && !player.func_70644_a(MainInit.bird)) {
                player.func_70690_d(new PotionEffect(MainInit.bird, 600, 0));
            } else if (stack.func_77973_b() == MagicInit.gemBootsFish && !player.func_70644_a(MainInit.ocean)) {
                player.func_70690_d(new PotionEffect(MainInit.ocean, 600, 0));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flagIn) {
        if (!DCUtil.isEmpty((ItemStack)stack)) {
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Tips ===");
            if (stack.func_77973_b() == MagicInit.gemBootsBird) {
                tooltip.add(I18n.func_135052_a((String)"dcs.potion.bird", (Object[])new Object[0]));
            } else if (stack.func_77973_b() == MagicInit.gemBootsFish) {
                tooltip.add(I18n.func_135052_a((String)"dcs.potion.ocean", (Object[])new Object[0]));
            }
        }
    }

    public CharmType getCharmType(int meta) {
        return CharmType.CONSTANT;
    }

    public MagicType getType(int meta) {
        return MagicType.ARMOR;
    }

    public MagicColor getColor(int meta) {
        if (this == MagicInit.gemBootsBird) {
            return MagicColor.WHITE;
        }
        if (this == MagicInit.gemBootsFish) {
            return MagicColor.BLUE;
        }
        return MagicColor.NONE;
    }
}

