/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.magic.item;

import defeatedcrow.hac.api.climate.BlockSet;
import defeatedcrow.hac.api.magic.CharmType;
import defeatedcrow.hac.api.magic.MagicColor;
import defeatedcrow.hac.api.magic.MagicType;
import defeatedcrow.hac.core.ClimateCore;
import defeatedcrow.hac.core.plugin.baubles.CharmItemBase;
import defeatedcrow.hac.core.util.DCTimeHelper;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.main.config.MainCoreConfig;
import defeatedcrow.hac.main.packet.DCMainPacket;
import defeatedcrow.hac.main.packet.MessageMagicParticle;
import defeatedcrow.hac.main.util.MainUtil;
import defeatedcrow.hac.main.util.portal.DCDimChangeHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemColorBadge
extends CharmItemBase {
    private final int maxMeta;
    private static String[] names = new String[]{"u1", "g1", "r1", "b1", "w1"};

    public ItemColorBadge() {
        this.maxMeta = 4;
        this.func_77625_d(1);
    }

    public int getMaxMeta() {
        return this.maxMeta;
    }

    public String[] getNameSuffix() {
        return names;
    }

    public String getTexPath(int meta, boolean f) {
        String s = "items/magic/badge_" + names[meta];
        if (f) {
            s = "textures/" + s;
        }
        return "dcs_climate:" + s;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }

    public CharmType getCharmType(int meta) {
        switch (meta) {
            case 0: {
                return CharmType.KEY;
            }
            case 1: {
                return CharmType.SPECIAL;
            }
            case 2: {
                return CharmType.TOOL;
            }
            case 3: {
                return CharmType.SPECIAL;
            }
            case 4: {
                return CharmType.CONSTANT;
            }
        }
        return CharmType.SPECIAL;
    }

    public MagicType getType(int meta) {
        return MagicType.BADGE;
    }

    public MagicColor getColor(int meta) {
        switch (meta) {
            case 0: {
                return MagicColor.BLUE;
            }
            case 1: {
                return MagicColor.GREEN;
            }
            case 2: {
                return MagicColor.RED;
            }
            case 3: {
                return MagicColor.BLACK;
            }
            case 4: {
                return MagicColor.WHITE;
            }
        }
        return MagicColor.NONE;
    }

    public float reduceDamage(DamageSource source, ItemStack charm) {
        return 0.0f;
    }

    public boolean onDiffence(DamageSource source, EntityLivingBase owner, float damage, ItemStack charm) {
        return false;
    }

    public float increaceDamage(EntityLivingBase target, DamageSource source, ItemStack charm) {
        return 1.0f;
    }

    public boolean onAttacking(EntityLivingBase owner, EntityLivingBase target, DamageSource source, float damage, ItemStack charm) {
        return false;
    }

    public boolean onPlayerAttacking(EntityPlayer owner, EntityLivingBase target, DamageSource source, float damage, ItemStack charm) {
        return false;
    }

    public boolean onToolUsing(EntityLivingBase owner, BlockPos pos, IBlockState state, ItemStack charm) {
        if (this.getColor(charm.func_77952_i()) == MagicColor.RED && owner instanceof EntityPlayer && owner.func_70093_af()) {
            EntityPlayer player = (EntityPlayer)owner;
            if (!player.field_70170_p.field_72995_K && state != null) {
                int c = 1 + charm.func_190916_E() * 3;
                c = MathHelper.func_76141_d((float)(MainUtil.magicSuitEff(owner) * (float)c));
                BlockSet set = new BlockSet(state.func_177230_c(), state.func_177230_c().func_176201_c(state));
                if (MainCoreConfig.disables.contains(set)) {
                    return false;
                }
                ItemStack hold = player.func_184614_ca();
                BlockPos min = pos.func_177982_a(-c, -c, -c);
                BlockPos max = pos.func_177982_a(c, c, c);
                Iterable itr = BlockPos.func_177980_a((BlockPos)min, (BlockPos)max);
                boolean flag = false;
                for (BlockPos p : itr) {
                    IBlockState target;
                    if (p.func_177956_o() < 0 || p.func_177956_o() > 255 || p.equals((Object)pos) || !player.func_175151_a(p, EnumFacing.UP, charm) || (target = player.field_70170_p.func_180495_p(p)) == null || !target.func_177230_c().canHarvestBlock((IBlockAccess)player.field_70170_p, p, player) || !target.equals(state) || target.func_177230_c().func_176201_c(target) != state.func_177230_c().func_176201_c(state) || target.func_177230_c().hasTileEntity(target)) continue;
                    target.func_177230_c().func_180657_a(player.field_70170_p, player, p, target, null, hold);
                    player.field_70170_p.func_175698_g(p);
                }
            }
        }
        return false;
    }

    public void constantEffect(EntityLivingBase owner, ItemStack charm) {
        ItemStack off;
        if (this.getColor(charm.func_77952_i()) == MagicColor.WHITE && !DCUtil.isEmpty((ItemStack)(off = owner.func_184592_cb())) && off.func_77973_b().func_77645_m()) {
            int dam;
            int i;
            long time = DCTimeHelper.time((World)owner.field_70170_p);
            int f = MathHelper.func_76123_f((float)(MainUtil.magicSuitEff(owner) * (float)charm.func_190916_E() * 2.0f));
            if (f > 16) {
                f = 16;
            }
            if ((time & (long)(i = 128 / f - 1)) == 0L && (dam = off.func_77952_i()) > 0) {
                off.func_77964_b(dam -= charm.func_190916_E());
            }
        }
    }

    public boolean onUsing(EntityPlayer owner, ItemStack charm) {
        if (this.getColor(charm.func_77952_i()) == MagicColor.BLUE && !owner.field_70170_p.field_72995_K && owner.field_70170_p instanceof WorldServer) {
            DCMainPacket.INSTANCE.sendToAll((IMessage)new MessageMagicParticle(owner.field_70165_t, owner.field_70163_u, owner.field_70161_v));
            int dim = owner.field_70170_p.field_73011_w.getDimension();
            NBTTagCompound tag = charm.func_77978_p();
            if (tag != null && tag.func_74764_b("dcs.charm.dim")) {
                int warpDim = tag.func_74762_e("dcs.charm.dim");
                double x = tag.func_74762_e("dcs.charm.x");
                double y = tag.func_74762_e("dcs.charm.y");
                double z = tag.func_74762_e("dcs.charm.z");
                BlockPos pos = new BlockPos(x, y, z);
                if (warpDim != dim) {
                    DCDimChangeHelper.addCoord(owner, warpDim, pos);
                } else {
                    owner.func_70634_a(x + 0.5, y + 0.5, z + 0.5);
                    owner.field_70143_R = 0.0f;
                }
            }
        }
        return false;
    }

    public EnumActionResult onItemUse2(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player != null) {
            ItemStack stack = player.func_184586_b(hand);
            if (!world.func_175623_d(pos) && !DCUtil.isEmpty((ItemStack)stack) && stack.func_77973_b() == this) {
                int meta = stack.func_77960_j();
                if (!world.field_72995_K && meta == 0 && pos.func_177956_o() > 0 && pos.func_177956_o() < 254 && world.func_175623_d(pos.func_177984_a()) && world.func_175623_d(pos.func_177981_b(2))) {
                    NBTTagCompound tag = stack.func_77978_p();
                    if (tag == null) {
                        tag = new NBTTagCompound();
                    }
                    String dimName = world.field_73011_w.func_186058_p().func_186065_b();
                    int dim = world.field_73011_w.getDimension();
                    int x = pos.func_177958_n();
                    int y = pos.func_177956_o() + 1;
                    int z = pos.func_177952_p();
                    tag.func_74778_a("dcs.charm.dimname", dimName);
                    tag.func_74768_a("dcs.charm.dim", dim);
                    tag.func_74768_a("dcs.charm.x", x);
                    tag.func_74768_a("dcs.charm.y", y);
                    tag.func_74768_a("dcs.charm.z", z);
                    stack.func_77982_d(tag);
                    return EnumActionResult.SUCCESS;
                }
            }
        }
        return EnumActionResult.PASS;
    }

    public boolean isActive(ItemStack charm) {
        return true;
    }

    public void setActive(ItemStack charm, boolean flag) {
    }

    public ItemStack consumeCharmItem(ItemStack stack) {
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation2(ItemStack stack, @Nullable World world, List<String> tooltip) {
        int z;
        int y;
        int x;
        String warpDim;
        String s = "";
        int meta = stack.func_77960_j();
        if (meta == 0 || meta == 2) {
            tooltip.add(TextFormatting.BOLD.toString() + "PLAYER ONLY");
        }
        tooltip.add(TextFormatting.AQUA.toString() + I18n.func_135052_a((String)("dcs.tip.color_badge." + meta), (Object[])new Object[0]));
        if (ClimateCore.proxy.isShiftKeyDown()) {
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Tips ===");
            tooltip.add(I18n.func_135052_a((String)"dcs.tip.allcharm", (Object[])new Object[0]));
            tooltip.add(TextFormatting.YELLOW.toString() + I18n.func_135052_a((String)("dcs.comment.color_badge." + meta), (Object[])new Object[0]));
        } else {
            tooltip.add(TextFormatting.RESET.toString() + I18n.func_135052_a((String)"dcs.tip.shift", (Object[])new Object[0]));
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && tag.func_74764_b("dcs.charm.dim")) {
            warpDim = tag.func_74779_i("dcs.charm.dimname");
            x = tag.func_74762_e("dcs.charm.x");
            y = tag.func_74762_e("dcs.charm.y");
            z = tag.func_74762_e("dcs.charm.z");
            tooltip.add(TextFormatting.RESET + "Registered Coord");
            tooltip.add(TextFormatting.RESET + warpDim + ", " + x + ", " + y + ", " + z);
        }
        if (tag != null && tag.func_74764_b("dcs.portal.dim")) {
            warpDim = tag.func_74779_i("dcs.portal.dimname");
            x = tag.func_74762_e("dcs.portal.x");
            y = tag.func_74762_e("dcs.portal.y");
            z = tag.func_74762_e("dcs.portal.z");
            tooltip.add(TextFormatting.RESET + "Last Portal Coord");
            tooltip.add(TextFormatting.RESET + warpDim + ", " + x + ", " + y + ", " + z);
        }
    }

    public static enum DropType {
        NORMAL,
        SILK,
        SMELTING;

    }
}

