/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.magic.item;

import com.google.common.collect.Lists;
import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.api.magic.MagicColor;
import defeatedcrow.hac.core.base.DCItem;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.magic.MagicInit;
import defeatedcrow.hac.magic.proj.EntityFireBarrier;
import defeatedcrow.hac.magic.proj.EntityHealBarrier;
import defeatedcrow.hac.magic.proj.EntityMobBarrier;
import defeatedcrow.hac.magic.proj.EntityProjBarrier;
import defeatedcrow.hac.magic.proj.EntityProjBlackSpit;
import defeatedcrow.hac.magic.proj.EntityProjRedSpit;
import defeatedcrow.hac.main.MainInit;
import defeatedcrow.hac.main.packet.DCMainPacket;
import defeatedcrow.hac.main.packet.MessageMagicParticle;
import defeatedcrow.hac.main.util.EntitySelectorsDC;
import defeatedcrow.hac.main.util.MainUtil;
import defeatedcrow.hac.main.worldgen.vein.OreGenPos;
import defeatedcrow.hac.main.worldgen.vein.WorldGenOres;
import defeatedcrow.hac.main.worldgen.vein.WorldGenSkarn;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemColorCard
extends DCItem {
    private final int maxMeta;
    private static String[] names = new String[]{"u1", "g1", "r1", "b1", "w1", "u2", "g2", "r2", "b2", "w2", "u3", "g3", "r3", "b3", "w3"};

    public ItemColorCard() {
        this.maxMeta = 14;
    }

    public int getMaxMeta() {
        return this.maxMeta;
    }

    public String[] getNameSuffix() {
        return names;
    }

    public String getTexPath(int meta, boolean f) {
        String s = "items/magic/card_" + names[meta];
        if (f) {
            s = "textures/" + s;
        }
        return "dcs_climate:" + s;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return stack.func_77952_i() > 9 ? EnumRarity.RARE : (stack.func_77952_i() > 4 ? EnumRarity.UNCOMMON : EnumRarity.COMMON);
    }

    public MagicColor getColor(int meta) {
        switch (meta) {
            case 0: 
            case 5: 
            case 10: {
                return MagicColor.BLUE;
            }
            case 1: 
            case 6: 
            case 11: {
                return MagicColor.GREEN;
            }
            case 2: 
            case 7: 
            case 12: {
                return MagicColor.RED;
            }
            case 3: 
            case 8: 
            case 13: {
                return MagicColor.BLACK;
            }
            case 4: 
            case 9: 
            case 14: {
                return MagicColor.WHITE;
            }
        }
        return MagicColor.NONE;
    }

    public EnumActionResult onItemUse2(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.FAIL;
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase living, int timeLeft) {
        if (stack != null && living instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)living;
            boolean flag = !player.field_71075_bZ.field_75098_d;
            int meta = stack.func_77952_i();
            if (!world.field_72995_K) {
                float f = MainUtil.magicSuitEff((EntityLivingBase)player);
                switch (meta) {
                    case 0: {
                        this.onEffect_Blue1(world, player, f);
                        break;
                    }
                    case 1: {
                        this.onEffect_Green1(world, player, f);
                        break;
                    }
                    case 2: {
                        this.onEffect_Red1(world, player, f);
                        break;
                    }
                    case 3: {
                        this.onEffect_Black1(world, player, f);
                        break;
                    }
                    case 4: {
                        this.onEffect_White1(world, player, f);
                        break;
                    }
                    case 5: {
                        this.onEffect_Blue2(world, player, f);
                        break;
                    }
                    case 6: {
                        this.onEffect_Green2(world, player, f);
                        break;
                    }
                    case 7: {
                        this.onEffect_Red2(world, player, f);
                        break;
                    }
                    case 8: {
                        this.onEffect_Black2(world, player, f);
                        break;
                    }
                    case 9: {
                        this.onEffect_White2(world, player, f);
                        break;
                    }
                    case 10: {
                        this.onEffect_Blue3(world, player, f);
                        break;
                    }
                    case 11: {
                        this.onEffect_Green3(world, player, f);
                        break;
                    }
                    case 12: {
                        this.onEffect_Red3(world, player, f);
                        break;
                    }
                    case 13: {
                        this.onEffect_Black3(world, player, f);
                        break;
                    }
                    case 14: {
                        this.onEffect_White3(world, player, f);
                        break;
                    }
                    default: {
                        this.onEffect_Green1(world, player, f);
                    }
                }
                DCMainPacket.INSTANCE.sendToAll((IMessage)new MessageMagicParticle(living.field_70165_t, living.field_70163_u, living.field_70161_v));
            }
            world.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187802_ec, SoundCategory.NEUTRAL, 0.8f, 1.5f);
            if (flag) {
                DCUtil.reduceStackSize((ItemStack)stack, (int)1);
            }
            player.func_71029_a(StatList.func_188057_b((Item)this));
        }
    }

    private boolean onEffect_Blue1(World world, EntityPlayer player, float f) {
        int dim = world.field_73011_w.getDimension();
        player.func_180473_a(player.func_180425_c(), false);
        if (player.getBedLocation(dim) != null) {
            BlockPos pos = player.getBedLocation(dim);
            player.func_145747_a((ITextComponent)new TextComponentString("New Respawn Point: " + pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p()));
            return true;
        }
        return false;
    }

    private boolean onEffect_Green1(World world, EntityPlayer player, float f) {
        BlockPos pos = player.func_180425_c();
        int r = MathHelper.func_76141_d((float)(4.0f * f));
        Iterable itr = BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-r, -1, -r), (BlockPos)pos.func_177982_a(r, 3, r));
        for (BlockPos p1 : itr) {
            IGrowable pl;
            IBlockState st = world.func_180495_p(p1);
            int meta = st.func_177230_c().func_176201_c(st);
            if (world.func_175623_d(p1) || st.func_177230_c() == Blocks.field_150346_d || st.func_177230_c() == Blocks.field_150349_c || !(st.func_177230_c() instanceof IGrowable) || !(pl = (IGrowable)st.func_177230_c()).func_180670_a(world, world.field_73012_v, p1, st) || !pl.func_176473_a(world, p1, st, false)) continue;
            pl.func_176474_b(world, world.field_73012_v, p1, st);
            if (!(world instanceof WorldServer)) continue;
            ((WorldServer)world).func_175739_a(EnumParticleTypes.VILLAGER_HAPPY, (double)p1.func_177958_n() + 0.5, (double)p1.func_177956_o() + 0.5, (double)p1.func_177952_p() + 0.5, 8, 0.5, 0.5, 0.5, 0.5, new int[0]);
        }
        return true;
    }

    private boolean onEffect_Red1(World world, EntityPlayer player, float f) {
        int r = MathHelper.func_76141_d((float)(6000.0f * f));
        int amp = MathHelper.func_76141_d((float)(2.0f * f));
        player.func_70690_d(new PotionEffect(MobEffects.field_76420_g, r, --amp));
        player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, r, amp));
        player.func_70690_d(new PotionEffect(MobEffects.field_76422_e, r, amp));
        return true;
    }

    private boolean onEffect_Black1(World world, EntityPlayer player, float f) {
        int r = MathHelper.func_76141_d((float)(16.0f * f));
        AxisAlignedBB aabb = new AxisAlignedBB(player.field_70165_t - (double)r, player.field_70163_u - 2.0, player.field_70161_v - (double)r, player.field_70165_t + (double)r, player.field_70163_u + 2.0, player.field_70161_v + (double)r);
        List list = player.field_70170_p.func_175647_a(EntityLiving.class, aabb, EntitySelectorsDC.NOT_TAMED);
        if (list.isEmpty() || list.size() < 2) {
            return false;
        }
        EntityLivingBase t1 = null;
        EntityLivingBase t2 = null;
        for (int i = 0; i < list.size(); ++i) {
            t1 = (EntityLivingBase)list.get(i);
            EntityLivingBase entityLivingBase = t2 = i == list.size() - 1 ? (EntityLivingBase)list.get(0) : (EntityLivingBase)list.get(i + 1);
            if (t1 instanceof EntityLiving) {
                EntityLiving liv = (EntityLiving)t1;
                Set set = liv.field_70715_bh.field_75782_a;
                for (EntityAITasks.EntityAITaskEntry ai : set) {
                    if (ai == null || ai.field_75733_a == null || !(ai.field_75733_a instanceof EntityAITarget)) continue;
                    EntityAITarget tai = (EntityAITarget)ai.field_75733_a;
                    tai.func_75251_c();
                }
                liv.func_70624_b(null);
                liv.func_70624_b(t2);
            }
            t1.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)t2), 0.5f);
            DCMainPacket.INSTANCE.sendToAll((IMessage)new MessageMagicParticle(t1.field_70165_t, t1.field_70163_u, t1.field_70161_v));
        }
        return true;
    }

    private boolean onEffect_White1(World world, EntityPlayer player, float f) {
        IBlockState cur = player.field_70170_p.func_180495_p(player.func_180425_c().func_177984_a());
        IBlockState set = MainInit.lightOrb.func_176223_P();
        if (cur.func_185904_a().func_76222_j() && player.field_70170_p.func_175656_a(player.func_180425_c().func_177984_a(), set)) {
            return true;
        }
        return true;
    }

    private boolean onEffect_Blue2(World world, EntityPlayer player, float f) {
        int r = MathHelper.func_76141_d((float)(12000.0f * f));
        player.func_70690_d(new PotionEffect(MainInit.ocean, r, 0));
        return true;
    }

    private boolean onEffect_Green2(World world, EntityPlayer player, float f) {
        int x = MathHelper.func_76128_c((double)player.field_70165_t);
        int y = MathHelper.func_76128_c((double)player.field_70163_u);
        int z = MathHelper.func_76128_c((double)player.field_70161_v);
        BlockPos p = new BlockPos(x, y + 1, z);
        ChunkPos c = new ChunkPos(p);
        boolean b = false;
        if (!world.field_72995_K) {
            int r = MathHelper.func_76141_d((float)(f * 2.0f)) - 1;
            for (int x1 = -r; x1 <= r; ++x1) {
                for (int z1 = -r; z1 <= r; ++z1) {
                    OreGenPos.OreVein[] veins = OreGenPos.INSTANCE.getVeins(c.field_77276_a + x1, c.field_77275_b + z1, player.field_70170_p);
                    ArrayList list = Lists.newArrayList();
                    if (veins == null) continue;
                    for (OreGenPos.OreVein v : veins) {
                        BlockPos p1;
                        if (v == null || world.func_180495_p(v.pos).func_185904_a() != Material.field_151576_e && world.func_180495_p(v.pos).func_185904_a() != Material.field_151578_c) continue;
                        int i = 120;
                        if (world.field_73011_w.getHeight() <= 128) {
                            i = 64;
                        }
                        for (int j = 0; j < 64 && (world.func_175623_d(p1 = new BlockPos(v.pos.func_177958_n(), --i, v.pos.func_177952_p())) || world.func_180495_p(p1).func_177230_c() == MagicInit.veinBeacon); ++j) {
                        }
                        BlockPos p2 = new BlockPos(v.pos.func_177958_n(), i + 2, v.pos.func_177952_p());
                        if (!world.func_175667_e(p2) || world.func_175625_s(p2) != null) continue;
                        IBlockState state = MagicInit.veinBeacon.func_176223_P();
                        state = state.func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(v.type.id));
                        world.func_180501_a(p2, state, 3);
                        b = true;
                    }
                }
            }
            if (b) {
                player.func_145747_a((ITextComponent)new TextComponentString("== Ore vein has been detected! =="));
            } else {
                player.func_145747_a((ITextComponent)new TextComponentString("== No ore vein detected in this chank =="));
            }
        }
        return true;
    }

    private boolean onEffect_Red2(World world, EntityPlayer player, float f) {
        EntityProjRedSpit entityarrow = new EntityProjRedSpit(world, (EntityLivingBase)player);
        entityarrow.setExplodeRange(f * 2.0f);
        entityarrow.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 2.0f, 1.0f);
        world.func_72838_d((Entity)entityarrow);
        return true;
    }

    private boolean onEffect_Black2(World world, EntityPlayer player, float f) {
        EntityProjBlackSpit entityarrow = new EntityProjBlackSpit(world, (EntityLivingBase)player);
        entityarrow.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 2.0f, 1.0f);
        world.func_72838_d((Entity)entityarrow);
        return true;
    }

    private boolean onEffect_White2(World world, EntityPlayer player, float f) {
        int r = MathHelper.func_76141_d((float)(12000.0f * f));
        player.func_70690_d(new PotionEffect(MainInit.bird, r, 0));
        return true;
    }

    private boolean onEffect_Red3(World world, EntityPlayer player, float f) {
        EntityFireBarrier circle = new EntityFireBarrier(world);
        circle.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        world.func_72838_d((Entity)circle);
        return true;
    }

    private boolean onEffect_Blue3(World world, EntityPlayer player, float f) {
        EntityProjBarrier circle = new EntityProjBarrier(world);
        circle.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        world.func_72838_d((Entity)circle);
        return true;
    }

    private boolean onEffect_Green3(World world, EntityPlayer player, float f) {
        WorldGenOres gen = new WorldGenOres(true);
        WorldGenSkarn skarn = new WorldGenSkarn(false);
        int x = MathHelper.func_76128_c((double)player.field_70165_t);
        int y = MathHelper.func_76128_c((double)player.field_70163_u);
        int z = MathHelper.func_76128_c((double)player.field_70161_v);
        BlockPos p = new BlockPos(x, y + 1, z);
        ChunkPos c = new ChunkPos(p);
        int r = MathHelper.func_76141_d((float)f);
        for (int i = -r; i <= r; ++i) {
            for (int j = -r; j <= r; ++j) {
                gen.generate(world.field_73012_v, c.field_77276_a + i, c.field_77275_b + j, world, world.field_73011_w.func_186060_c(), world.func_72863_F());
                if (!(f > 0.0f)) continue;
                skarn.generate(world.field_73012_v, c.field_77276_a + i, c.field_77275_b + j, world, world.field_73011_w.func_186060_c(), world.func_72863_F());
            }
        }
        return true;
    }

    private boolean onEffect_Black3(World world, EntityPlayer player, float f) {
        EntityMobBarrier circle = new EntityMobBarrier(world);
        circle.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        world.func_72838_d((Entity)circle);
        return true;
    }

    private boolean onEffect_White3(World world, EntityPlayer player, float f) {
        EntityHealBarrier circle = new EntityHealBarrier(world);
        circle.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        world.func_72838_d((Entity)circle);
        return true;
    }

    public ActionResult<ItemStack> onItemRightClick2(World world, EntityPlayer player, EnumHand hand) {
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation2(ItemStack stack, @Nullable World world, List<String> tooltip) {
        String s = "";
        int meta = stack.func_77960_j();
        CardType type = CardType.getType(meta);
        tooltip.add(TextFormatting.BOLD.toString() + "PLAYER ONLY");
        tooltip.add(TextFormatting.AQUA.toString() + I18n.func_135052_a((String)("dcs.tip.card_type." + type.toString()), (Object[])new Object[0]));
        tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Tips ===");
        tooltip.add(TextFormatting.YELLOW.toString() + I18n.func_135052_a((String)("dcs.comment.card." + meta), (Object[])new Object[0]));
    }

    public static enum CardType {
        SELF_BUFF,
        PROJECTILE,
        AREA,
        CIRCLE;


        public static CardType getType(int meta) {
            switch (meta) {
                case 0: 
                case 2: 
                case 5: 
                case 9: {
                    return SELF_BUFF;
                }
                case 7: 
                case 8: {
                    return PROJECTILE;
                }
                case 1: 
                case 3: 
                case 4: 
                case 6: 
                case 11: {
                    return AREA;
                }
                case 10: 
                case 12: 
                case 13: 
                case 14: {
                    return CIRCLE;
                }
            }
            return SELF_BUFF;
        }
    }
}

