/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.magic.item;

import defeatedcrow.hac.api.magic.MagicColor;
import defeatedcrow.hac.core.base.DCItem;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.magic.MagicInit;
import defeatedcrow.hac.magic.block.TileCubeIce;
import defeatedcrow.hac.magic.entity.EntityFlowerTurret;
import defeatedcrow.hac.magic.entity.EntityMagicCushion;
import defeatedcrow.hac.main.MainInit;
import defeatedcrow.hac.main.packet.DCMainPacket;
import defeatedcrow.hac.main.packet.MessageMagicParticle;
import defeatedcrow.hac.main.util.EntitySelectorsDC;
import defeatedcrow.hac.main.util.MainUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemColorCard2
extends DCItem {
    private final int maxMeta;
    private static String[] names = new String[]{"ug2", "gb2", "ru2", "bw2", "wr2"};

    public ItemColorCard2() {
        this.maxMeta = 4;
    }

    public int getMaxMeta() {
        return this.maxMeta;
    }

    public String[] getNameSuffix() {
        return names;
    }

    public String getTexPath(int meta, boolean f) {
        String s = "items/magic/card_" + names[meta];
        if (f) {
            s = "textures/" + s;
        }
        return "dcs_climate:" + s;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.UNCOMMON;
    }

    public MagicColor getColor(int meta) {
        switch (meta) {
            case 0: {
                return MagicColor.BLUE;
            }
            case 1: {
                return MagicColor.GREEN;
            }
            case 2: {
                return MagicColor.RED;
            }
            case 3: {
                return MagicColor.BLACK;
            }
            case 4: {
                return MagicColor.WHITE;
            }
        }
        return MagicColor.NONE;
    }

    public EnumActionResult onItemUse2(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.FAIL;
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase living, int timeLeft) {
        if (stack != null && living instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)living;
            boolean flag = !player.field_71075_bZ.field_75098_d;
            int meta = stack.func_77952_i();
            if (!world.field_72995_K) {
                float f = MainUtil.magicSuitEff((EntityLivingBase)player);
                switch (meta) {
                    case 0: {
                        this.onEffect_UG1(world, player, f);
                        break;
                    }
                    case 1: {
                        this.onEffect_GB1(world, player, f);
                        break;
                    }
                    case 2: {
                        this.onEffect_RU1(world, player, f);
                        break;
                    }
                    case 3: {
                        this.onEffect_BW1(world, player, f);
                        break;
                    }
                    case 4: {
                        this.onEffect_WR1(world, player, f);
                        break;
                    }
                    default: {
                        this.onEffect_UG1(world, player, f);
                    }
                }
                DCMainPacket.INSTANCE.sendToAll((IMessage)new MessageMagicParticle(living.field_70165_t, living.field_70163_u, living.field_70161_v));
            }
            world.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187802_ec, SoundCategory.NEUTRAL, 0.8f, 1.5f);
            if (flag) {
                DCUtil.reduceStackSize((ItemStack)stack, (int)1);
            }
            player.func_71029_a(StatList.func_188057_b((Item)this));
        }
    }

    private boolean onEffect_UG1(World world, EntityPlayer player, float f) {
        EnumFacing playerFacing = player.func_174811_aO();
        BlockPos pos = player.func_180425_c().func_177972_a(playerFacing);
        IBlockState cur = player.field_70170_p.func_180495_p(pos);
        IBlockState set = MagicInit.clusterIce.func_176223_P();
        if (cur.func_185904_a().func_76222_j() && player.field_70170_p.func_175656_a(pos, set)) {
            return true;
        }
        TileEntity t = player.field_70170_p.func_175625_s(pos);
        if (t instanceof TileCubeIce) {
            ((TileCubeIce)t).setMaxTime((int)(1200.0f * f));
        }
        return false;
    }

    private boolean onEffect_GB1(World world, EntityPlayer player, float f) {
        EnumFacing playerFacing = player.func_174811_aO();
        BlockPos pos = player.func_180425_c().func_177972_a(playerFacing);
        BlockPos set = null;
        for (int i = -1; i < 2; ++i) {
            BlockPos p = pos.func_177981_b(i);
            IBlockState up = player.field_70170_p.func_180495_p(p);
            IBlockState down = player.field_70170_p.func_180495_p(p.func_177977_b());
            if (down.func_185890_d((IBlockAccess)world, p.func_177977_b()) == null || !up.func_185904_a().func_76222_j()) continue;
            set = p;
            break;
        }
        if (set != null) {
            EntityFlowerTurret flower = new EntityFlowerTurret(world);
            flower.func_70107_b((double)set.func_177958_n() + 0.5, set.func_177956_o(), (double)set.func_177952_p() + 0.5);
            flower.setTamedBy(player);
            if (!world.field_72995_K && world.func_72838_d((Entity)flower) && world instanceof WorldServer) {
                ((WorldServer)world).func_175739_a(EnumParticleTypes.VILLAGER_HAPPY, (double)set.func_177958_n() + 0.5, (double)set.func_177956_o() + 0.5, (double)set.func_177952_p() + 0.5, 8, 0.5, 0.5, 0.5, 0.5, new int[0]);
            }
        }
        return true;
    }

    private boolean onEffect_RU1(World world, EntityPlayer player, float f) {
        int r = MathHelper.func_76141_d((float)(16.0f + 8.0f * f));
        AxisAlignedBB aabb = new AxisAlignedBB(player.field_70165_t - (double)r, player.field_70163_u - 2.0, player.field_70161_v - (double)r, player.field_70165_t + (double)r, player.field_70163_u + 2.0, player.field_70161_v + (double)r);
        List list = player.field_70170_p.func_175647_a(EntityLivingBase.class, aabb, EntitySelectorsDC.NOT_TAMED);
        if (list.isEmpty()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            EntityLivingBase mob = (EntityLivingBase)list.get(i);
            if (mob.func_184218_aH() || !mob.func_70089_S()) continue;
            EntityMagicCushion cushion = new EntityMagicCushion(world);
            cushion.func_70107_b(mob.field_70165_t, mob.field_70163_u, mob.field_70161_v);
            cushion.setMaxLivingTime((int)(60.0f * f));
            if (world.field_72995_K || !world.func_72838_d((Entity)cushion)) continue;
            mob.func_184220_m((Entity)cushion);
        }
        player.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(player.field_70170_p, player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v, true));
        return true;
    }

    private boolean onEffect_BW1(World world, EntityPlayer player, float f) {
        int r = MathHelper.func_76141_d((float)(12000.0f * f));
        player.func_70690_d(new PotionEffect(MainInit.clairvoyance, r, 0));
        return true;
    }

    private boolean onEffect_WR1(World world, EntityPlayer player, float f) {
        EnumFacing playerFacing = player.func_174811_aO();
        BlockPos pos = player.func_180425_c().func_177972_a(playerFacing);
        IBlockState cur = player.field_70170_p.func_180495_p(pos);
        IBlockState set = MagicInit.infernalFlame.func_176223_P();
        if (cur.func_185904_a().func_76222_j() && player.field_70170_p.func_175656_a(pos, set)) {
            return true;
        }
        TileEntity t = player.field_70170_p.func_175625_s(pos);
        if (t instanceof TileCubeIce) {
            ((TileCubeIce)t).setMaxTime((int)(1200.0f * f));
        }
        return true;
    }

    public ActionResult<ItemStack> onItemRightClick2(World world, EntityPlayer player, EnumHand hand) {
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation2(ItemStack stack, @Nullable World world, List<String> tooltip) {
        String s = "";
        int meta = stack.func_77960_j();
        CardType type = CardType.getType(meta);
        tooltip.add(TextFormatting.BOLD.toString() + "PLAYER ONLY");
        tooltip.add(TextFormatting.AQUA.toString() + I18n.func_135052_a((String)("dcs.tip.card_type." + type.toString()), (Object[])new Object[0]));
        tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Tips ===");
        tooltip.add(TextFormatting.YELLOW.toString() + I18n.func_135052_a((String)("dcs.comment.card2." + meta), (Object[])new Object[0]));
    }

    public static enum CardType {
        SELF_BUFF,
        PROJECTILE,
        AREA,
        SPAWN;


        public static CardType getType(int meta) {
            switch (meta) {
                case 2: {
                    return AREA;
                }
                case 3: {
                    return SELF_BUFF;
                }
            }
            return SPAWN;
        }
    }
}

