/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.magic.item;

import defeatedcrow.hac.api.magic.CharmType;
import defeatedcrow.hac.api.magic.MagicColor;
import defeatedcrow.hac.api.magic.MagicType;
import defeatedcrow.hac.core.ClimateCore;
import defeatedcrow.hac.core.DCLogger;
import defeatedcrow.hac.core.plugin.baubles.CharmItemBase;
import defeatedcrow.hac.main.util.MainUtil;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemColorPendant2
extends CharmItemBase {
    private final int maxMeta;
    private static String[] names = new String[]{"u2", "g2", "r2", "b2", "w2"};

    public ItemColorPendant2() {
        this.maxMeta = 4;
        this.func_77625_d(1);
    }

    public int getMaxMeta() {
        return this.maxMeta;
    }

    public String[] getNameSuffix() {
        return names;
    }

    public CharmType getCharmType(int meta) {
        switch (meta) {
            case 0: {
                return CharmType.CONSTANT;
            }
            case 1: {
                return CharmType.TOOL;
            }
            case 2: {
                return CharmType.SPECIAL;
            }
            case 3: {
                return CharmType.ATTACK;
            }
            case 4: {
                return CharmType.DEFFENCE;
            }
        }
        return CharmType.SPECIAL;
    }

    public MagicType getType(int meta) {
        return MagicType.PENDANT;
    }

    public MagicColor getColor(int meta) {
        switch (meta) {
            case 0: {
                return MagicColor.BLUE;
            }
            case 1: {
                return MagicColor.GREEN;
            }
            case 2: {
                return MagicColor.RED;
            }
            case 3: {
                return MagicColor.BLACK;
            }
            case 4: {
                return MagicColor.WHITE;
            }
        }
        return MagicColor.NONE;
    }

    public String getTexPath(int meta, boolean f) {
        String s = "items/magic/pendant_" + names[meta];
        if (f) {
            s = "textures/" + s;
        }
        return "dcs_climate:" + s;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.UNCOMMON;
    }

    public float reduceDamage(DamageSource source, ItemStack charm) {
        if (this.getColor(charm.func_77952_i()) == MagicColor.WHITE) {
            float f = (float)charm.func_190916_E() * 10.0f;
            return f;
        }
        return 0.0f;
    }

    public boolean onDiffence(DamageSource source, EntityLivingBase owner, float damage, ItemStack charm) {
        return false;
    }

    public float increaceDamage(EntityLivingBase target, DamageSource source, ItemStack charm) {
        return 1.0f;
    }

    public boolean onAttacking(EntityLivingBase owner, EntityLivingBase target, DamageSource source, float damage, ItemStack charm) {
        if (this.getColor(charm.func_77952_i()) == MagicColor.BLACK) {
            int f = charm.func_190916_E();
            float eff = MainUtil.magicSuitEff(owner) * 0.5f;
            DCLogger.debugInfoLog((String)("stats " + f));
            if (owner != null && target != null) {
                if (owner instanceof EntityPlayer) {
                    ((EntityPlayer)owner).func_71024_bL().func_75122_a(f, eff);
                } else {
                    owner.func_70691_i((float)f * eff);
                }
            }
        }
        return false;
    }

    public boolean onPlayerAttacking(EntityPlayer owner, EntityLivingBase target, DamageSource source, float damage, ItemStack charm) {
        return this.onAttacking((EntityLivingBase)owner, target, source, damage, charm);
    }

    public boolean onToolUsing(EntityLivingBase owner, BlockPos pos, IBlockState state, ItemStack charm) {
        if (this.getColor(charm.func_77952_i()) == MagicColor.GREEN) {
            ItemStack item = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_180651_a(state));
            if (state.func_177230_c().isWood((IBlockAccess)owner.field_70170_p, pos) || MainUtil.hasDic(item, "logWood")) {
                Set<Object> set = new LinkedHashSet();
                set = MainUtil.getLumberTargetList(owner.field_70170_p, pos, state.func_177230_c(), 192);
                if (!owner.field_70170_p.field_72995_K) {
                    int count = 0;
                    for (BlockPos blockPos : set) {
                        owner.field_70170_p.func_175698_g(blockPos);
                        ++count;
                    }
                    while (count > 0) {
                        int i = 0;
                        i = count > 64 ? 64 : count;
                        count -= i;
                        ItemStack itemStack = item.func_77946_l();
                        itemStack.func_190920_e(i);
                        EntityItem dropE = new EntityItem(owner.field_70170_p, owner.field_70165_t, owner.field_70163_u + 0.5, owner.field_70161_v, itemStack);
                        owner.field_70170_p.func_72838_d((Entity)dropE);
                    }
                }
                return true;
            }
        }
        return false;
    }

    public void constantEffect(EntityLivingBase owner, ItemStack charm) {
        if (this.getColor(charm.func_77952_i()) == MagicColor.BLUE) {
            owner.func_70690_d(new PotionEffect(MobEffects.field_76427_o, 205, 0));
        }
    }

    public boolean onUsing(EntityPlayer owner, ItemStack charm) {
        return false;
    }

    public boolean isActive(ItemStack charm) {
        return true;
    }

    public void setActive(ItemStack charm, boolean flag) {
    }

    public ItemStack consumeCharmItem(ItemStack stack) {
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation2(ItemStack stack, @Nullable World world, List<String> tooltip) {
        String s = "";
        int meta = stack.func_77960_j();
        if (meta == 1 || meta == 2) {
            tooltip.add(TextFormatting.BOLD.toString() + "PLAYER ONLY");
        }
        tooltip.add(TextFormatting.AQUA.toString() + I18n.func_135052_a((String)("dcs.tip.color_pendant2." + meta), (Object[])new Object[0]));
        if (ClimateCore.proxy.isShiftKeyDown()) {
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Tips ===");
            tooltip.add(I18n.func_135052_a((String)"dcs.tip.allcharm", (Object[])new Object[0]));
            tooltip.add(TextFormatting.YELLOW.toString() + I18n.func_135052_a((String)("dcs.comment.color_pendant2." + meta), (Object[])new Object[0]));
        } else {
            tooltip.add(TextFormatting.RESET.toString() + I18n.func_135052_a((String)"dcs.tip.shift", (Object[])new Object[0]));
        }
    }
}

