/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.magic.item;

import defeatedcrow.hac.api.magic.CharmType;
import defeatedcrow.hac.api.magic.MagicColor;
import defeatedcrow.hac.api.magic.MagicType;
import defeatedcrow.hac.core.ClimateCore;
import defeatedcrow.hac.core.plugin.baubles.CharmItemBase;
import defeatedcrow.hac.main.MainInit;
import defeatedcrow.hac.main.util.MainUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemColorRing
extends CharmItemBase {
    private final int maxMeta;
    private static String[] names = new String[]{"u1", "g1", "r1", "b1", "w1"};

    public ItemColorRing() {
        this.maxMeta = 4;
        this.func_77625_d(1);
    }

    public int getMaxMeta() {
        return this.maxMeta;
    }

    public String[] getNameSuffix() {
        return names;
    }

    public String getTexPath(int meta, boolean f) {
        String s = "items/magic/ring_" + names[meta];
        if (f) {
            s = "textures/" + s;
        }
        return "dcs_climate:" + s;
    }

    public CharmType getCharmType(int meta) {
        switch (meta) {
            case 0: {
                return CharmType.SPECIAL;
            }
            case 1: {
                return CharmType.TOOL;
            }
            case 2: {
                return CharmType.CONSTANT;
            }
            case 3: {
                return CharmType.CONSTANT;
            }
            case 4: {
                return CharmType.DEFFENCE;
            }
        }
        return CharmType.SPECIAL;
    }

    public MagicType getType(int meta) {
        return MagicType.RING;
    }

    public MagicColor getColor(int meta) {
        switch (meta) {
            case 0: {
                return MagicColor.BLUE;
            }
            case 1: {
                return MagicColor.GREEN;
            }
            case 2: {
                return MagicColor.RED;
            }
            case 3: {
                return MagicColor.BLACK;
            }
            case 4: {
                return MagicColor.WHITE;
            }
        }
        return MagicColor.NONE;
    }

    public float reduceDamage(DamageSource source, ItemStack charm) {
        if (this.getColor(charm.func_77952_i()) == MagicColor.WHITE) {
            return 1.0f * (float)charm.func_190916_E();
        }
        return 0.0f;
    }

    public boolean onDiffence(DamageSource source, EntityLivingBase owner, float damage, ItemStack charm) {
        return false;
    }

    public float increaceDamage(EntityLivingBase target, DamageSource source, ItemStack charm) {
        return 1.0f;
    }

    public boolean onAttacking(EntityLivingBase owner, EntityLivingBase target, DamageSource source, float damage, ItemStack charm) {
        return false;
    }

    public boolean onPlayerAttacking(EntityPlayer owner, EntityLivingBase target, DamageSource source, float damage, ItemStack charm) {
        return this.onAttacking((EntityLivingBase)owner, target, source, damage, charm);
    }

    public boolean onToolUsing(EntityLivingBase owner, BlockPos pos, IBlockState state, ItemStack charm) {
        if (this.getColor(charm.func_77952_i()) == MagicColor.GREEN && !owner.field_70170_p.field_72995_K && state != null) {
            double a = MainUtil.magicSuitEff(owner) * 3.0f;
            AxisAlignedBB aabb = new AxisAlignedBB((double)pos.func_177958_n() - (a += (double)(charm.func_190916_E() * 2)), (double)pos.func_177956_o() - 2.0, (double)pos.func_177952_p() - a, (double)pos.func_177958_n() + a, (double)pos.func_177956_o() + 3.0, (double)pos.func_177952_p() + a);
            List drops = owner.field_70170_p.func_72872_a(EntityItem.class, aabb);
            for (EntityItem drop : drops) {
                drop.func_70107_b(owner.field_70165_t, owner.field_70163_u + 0.5, owner.field_70161_v);
            }
        }
        return false;
    }

    public void constantEffect(EntityLivingBase owner, ItemStack charm) {
        int l = charm.func_190916_E() - 1;
        if (l < 0) {
            l = 0;
        }
        if (MainUtil.magicSuitEff(owner) > 1.0f) {
            ++l;
        }
        if (this.getColor(charm.func_77952_i()) == MagicColor.RED) {
            owner.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 205, 0));
            owner.func_70690_d(new PotionEffect(MainInit.heavyboots, 205, l));
        } else if (this.getColor(charm.func_77952_i()) == MagicColor.BLACK) {
            owner.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 205, 0));
        } else if (this.getColor(charm.func_77952_i()) == MagicColor.WHITE) {
            owner.func_70690_d(new PotionEffect(MobEffects.field_76430_j, 205, l));
        }
    }

    public boolean onUsing(EntityPlayer owner, ItemStack charm) {
        return false;
    }

    public boolean isActive(ItemStack charm) {
        return true;
    }

    public void setActive(ItemStack charm, boolean flag) {
    }

    public ItemStack consumeCharmItem(ItemStack stack) {
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation2(ItemStack stack, @Nullable World world, List<String> tooltip) {
        String s = "";
        int meta = stack.func_77960_j();
        tooltip.add(TextFormatting.AQUA.toString() + I18n.func_135052_a((String)("dcs.tip.color_ring." + meta), (Object[])new Object[0]));
        if (ClimateCore.proxy.isShiftKeyDown()) {
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Tips ===");
            tooltip.add(I18n.func_135052_a((String)"dcs.tip.allcharm", (Object[])new Object[0]));
            tooltip.add(TextFormatting.YELLOW.toString() + I18n.func_135052_a((String)("dcs.comment.color_ring." + meta), (Object[])new Object[0]));
        } else {
            tooltip.add(TextFormatting.RESET.toString() + I18n.func_135052_a((String)"dcs.tip.shift", (Object[])new Object[0]));
        }
    }
}

