/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.magic.item;

import defeatedcrow.hac.api.magic.CharmType;
import defeatedcrow.hac.api.magic.MagicColor;
import defeatedcrow.hac.api.magic.MagicType;
import defeatedcrow.hac.core.ClimateCore;
import defeatedcrow.hac.core.plugin.baubles.CharmItemBase;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.main.MainInit;
import defeatedcrow.hac.main.util.MainUtil;
import defeatedcrow.hac.main.worldgen.vein.SkarnGenPos;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemColorRing2
extends CharmItemBase {
    private final int maxMeta;
    private static String[] names = new String[]{"u2", "g2", "r2", "b2", "w2"};

    public ItemColorRing2() {
        this.maxMeta = 4;
        this.func_77625_d(1);
    }

    public int getMaxMeta() {
        return this.maxMeta;
    }

    public String[] getNameSuffix() {
        return names;
    }

    public String getTexPath(int meta, boolean f) {
        String s = "items/magic/ring_" + names[meta];
        if (f) {
            s = "textures/" + s;
        }
        return "dcs_climate:" + s;
    }

    public CharmType getCharmType(int meta) {
        switch (meta) {
            case 0: {
                return CharmType.SPECIAL;
            }
            case 1: {
                return CharmType.KEY;
            }
            case 2: {
                return CharmType.CONSTANT;
            }
            case 3: {
                return CharmType.ATTACK;
            }
            case 4: {
                return CharmType.CONSTANT;
            }
        }
        return CharmType.SPECIAL;
    }

    public MagicType getType(int meta) {
        return MagicType.RING;
    }

    public MagicColor getColor(int meta) {
        switch (meta) {
            case 0: {
                return MagicColor.BLUE;
            }
            case 1: {
                return MagicColor.GREEN;
            }
            case 2: {
                return MagicColor.RED;
            }
            case 3: {
                return MagicColor.BLACK;
            }
            case 4: {
                return MagicColor.WHITE;
            }
        }
        return MagicColor.NONE;
    }

    public float reduceDamage(DamageSource source, ItemStack charm) {
        return 0.0f;
    }

    public boolean onDiffence(DamageSource source, EntityLivingBase owner, float damage, ItemStack charm) {
        return false;
    }

    public float increaceDamage(EntityLivingBase target, DamageSource source, ItemStack charm) {
        return 1.0f;
    }

    public boolean onAttacking(EntityLivingBase owner, EntityLivingBase target, DamageSource source, float damage, ItemStack charm) {
        if (this.getColor(charm.func_77952_i()) == MagicColor.BLACK && target != null && !owner.field_70170_p.field_72995_K) {
            int r = field_77697_d.nextInt(3);
            if (r > 0) {
                EntityXPOrb orb = new EntityXPOrb(owner.field_70170_p, target.field_70165_t, target.field_70163_u, target.field_70161_v, r);
                owner.field_70170_p.func_72838_d((Entity)orb);
            }
            return true;
        }
        return false;
    }

    public boolean onPlayerAttacking(EntityPlayer owner, EntityLivingBase target, DamageSource source, float damage, ItemStack charm) {
        return this.onAttacking((EntityLivingBase)owner, target, source, damage, charm);
    }

    public boolean onToolUsing(EntityLivingBase owner, BlockPos pos, IBlockState state, ItemStack charm) {
        return false;
    }

    public void constantEffect(EntityLivingBase owner, ItemStack charm) {
        int l = charm.func_190916_E() - 1;
        if (l < 0) {
            l = 0;
        }
        if (MainUtil.magicSuitEff(owner) > 1.0f) {
            ++l;
        }
        if (this.getColor(charm.func_77952_i()) == MagicColor.RED) {
            owner.func_70690_d(new PotionEffect(MainInit.nimble, 205, l));
        } else if (this.getColor(charm.func_77952_i()) == MagicColor.WHITE) {
            if (owner.func_70027_ad()) {
                owner.func_70066_B();
            }
            ArrayList<PotionEffect> removes = new ArrayList<PotionEffect>();
            Collection target = owner.func_70651_bq();
            for (PotionEffect check : target) {
                Potion p = check.func_188419_a();
                if (p == null || !p.func_76398_f()) continue;
                removes.add(check);
            }
            for (PotionEffect ret : removes) {
                owner.func_184589_d(ret.func_188419_a());
            }
        }
    }

    public boolean onUsing(EntityPlayer owner, ItemStack charm) {
        if (this.getColor(charm.func_77952_i()) == MagicColor.GREEN) {
            float eff;
            int cz;
            int cx;
            BlockPos center;
            int l = charm.func_190916_E();
            int x = MathHelper.func_76128_c((double)owner.field_70165_t);
            int y = MathHelper.func_76128_c((double)owner.field_70163_u);
            int z = MathHelper.func_76128_c((double)owner.field_70161_v);
            BlockPos p = new BlockPos(x, y, z);
            LinkedHashMap<BlockPos, ItemStack> map = new LinkedHashMap<BlockPos, ItemStack>();
            BlockPos air = null;
            int count = 0;
            for (int i = 1; i < y; ++i) {
                ItemStack target;
                BlockPos pos = p.func_177979_c(i);
                IBlockState state = owner.func_130014_f_().func_180495_p(pos);
                if (state == null) continue;
                if (i > 1 && air == null && owner.func_130014_f_().func_175623_d(pos)) {
                    air = pos;
                }
                if (this.isOre(target = new ItemStack(Item.func_150898_a((Block)state.func_177230_c()), 1, state.func_177230_c().func_176201_c(state)))) {
                    map.put(pos, target);
                    ++count;
                }
                if (count > l) break;
            }
            if ((center = SkarnGenPos.getNearestPoint(cx = x >> 4, cz = z >> 4, owner.field_70170_p, (int)(8.0f * (eff = MainUtil.magicSuitEff((EntityLivingBase)owner))))) != null && !SkarnGenPos.isDupe(center, owner.field_70170_p)) {
                owner.func_145747_a((ITextComponent)new TextComponentString("== Nearby Skarn detected =="));
                owner.func_145747_a((ITextComponent)new TextComponentString("* Center Coodinate: " + center.func_177958_n() + ", 40, " + center.func_177952_p() + " *"));
            }
            if (air != null) {
                owner.func_145747_a((ITextComponent)new TextComponentString("== Cavity ditected: Y=" + air.func_177956_o() + " =="));
            }
            if (!map.isEmpty()) {
                owner.func_145747_a((ITextComponent)new TextComponentString("== Ore block detected =="));
                for (Map.Entry v : map.entrySet()) {
                    owner.func_145747_a((ITextComponent)new TextComponentString("* " + ((ItemStack)v.getValue()).func_82833_r() + ": Y=" + ((BlockPos)v.getKey()).func_177956_o() + " *"));
                }
            } else {
                owner.func_145747_a((ITextComponent)new TextComponentString("== No ore block detected in this coordinate =="));
            }
            return true;
        }
        return false;
    }

    public boolean isActive(ItemStack charm) {
        return true;
    }

    public void setActive(ItemStack charm, boolean flag) {
    }

    public ItemStack consumeCharmItem(ItemStack stack) {
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation2(ItemStack stack, @Nullable World world, List<String> tooltip) {
        String s = "";
        int meta = stack.func_77960_j();
        if (meta == 0 || meta == 1) {
            tooltip.add(TextFormatting.BOLD.toString() + "PLAYER ONLY");
        }
        tooltip.add(TextFormatting.AQUA.toString() + I18n.func_135052_a((String)("dcs.tip.color_ring2." + meta), (Object[])new Object[0]));
        if (ClimateCore.proxy.isShiftKeyDown()) {
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Tips ===");
            tooltip.add(I18n.func_135052_a((String)"dcs.tip.allcharm", (Object[])new Object[0]));
            tooltip.add(TextFormatting.YELLOW.toString() + I18n.func_135052_a((String)("dcs.comment.color_ring2." + meta), (Object[])new Object[0]));
        } else {
            tooltip.add(TextFormatting.RESET.toString() + I18n.func_135052_a((String)"dcs.tip.shift", (Object[])new Object[0]));
        }
    }

    private boolean isOre(ItemStack target) {
        int[] ids;
        if (DCUtil.isEmpty((ItemStack)target)) {
            return false;
        }
        for (int i : ids = OreDictionary.getOreIDs((ItemStack)target)) {
            String name = OreDictionary.getOreName((int)i);
            if (name == null || !name.contains("ore")) continue;
            return true;
        }
        return false;
    }
}

