/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.magic.proj;

import defeatedcrow.hac.api.climate.ClimateAPI;
import defeatedcrow.hac.api.climate.DCAirflow;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.climate.DCHumidity;
import defeatedcrow.hac.api.climate.IClimate;
import defeatedcrow.hac.api.damage.DamageSourceClimate;
import defeatedcrow.hac.api.recipe.IClimateSmelting;
import defeatedcrow.hac.api.recipe.RecipeAPI;
import defeatedcrow.hac.core.DCLogger;
import defeatedcrow.hac.core.base.FoodEntityBase;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.magic.proj.EntityMobBarrier;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityFireBarrier
extends EntityMobBarrier {
    public EntityFireBarrier(World worldIn) {
        super(worldIn);
        this.func_70105_a(8.0f, 3.0f);
    }

    public EntityFireBarrier(World worldIn, double posX, double posY, double posZ) {
        this(worldIn);
        this.func_70107_b(posX, posY, posZ);
    }

    public EntityFireBarrier(World worldIn, double posX, double posY, double posZ, @Nullable EntityPlayer player) {
        this(worldIn, posX, posY, posZ);
        if (player != null) {
            this.field_70177_z = player.field_70177_z;
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if ((this.totalAge & 0x1F) == 0 && !this.field_70170_p.field_72995_K) {
            this.burnBlock();
            this.burnEntity();
        }
    }

    public void burnBlock() {
        int sx = this.func_180425_c().func_177958_n() - 4;
        int sy = this.func_180425_c().func_177956_o() - 1;
        int sz = this.func_180425_c().func_177952_p() - 4;
        int mx = this.func_180425_c().func_177958_n() + 4;
        int my = this.func_180425_c().func_177956_o() + 2;
        int mz = this.func_180425_c().func_177952_p() + 4;
        Iterable itr = BlockPos.func_191532_a((int)sx, (int)sy, (int)sz, (int)mx, (int)my, (int)mz);
        for (BlockPos p1 : itr) {
            Block ret;
            IBlockState retS;
            ItemStack output;
            IBlockState state = this.field_70170_p.func_180495_p(p1);
            if (state.func_177230_c() == Blocks.field_150350_a || state.func_185904_a() == Material.field_151579_a) continue;
            int meta = state.func_177230_c().func_180651_a(state);
            ItemStack check = new ItemStack(state.func_177230_c(), 1, meta);
            IClimate clm = ClimateAPI.register.getClimateFromParam(DCHeatTier.KILN, DCHumidity.NORMAL, DCAirflow.TIGHT);
            IClimateSmelting recipe = RecipeAPI.registerSmelting.getRecipe(clm, check);
            if (recipe == null) {
                clm = ClimateAPI.register.getClimateFromParam(DCHeatTier.UHT, DCHumidity.NORMAL, DCAirflow.TIGHT);
                recipe = RecipeAPI.registerSmelting.getRecipe(clm, check);
            }
            if (recipe == null || !recipe.additionalRequire(this.field_70170_p, p1) || DCUtil.isEmpty((ItemStack)(output = recipe.getOutput())) || !(output.func_77973_b() instanceof ItemBlock) || !this.field_70170_p.func_180501_a(p1, retS = (ret = ((ItemBlock)output.func_77973_b()).func_179223_d()).func_176203_a(output.func_77960_j()), 2)) continue;
            this.field_70170_p.func_175685_c(p1, ret, true);
            this.field_70170_p.func_184133_a(null, p1, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.8f, 2.0f);
            DCLogger.debugLog((String)("Smelting! " + output.func_82833_r()));
        }
    }

    public void burnEntity() {
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ());
        if (!list.isEmpty()) {
            for (Entity e : list) {
                if (e instanceof FoodEntityBase) {
                    FoodEntityBase food = (FoodEntityBase)e;
                    food.setRAW(false);
                    food.func_184185_a(SoundEvents.field_187646_bt, 1.0f, 1.0f);
                    continue;
                }
                if (!(e instanceof EntityLivingBase)) continue;
                EntityLivingBase living = (EntityLivingBase)e;
                living.func_70097_a((DamageSource)DamageSourceClimate.climateHeatDamage, 4.0f);
            }
        }
    }

    @Override
    public void func_70108_f(Entity entity) {
    }

    @Override
    @Nullable
    public AxisAlignedBB func_70114_g(Entity entity) {
        return null;
    }
}

