/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.api.orevein;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import defeatedcrow.hac.api.climate.BlockSet;
import defeatedcrow.hac.core.DCLogger;
import defeatedcrow.hac.main.api.orevein.EnumVein;
import defeatedcrow.hac.main.api.orevein.IVeinTable;
import defeatedcrow.hac.main.api.orevein.OreSet;
import defeatedcrow.hac.main.worldgen.vein.OreSetDC;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;

public class VeinTable
implements IVeinTable {
    public final List<OreSet> table = new ArrayList<OreSet>();
    public OreSet layerStone;
    public final EnumVein vein;
    public int tableCount = 1;

    public VeinTable(EnumVein veinIn, @Nonnull OreSet layer1) {
        this.layerStone = layer1;
        this.vein = veinIn;
    }

    public void addOres(List<OreSet> stacks) {
        for (OreSet ore : stacks) {
            if (ore.getWeight() <= 0) continue;
            this.table.add(ore);
            this.tableCount += ore.getWeight();
            DCLogger.debugTrace((String)("- Oreset: " + ore.getOre().toString() + " " + ore.getWeight()));
            if (!ore.hasSecondOre()) continue;
            DCLogger.debugTrace((String)("-- Secondary: " + ore.getSecondOre().toString() + " " + ore.getSecondChance()));
        }
    }

    @Override
    public OreSet getLayerBlock() {
        return this.layerStone;
    }

    @Override
    public EnumVein getType() {
        return this.vein;
    }

    @Override
    public List<OreSet> getOreTable() {
        ImmutableList ret = ImmutableList.copyOf(this.table);
        return ret;
    }

    @Override
    public void addOreToTable(int weight, Block block, int meta) {
        if (block != null && weight > 0) {
            BlockSet set = new BlockSet(block, meta);
            this.table.add(new OreSetDC(weight, set));
            this.tableCount += weight;
        }
    }

    @Override
    public void addOreToTable(int weight, Block block, int meta, Block secondBlock, int secondMeta, int secondChance) {
        if (block != null && secondBlock != null && weight > 0) {
            BlockSet set = new BlockSet(block, meta);
            BlockSet set2 = new BlockSet(block, meta);
            this.table.add(new OreSetDC(weight, set, set2, secondChance));
            this.tableCount += weight;
        }
    }

    @Override
    public void removeOreFromTable(Block block, int meta) {
        if (block != null) {
            BlockSet set = new BlockSet(block, meta);
            ArrayList removes = Lists.newArrayList();
            for (OreSet target : this.table) {
                if (!target.getOre().equals((Object)set)) continue;
                removes.add(target);
            }
            for (OreSet del : removes) {
                this.table.remove(del);
                this.tableCount -= del.getWeight();
            }
        }
    }
}

