/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.block.build;

import com.google.common.collect.Lists;
import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.climate.IHeatTile;
import defeatedcrow.hac.core.base.BlockDC;
import defeatedcrow.hac.core.base.INameSuffix;
import defeatedcrow.hac.core.base.ITexturePath;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCoolantPackage
extends BlockDC
implements ITexturePath,
INameSuffix,
IHeatTile {
    protected static final AxisAlignedBB AABB_MAIN = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.1875, 0.875);
    public final int maxMeta;

    public BlockCoolantPackage(String s) {
        super(Material.field_151580_n, s);
        this.func_149711_c(0.2f);
        this.func_149752_b(1.0f);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)DCState.TYPE4, (Comparable)Integer.valueOf(0)));
        this.func_149675_a(true);
        this.maxMeta = 3;
    }

    public int func_149738_a(World world) {
        return 100;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(world, pos, state, rand);
        int type = DCState.getInt((IBlockState)state, (PropertyInteger)DCState.TYPE4);
        if (!world.field_72995_K && type > -1 && type != 3 && world.field_73012_v.nextInt(10) == 0) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)DCState.TYPE4, (Comparable)Integer.valueOf(type + 1)));
        }
    }

    public List<ItemStack> getSubItemList() {
        ArrayList list = Lists.newArrayList();
        list.add(new ItemStack((Block)this, 1, 0));
        return list;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB_MAIN;
    }

    public int func_180651_a(IBlockState state) {
        int i = (Integer)state.func_177229_b((IProperty)DCState.TYPE4);
        if (i > this.maxMeta) {
            i = this.maxMeta;
        }
        return i;
    }

    public IBlockState func_176203_a(int meta) {
        int i = meta & 3;
        if (i > this.maxMeta) {
            i = this.maxMeta;
        }
        IBlockState state = this.func_176223_P().func_177226_a((IProperty)DCState.TYPE4, (Comparable)Integer.valueOf(i));
        return state;
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i = (Integer)state.func_177229_b((IProperty)DCState.TYPE4);
        if (i > this.maxMeta) {
            i = this.maxMeta;
        }
        return i;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DCState.TYPE4});
    }

    public String[] getNameSuffix() {
        return null;
    }

    public String getTexPath(int meta, boolean f) {
        if (meta > this.getMaxMeta()) {
            meta = this.getMaxMeta();
        }
        String s = "blocks/build/desiccant_" + meta;
        if (f) {
            s = "textures/" + s;
        }
        return "dcs_climate:" + s;
    }

    public int getMaxMeta() {
        return this.maxMeta;
    }

    public DCHeatTier getHeatTier(World world, BlockPos target, BlockPos source) {
        IBlockState state = world.func_180495_p(source);
        int type = DCState.getInt((IBlockState)state, (PropertyInteger)DCState.TYPE4);
        return type == 3 ? DCHeatTier.NORMAL : DCHeatTier.COLD;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

