/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.block.build;

import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.api.climate.DCHumidity;
import defeatedcrow.hac.api.climate.IHumidityTile;
import defeatedcrow.hac.core.base.DCSimpleBlock;
import defeatedcrow.hac.core.base.ITexturePath;
import net.minecraft.block.BlockBush;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFlowerVase
extends DCSimpleBlock
implements ITexturePath,
IHumidityTile {
    protected static final AxisAlignedBB AABB_FULL = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_MIDDLE = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);
    private static String[] names = new String[]{"planter", "white", "blue", "pink", "gray", "orange", "green"};

    public BlockFlowerVase(Material m, String s) {
        super(m, s, 4, false);
        this.func_149675_a(false);
        this.func_149711_c(1.0f);
        this.func_149752_b(30.0f);
    }

    public boolean canClimateUpdate(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if ((Integer)state.func_177229_b((IProperty)DCState.TYPE16) == 0) {
            return AABB_FULL;
        }
        return AABB_MIDDLE;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        boolean b;
        boolean bl = b = world.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151579_a;
        return !b && world.func_180495_p(pos.func_177972_a(face)).func_185904_a() == Material.field_151586_h;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return DCState.getInt((IBlockState)blockState, (PropertyInteger)DCState.TYPE16) != 0;
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        IBlockState plant = plantable.getPlant(world, pos.func_177972_a(direction));
        EnumPlantType plantType = plantable.getPlantType(world, pos.func_177972_a(direction));
        if (plantable instanceof BlockBush || plantType == EnumPlantType.Plains) {
            return true;
        }
        if (DCState.getInt((IBlockState)state, (PropertyInteger)DCState.TYPE16) == 0) {
            return plantType != EnumPlantType.Water && plantType != EnumPlantType.Nether;
        }
        return false;
    }

    public boolean isFertile(World world, BlockPos pos) {
        IBlockState plant = world.func_180495_p(pos);
        return DCState.getInt((IBlockState)plant, (PropertyInteger)DCState.TYPE16) == 0;
    }

    public int getMaxMeta() {
        return 4;
    }

    public String[] getNameSuffix() {
        return names;
    }

    public String getTexPath(int meta, boolean f) {
        if (meta > this.getMaxMeta()) {
            meta = this.getMaxMeta();
        }
        String s = "blocks/build/vase_" + names[meta];
        if (f) {
            s = "textures/" + s;
        }
        return "dcs_climate:" + s;
    }

    public DCHumidity getHumidity(World world, BlockPos targrt, BlockPos source) {
        return DCHumidity.WET;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.MIDDLE_POLE;
    }
}

