/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.block.build;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.core.base.BlockContainerDC;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMetalFenceBase
extends BlockContainerDC {
    public static final PropertyBool UPPER = PropertyBool.func_177716_a((String)"upper");
    public static final PropertyBool UNDER = PropertyBool.func_177716_a((String)"under");
    public static final PropertyDirection BACK_FACING = PropertyDirection.func_177712_a((String)"back_facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyBool BACK_UPPER = PropertyBool.func_177716_a((String)"back_upper");
    public static final PropertyBool BACK_UNDER = PropertyBool.func_177716_a((String)"back_under");
    public static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.125, 0.0, 0.875, 0.875, 1.0, 1.0);
    public static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.0, 0.0, 0.125, 0.125, 1.0, 0.875);
    public static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.125, 0.0, 0.0, 0.875, 1.0, 0.125);
    public static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.875, 0.0, 0.125, 1.0, 1.0, 0.875);
    public static final AxisAlignedBB SOUTH_BOX = new AxisAlignedBB(0.0, 0.0, 0.75, 1.0, 1.0, 1.0);
    public static final AxisAlignedBB WEST_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 0.25, 1.0, 1.0);
    public static final AxisAlignedBB NORTH_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.25);
    public static final AxisAlignedBB EAST_BOX = new AxisAlignedBB(0.75, 0.0, 0.0, 1.0, 1.0, 1.0);

    public BlockMetalFenceBase(String s, boolean b) {
        super(b ? Material.field_151592_s : Material.field_151571_B, s);
        this.func_149711_c(0.5f);
        this.func_149752_b(10.0f);
        this.field_149787_q = false;
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)DCState.FACING, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)BACK_FACING, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)UPPER, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)UNDER, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BACK_UPPER, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BACK_UNDER, (Comparable)Boolean.valueOf(false)));
    }

    public boolean canConnectTo(IBlockAccess worldIn, BlockPos pos, EnumFacing face) {
        IBlockState state = worldIn.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == this) {
            return DCState.getFace((IBlockState)state, (PropertyDirection)DCState.FACING) == face;
        }
        return false;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        EnumFacing face = DCState.getFace((IBlockState)state, (PropertyDirection)DCState.FACING);
        if (face != null) {
            boolean under = this.canConnectTo(worldIn, pos.func_177977_b(), face);
            boolean upper = this.canConnectTo(worldIn, pos.func_177984_a(), face);
            state = state.func_177226_a((IProperty)UPPER, (Comparable)Boolean.valueOf(upper)).func_177226_a((IProperty)UNDER, (Comparable)Boolean.valueOf(under));
            BlockPos back = pos.func_177972_a(face.func_176734_d());
            IBlockState b = worldIn.func_180495_p(back);
            if (b != null && b.func_177230_c() == this) {
                EnumFacing b_face = DCState.getFace((IBlockState)b, (PropertyDirection)DCState.FACING);
                boolean b_under = this.canConnectTo(worldIn, back.func_177977_b(), b_face);
                boolean b_upper = this.canConnectTo(worldIn, back.func_177984_a(), b_face);
                state = state.func_177226_a((IProperty)BACK_FACING, (Comparable)b_face).func_177226_a((IProperty)BACK_UPPER, (Comparable)Boolean.valueOf(b_upper)).func_177226_a((IProperty)BACK_UNDER, (Comparable)Boolean.valueOf(b_under));
            } else {
                state = state.func_177226_a((IProperty)BACK_FACING, (Comparable)face).func_177226_a((IProperty)BACK_UPPER, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BACK_UNDER, (Comparable)Boolean.valueOf(false));
            }
            return state;
        }
        return this.func_176223_P();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        EnumFacing face = DCState.getFace((IBlockState)state, (PropertyDirection)DCState.FACING);
        if (face == null) {
            return super.func_185499_a(state, rot);
        }
        switch (rot) {
            case CLOCKWISE_180: {
                return state.func_177226_a((IProperty)DCState.FACING, (Comparable)face.func_176734_d()).func_177226_a((IProperty)BACK_FACING, (Comparable)face.func_176734_d());
            }
            case COUNTERCLOCKWISE_90: {
                return state.func_177226_a((IProperty)DCState.FACING, (Comparable)face.func_176746_e()).func_177226_a((IProperty)BACK_FACING, (Comparable)face.func_176746_e());
            }
            case CLOCKWISE_90: {
                return state.func_177226_a((IProperty)DCState.FACING, (Comparable)face.func_176735_f()).func_177226_a((IProperty)BACK_FACING, (Comparable)face.func_176735_f());
            }
        }
        return state;
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        EnumFacing face = DCState.getFace((IBlockState)state, (PropertyDirection)DCState.FACING);
        if (face == null) {
            return super.func_185471_a(state, mirrorIn);
        }
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return state.func_177226_a((IProperty)DCState.FACING, (Comparable)face.func_176734_d()).func_177226_a((IProperty)BACK_FACING, (Comparable)face.func_176734_d());
            }
            case FRONT_BACK: {
                return state.func_177226_a((IProperty)DCState.FACING, (Comparable)face.func_176734_d()).func_177226_a((IProperty)BACK_FACING, (Comparable)face.func_176734_d());
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DCState.FACING, BACK_FACING, UPPER, UNDER, BACK_UNDER, BACK_UPPER});
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing face = DCState.getFace((IBlockState)state, (PropertyDirection)DCState.FACING);
        switch (face) {
            case NORTH: {
                return NORTH_BOX;
            }
            case SOUTH: {
                return SOUTH_BOX;
            }
            case WEST: {
                return WEST_BOX;
            }
            case EAST: {
                return EAST_BOX;
            }
        }
        return SOUTH_BOX;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        if (!isActualState) {
            state = state.func_185899_b((IBlockAccess)world, pos);
        }
        EnumFacing main = DCState.getFace((IBlockState)state, (PropertyDirection)DCState.FACING);
        EnumFacing back = DCState.getFace((IBlockState)state, (PropertyDirection)BACK_FACING);
        if (main == EnumFacing.EAST || back == EnumFacing.EAST) {
            BlockMetalFenceBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)EAST_AABB);
        }
        if (main == EnumFacing.WEST || back == EnumFacing.WEST) {
            BlockMetalFenceBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)WEST_AABB);
        }
        if (main == EnumFacing.SOUTH || back == EnumFacing.SOUTH) {
            BlockMetalFenceBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SOUTH_AABB);
        }
        if (main == EnumFacing.NORTH || back == EnumFacing.NORTH) {
            BlockMetalFenceBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)NORTH_AABB);
        }
    }

    protected boolean func_149700_E() {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        IBlockState state2 = worldIn.func_180495_p(pos);
        EnumFacing face = DCState.getFace((IBlockState)state2, (PropertyDirection)DCState.FACING);
        return face == side;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (side == EnumFacing.UP) {
            IBlockState up = world.func_180495_p(pos.func_177984_a());
            return up == null || up.func_177230_c() != this;
        }
        if (side == EnumFacing.DOWN) {
            IBlockState ud = world.func_180495_p(pos.func_177977_b());
            return ud == null || ud.func_177230_c() != this;
        }
        return true;
    }

    public List<ItemStack> getSubItemList() {
        ArrayList list = Lists.newArrayList();
        list.add(new ItemStack((Block)this, 1, 0));
        return list;
    }

    public IBlockState getPlaceState(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = super.getPlaceState(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
        if (placer != null) {
            EnumFacing face = placer.func_174811_aO();
            state = state.func_177226_a((IProperty)DCState.FACING, (Comparable)face);
        } else {
            if (facing == EnumFacing.DOWN || facing == EnumFacing.UP) {
                facing = EnumFacing.NORTH;
            }
            state = state.func_177226_a((IProperty)DCState.FACING, (Comparable)facing.func_176734_d());
        }
        return state;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)state.func_177230_c());
    }

    public IBlockState func_176203_a(int meta) {
        int i = meta & 3;
        IBlockState state = this.func_176223_P().func_177226_a((IProperty)DCState.FACING, (Comparable)EnumFacing.func_82600_a((int)(5 - i)));
        return state;
    }

    public int func_176201_c(IBlockState state) {
        int i = 5 - ((EnumFacing)state.func_177229_b((IProperty)DCState.FACING)).func_176745_a();
        return i;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        boolean b;
        boolean bl = b = world.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151579_a;
        return !b && world.func_180495_p(pos.func_177972_a(face)).func_185904_a() == Material.field_151586_h;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return null;
    }
}

